/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1844;
import net.minecraft.class_6880;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractArrow;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftArrow
extends CraftAbstractArrow
implements Arrow {
    public CraftArrow(CraftServer server, class_1667 entity) {
        super(server, (class_1665)entity);
    }

    public class_1667 getHandle() {
        return (class_1667)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    @Override
    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        if (this.hasCustomEffect(effect.getType())) {
            if (!override) {
                return false;
            }
            this.removeCustomEffect(effect.getType());
        }
        this.getHandle().method_7463(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().method_7462();
        return true;
    }

    @Override
    public void clearCustomEffects() {
        class_1844 old = this.getHandle().method_57315();
        this.getHandle().method_57316(new class_1844(old.comp_2378(), old.comp_2379(), List.of()));
        this.getHandle().method_7462();
    }

    @Override
    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_1293 effect : this.getHandle().method_57315().comp_2380()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public boolean hasCustomEffect(PotionEffectType type) {
        for (class_1293 effect : this.getHandle().method_57315().comp_2380()) {
            if (!CraftPotionUtil.equals((class_6880<class_1291>)effect.method_5579(), type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomEffects() {
        return !this.getHandle().method_57315().comp_2380().isEmpty();
    }

    @Override
    public boolean removeCustomEffect(PotionEffectType effect) {
        if (!this.hasCustomEffect(effect)) {
            return false;
        }
        class_6880<class_1291> minecraft = CraftPotionEffectType.bukkitToMinecraftHolder(effect);
        class_1844 old = this.getHandle().method_57315();
        this.getHandle().method_57316(new class_1844(old.comp_2378(), old.comp_2379(), old.comp_2380().stream().filter(mobEffect -> !mobEffect.method_5579().equals((Object)minecraft)).toList()));
        return true;
    }

    @Override
    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    @Override
    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    @Override
    public void setBasePotionType(PotionType potionType) {
        if (potionType != null) {
            this.getHandle().method_57316(this.getHandle().method_57315().method_57403(CraftPotionType.bukkitToMinecraftHolder(potionType)));
        } else {
            class_1844 old = this.getHandle().method_57315();
            this.getHandle().method_57316(new class_1844(Optional.empty(), old.comp_2379(), old.comp_2380()));
        }
    }

    @Override
    public PotionType getBasePotionType() {
        return this.getHandle().method_57315().comp_2378().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    @Override
    public void setColor(Color color) {
        int colorRGB = color == null ? -1 : color.asRGB();
        class_1844 old = this.getHandle().method_57315();
        this.getHandle().method_57316(new class_1844(old.comp_2378(), Optional.of(colorRGB), old.comp_2380()));
    }

    @Override
    public Color getColor() {
        if (this.getHandle().method_7460() <= -1) {
            return null;
        }
        return Color.fromRGB(this.getHandle().method_7460());
    }
}

