/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, class_1690 entity) {
        super(server, (class_1297)entity);
    }

    @Override
    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().method_47885());
    }

    @Override
    public void setWoodType(TreeSpecies species) {
        this.getHandle().method_47884(CraftBoat.getBoatType(species));
    }

    @Override
    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().method_47885());
    }

    @Override
    public void setBoatType(Boat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Boat.Type cannot be null");
        this.getHandle().method_47884(CraftBoat.boatTypeToNms(type));
    }

    @Override
    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    @Override
    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    @Override
    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    @Override
    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    @Override
    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    @Override
    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    @Override
    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    @Override
    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    @Override
    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().field_7702);
    }

    public class_1690 getHandle() {
        return (class_1690)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf((Object)this.getBoatType()) + ",status=" + String.valueOf((Object)this.getStatus()) + ",passengers=" + this.getPassengers().stream().map((Function<Entity, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/bukkit/entity/Entity;)Ljava/lang/String;)()).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(class_1690.class_1692 boatType) {
        return switch (boatType) {
            default -> throw new EnumConstantNotPresentException(Boat.Type.class, boatType.name());
            case class_1690.class_1692.field_7727 -> Boat.Type.OAK;
            case class_1690.class_1692.field_7729 -> Boat.Type.BIRCH;
            case class_1690.class_1692.field_7725 -> Boat.Type.ACACIA;
            case class_1690.class_1692.field_42681 -> Boat.Type.CHERRY;
            case class_1690.class_1692.field_7730 -> Boat.Type.JUNGLE;
            case class_1690.class_1692.field_7728 -> Boat.Type.SPRUCE;
            case class_1690.class_1692.field_7723 -> Boat.Type.DARK_OAK;
            case class_1690.class_1692.field_37506 -> Boat.Type.MANGROVE;
            case class_1690.class_1692.field_40161 -> Boat.Type.BAMBOO;
        };
    }

    public static class_1690.class_1692 boatTypeToNms(Boat.Type type) {
        return switch (type) {
            default -> throw new EnumConstantNotPresentException(class_1690.class_1692.class, type.name());
            case Boat.Type.BAMBOO -> class_1690.class_1692.field_40161;
            case Boat.Type.MANGROVE -> class_1690.class_1692.field_37506;
            case Boat.Type.SPRUCE -> class_1690.class_1692.field_7728;
            case Boat.Type.DARK_OAK -> class_1690.class_1692.field_7723;
            case Boat.Type.JUNGLE -> class_1690.class_1692.field_7730;
            case Boat.Type.CHERRY -> class_1690.class_1692.field_42681;
            case Boat.Type.ACACIA -> class_1690.class_1692.field_7725;
            case Boat.Type.BIRCH -> class_1690.class_1692.field_7729;
            case Boat.Type.OAK -> class_1690.class_1692.field_7727;
        };
    }

    public static Boat.Status boatStatusFromNms(class_1690.class_1691 enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case class_1690.class_1691.field_7720 -> Boat.Status.IN_AIR;
            case class_1690.class_1691.field_7719 -> Boat.Status.ON_LAND;
            case class_1690.class_1691.field_7717 -> Boat.Status.UNDER_WATER;
            case class_1690.class_1691.field_7716 -> Boat.Status.UNDER_FLOWING_WATER;
            case class_1690.class_1691.field_7718 -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(class_1690.class_1692 boatType) {
        switch (boatType) {
            case field_7728: {
                return TreeSpecies.REDWOOD;
            }
            case field_7729: {
                return TreeSpecies.BIRCH;
            }
            case field_7730: {
                return TreeSpecies.JUNGLE;
            }
            case field_7725: {
                return TreeSpecies.ACACIA;
            }
            case field_7723: {
                return TreeSpecies.DARK_OAK;
            }
        }
        return TreeSpecies.GENERIC;
    }

    @Deprecated
    public static class_1690.class_1692 getBoatType(TreeSpecies species) {
        switch (species) {
            case REDWOOD: {
                return class_1690.class_1692.field_7728;
            }
            case BIRCH: {
                return class_1690.class_1692.field_7729;
            }
            case JUNGLE: {
                return class_1690.class_1692.field_7730;
            }
            case ACACIA: {
                return class_1690.class_1692.field_7725;
            }
            case DARK_OAK: {
                return class_1690.class_1692.field_7723;
            }
        }
        return class_1690.class_1692.field_7727;
    }
}

