/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1321;
import net.minecraft.class_1451;
import net.minecraft.class_1767;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7375;
import net.minecraft.class_7924;
import org.bukkit.DyeColor;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Cat;

public class CraftCat
extends CraftTameableAnimal
implements Cat {
    public CraftCat(CraftServer server, class_1451 entity) {
        super(server, (class_1321)entity);
    }

    public class_1451 getHandle() {
        return (class_1451)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftCat";
    }

    @Override
    public Cat.Type getCatType() {
        return CraftType.minecraftHolderToBukkit((class_6880<class_7375>)this.getHandle().method_47843());
    }

    @Override
    public void setCatType(Cat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot have null Type");
        this.getHandle().method_47842(CraftType.bukkitToMinecraftHolder(type));
    }

    @Override
    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)this.getHandle().method_16096().method_7789());
    }

    @Override
    public void setCollarColor(DyeColor color) {
        this.getHandle().method_16094(class_1767.method_7791((int)color.getWoolData()));
    }

    public static class CraftType {
        public static Cat.Type minecraftToBukkit(class_7375 minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41259);
            return Registry.CAT_VARIANT.get(CraftNamespacedKey.fromMinecraft(registry.method_10221((Object)minecraft)));
        }

        public static Cat.Type minecraftHolderToBukkit(class_6880<class_7375> minecraft) {
            return CraftType.minecraftToBukkit((class_7375)minecraft.comp_349());
        }

        public static class_7375 bukkitToMinecraft(Cat.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41259);
            return (class_7375)registry.method_10223(CraftNamespacedKey.toMinecraft(bukkit.getKey()));
        }

        public static class_6880<class_7375> bukkitToMinecraftHolder(Cat.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41259);
            class_6880 class_68802 = registry.method_47983((Object)CraftType.bukkitToMinecraft(bukkit));
            if (class_68802 instanceof class_6880.class_6883) {
                class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
                return holder;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own cat variant with out properly registering it.");
        }
    }
}

