/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5454;
import net.minecraft.class_5629;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftSound;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.spigotmc.AsyncCatcher;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    protected final CraftServer server;
    protected class_1297 entity;
    private final EntityType entityType;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private final Entity.Spigot spigot = new Entity.Spigot(this){

        @Override
        public void sendMessage(BaseComponent component) {
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    public CraftEntity(CraftServer server, class_1297 entity) {
        this.server = server;
        this.entity = entity;
        this.entityType = CraftEntityType.minecraftToBukkit(entity.method_5864());
    }

    public static <T extends class_1297> CraftEntity getEntity(CraftServer server, T entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Unknown entity");
        if (entity instanceof class_1657 && !(entity instanceof class_3222)) {
            return new CraftHumanEntity(server, (class_1657)entity);
        }
        if (entity instanceof class_1508) {
            class_1508 complexPart = (class_1508)entity;
            if (complexPart.field_7007 instanceof class_1510) {
                return new CraftEnderDragonPart(server, complexPart);
            }
            return new CraftComplexPart(server, complexPart);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(CraftEntityType.minecraftToBukkit(entity.method_5864()));
        if (entityTypeData != null) {
            return (CraftEntity)entityTypeData.convertFunction().apply(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + String.valueOf(entity == null ? null : entity.getClass())));
    }

    @Override
    public Location getLocation() {
        return CraftLocation.toBukkit(this.entity.method_19538(), this.getWorld(), this.entity.getBukkitYaw(), this.entity.method_36455());
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.method_23317());
            loc.setY(this.entity.method_23318());
            loc.setZ(this.entity.method_23321());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.method_36455());
        }
        return loc;
    }

    @Override
    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.method_18798());
    }

    @Override
    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        this.entity.method_18799(CraftVector.toNMS(velocity));
        this.entity.field_6037 = true;
    }

    @Override
    public double getHeight() {
        return this.getHandle().method_17682();
    }

    @Override
    public double getWidth() {
        return this.getHandle().method_17681();
    }

    @Override
    public BoundingBox getBoundingBox() {
        class_238 bb = this.getHandle().method_5829();
        return new BoundingBox(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
    }

    @Override
    public boolean isOnGround() {
        if (this.entity instanceof class_1665) {
            return ((class_1665)this.entity).field_7588;
        }
        return this.entity.method_24828();
    }

    @Override
    public boolean isInWater() {
        return this.entity.method_5799();
    }

    @Override
    public World getWorld() {
        return this.entity.method_37908().getWorld();
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite(pitch, "pitch not finite");
        NumberConversions.checkFinite(yaw, "yaw not finite");
        yaw = Location.normalizeYaw(yaw);
        pitch = Location.normalizePitch(pitch);
        this.entity.method_36456(yaw);
        this.entity.method_36457(pitch);
        this.entity.field_5982 = yaw;
        this.entity.field_6004 = pitch;
        this.entity.method_5847(yaw);
    }

    @Override
    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        location.checkFinite();
        if (this.entity.method_5782() || this.entity.method_31481()) {
            return false;
        }
        this.entity.method_5848();
        if (location.getWorld() != null && !location.getWorld().equals(this.getWorld())) {
            Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
            this.entity.method_5731(new class_5454(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), class_243.field_1353, location.getPitch(), location.getYaw(), class_5454.field_52245, PlayerTeleportEvent.TeleportCause.PLUGIN));
            return true;
        }
        this.entity.method_5641(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.method_5847(location.getYaw());
        return true;
    }

    @Override
    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    @Override
    public List<Entity> getNearbyEntities(double x, double y, double z) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get nearby entities during world generation");
        AsyncCatcher.catchOp("getNearbyEntities");
        List notchEntityList = this.entity.method_37908().method_8333(this.entity, this.entity.method_5829().method_1009(x, y, z), (Predicate)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (class_1297 e : notchEntityList) {
            bukkitEntityList.add(e.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    @Override
    public int getEntityId() {
        return this.entity.method_5628();
    }

    @Override
    public int getFireTicks() {
        return this.entity.method_20802();
    }

    @Override
    public int getMaxFireTicks() {
        return this.entity.method_5676();
    }

    @Override
    public void setFireTicks(int ticks) {
        this.entity.method_20803(ticks);
    }

    @Override
    public void setVisualFire(boolean fire) {
        this.getHandle().field_33758 = fire;
    }

    @Override
    public boolean isVisualFire() {
        return this.getHandle().field_33758;
    }

    @Override
    public int getFreezeTicks() {
        return this.getHandle().method_32312();
    }

    @Override
    public int getMaxFreezeTicks() {
        return this.getHandle().method_32315();
    }

    @Override
    public void setFreezeTicks(int ticks) {
        Preconditions.checkArgument((0 <= ticks ? 1 : 0) != 0, (String)"Ticks (%s) cannot be less than 0", (int)ticks);
        this.getHandle().method_32317(ticks);
    }

    @Override
    public boolean isFrozen() {
        return this.getHandle().method_32314();
    }

    @Override
    public void remove() {
        this.entity.pluginRemoved = true;
        this.entity.discard(this.getHandle().generation ? null : EntityRemoveEvent.Cause.PLUGIN);
    }

    @Override
    public boolean isDead() {
        return !this.entity.method_5805();
    }

    @Override
    public boolean isValid() {
        return this.entity.method_5805() && this.entity.valid && this.entity.isChunkLoaded() && this.isInWorld();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public boolean isPersistent() {
        return this.entity.persist;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    @Override
    public Entity getPassenger() {
        return this.isEmpty() ? null : ((class_1297)this.getHandle().field_5979.get(0)).getBukkitEntity();
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().method_5804(this.getHandle());
        }
        return false;
    }

    @Override
    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.getHandle().field_5979, input -> input.getBukkitEntity()));
    }

    @Override
    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        return ((CraftEntity)passenger).getHandle().method_5873(this.getHandle(), true);
    }

    @Override
    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        ((CraftEntity)passenger).getHandle().method_5848();
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.getHandle().method_5782();
    }

    @Override
    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().method_5772();
        return true;
    }

    @Override
    public float getFallDistance() {
        return this.getHandle().field_6017;
    }

    @Override
    public void setFallDistance(float distance) {
        this.getHandle().field_6017 = distance;
    }

    @Override
    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Override
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    @Override
    public UUID getUniqueId() {
        return this.getHandle().method_5667();
    }

    @Override
    public int getTicksLived() {
        return this.getHandle().field_6012;
    }

    @Override
    public void setTicksLived(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Age value (%s) must be greater than 0", (int)value);
        this.getHandle().field_6012 = value;
    }

    public class_1297 getHandle() {
        return this.entity;
    }

    @Override
    public final EntityType getType() {
        return this.entityType;
    }

    @Override
    public void playEffect(EntityEffect type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot play effect during world generation");
        if (type.getApplicable().isInstance(this)) {
            this.getHandle().method_37908().method_8421(this.getHandle(), type.getData());
        }
    }

    @Override
    public Sound getSwimSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSound0());
    }

    @Override
    public Sound getSwimSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSplashSound0());
    }

    @Override
    public Sound getSwimHighSpeedSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimHighSpeedSplashSound0());
    }

    public void setHandle(class_1297 entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isInsideVehicle() {
        return this.getHandle().method_5765();
    }

    @Override
    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().method_5848();
        return true;
    }

    @Override
    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().method_5854().getBukkitEntity();
    }

    @Override
    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().method_5665(CraftChatMessage.fromStringOrNull(name));
    }

    @Override
    public String getCustomName() {
        class_2561 name = this.getHandle().method_5797();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.getHandle().method_5880(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.getHandle().method_5807();
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        if (this.getHandle().visibleByDefault != visible) {
            if (visible) {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndShowEntity(this);
                }
            } else {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndHideEntity(this);
                }
            }
            this.getHandle().visibleByDefault = visible;
        }
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.getHandle().visibleByDefault;
    }

    @Override
    public Set<Player> getTrackedBy() {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get tracking players during world generation");
        ImmutableSet.Builder players = ImmutableSet.builder();
        class_3218 world = ((CraftWorld)this.getWorld()).getHandle();
        class_3898.class_3208 entityTracker = (class_3898.class_3208)world.method_14178().field_17254.field_18242.get(this.getEntityId());
        if (entityTracker != null) {
            for (class_5629 connection : entityTracker.field_18250) {
                players.add((Object)connection.method_32311().getBukkitEntity());
            }
        }
        return players.build();
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void sendMessage(String ... messages) {
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    @Override
    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().method_5477());
    }

    @Override
    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    @Override
    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    @Override
    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    @Override
    public void setGlowing(boolean flag) {
        this.getHandle().method_5834(flag);
    }

    @Override
    public boolean isGlowing() {
        return this.getHandle().method_5851();
    }

    @Override
    public void setInvulnerable(boolean flag) {
        this.getHandle().method_5684(flag);
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().method_5679(this.getHandle().method_48923().method_48830());
    }

    @Override
    public boolean isSilent() {
        return this.getHandle().method_5701();
    }

    @Override
    public void setSilent(boolean flag) {
        this.getHandle().method_5803(flag);
    }

    @Override
    public boolean hasGravity() {
        return !this.getHandle().method_5740();
    }

    @Override
    public void setGravity(boolean gravity) {
        this.getHandle().method_5875(!gravity);
    }

    @Override
    public int getPortalCooldown() {
        return this.getHandle().field_6018;
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        this.getHandle().field_6018 = cooldown;
    }

    @Override
    public Set<String> getScoreboardTags() {
        return this.getHandle().method_5752();
    }

    @Override
    public boolean addScoreboardTag(String tag) {
        return this.getHandle().method_5780(tag);
    }

    @Override
    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().method_5738(tag);
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getHandle().method_5657().ordinal());
    }

    @Override
    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().method_5755());
    }

    @Override
    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    @Override
    public Pose getPose() {
        return Pose.values()[this.getHandle().method_18376().ordinal()];
    }

    @Override
    public SpawnCategory getSpawnCategory() {
        return CraftSpawnCategory.toBukkit(this.getHandle().method_5864().method_5891());
    }

    @Override
    public boolean isInWorld() {
        return this.getHandle().inWorld;
    }

    @Override
    public String getAsString() {
        class_2487 tag = new class_2487();
        if (!this.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return tag.method_10714();
    }

    @Override
    public EntitySnapshot createSnapshot() {
        return CraftEntitySnapshot.create(this);
    }

    @Override
    public Entity copy() {
        class_1297 copy = this.copy(this.getHandle().method_37908());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        return copy.getBukkitEntity();
    }

    @Override
    public Entity copy(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        class_1297 copy = this.copy((class_1937)((CraftWorld)location.getWorld()).getHandle());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        copy.method_5814(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity(copy.getBukkitEntity());
    }

    private class_1297 copy(class_1937 level) {
        class_2487 compoundTag = new class_2487();
        this.getHandle().saveAsPassenger(compoundTag, false);
        return class_1299.method_17842((class_2487)compoundTag, (class_1937)level, Function.identity());
    }

    public void storeBukkitValues(class_2487 c) {
        if (!this.persistentDataContainer.isEmpty()) {
            c.method_10566("BukkitValues", (class_2520)this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(class_2487 c) {
        class_2520 base = c.method_10580("BukkitValues");
        if (base instanceof class_2487) {
            this.persistentDataContainer.putAll((class_2487)base);
        }
    }

    protected class_2487 save() {
        class_2487 nbttagcompound = new class_2487();
        nbttagcompound.method_10582("id", this.getHandle().method_5653());
        this.getHandle().method_5647(nbttagcompound);
        return nbttagcompound;
    }

    protected void update() {
        if (!this.getHandle().method_5805()) {
            return;
        }
        class_3218 world = ((CraftWorld)this.getWorld()).getHandle();
        class_3898.class_3208 entityTracker = (class_3898.class_3208)world.method_14178().field_17254.field_18242.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        entityTracker.method_18730(this.getHandle().method_18002(entityTracker.field_18246));
    }

    public void update(class_3222 player) {
        if (!this.getHandle().method_5805()) {
            return;
        }
        class_3218 world = ((CraftWorld)this.getWorld()).getHandle();
        class_3898.class_3208 entityTracker = (class_3898.class_3208)world.method_14178().field_17254.field_18242.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        player.field_13987.method_14364(this.getHandle().method_18002(entityTracker.field_18246));
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                @Override
                public boolean isOp() {
                    return false;
                }

                @Override
                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    @Override
    public Entity.Spigot spigot() {
        return this.spigot;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

