/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final class_2487 data;
    private final EntityType type;

    private CraftEntitySnapshot(class_2487 data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    @Override
    public EntityType getEntityType() {
        return this.type;
    }

    @Override
    public Entity createEntity(World world) {
        class_1297 internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    @Override
    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        class_1297 internal = this.createInternal(location.getWorld());
        internal.method_5814(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity(internal.getBukkitEntity());
    }

    @Override
    public String getAsString() {
        return this.data.method_10714();
    }

    private class_1297 createInternal(World world) {
        class_3218 nms = ((CraftWorld)world).getHandle();
        class_1297 internal = class_1299.method_17842((class_2487)this.data, (class_1937)nms, Function.identity());
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).method_5883((class_1937)nms);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        internal.method_5651(this.data);
        return internal;
    }

    public class_2487 getData() {
        return this.data;
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        class_2487 tag = new class_2487();
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag, entity.getType());
    }

    public static CraftEntitySnapshot create(class_2487 tag, EntityType type) {
        if (tag == null || tag.method_33133() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(class_2487 tag) {
        EntityType type = class_1299.method_17684((class_2487)tag).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }
}

