/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R1.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class CraftEntityType {
    public static EntityType minecraftToBukkit(class_1299<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41266);
        EntityType bukkit = Registry.ENTITY_TYPE.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113(minecraft).orElseThrow()).method_29177()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static class_1299<?> bukkitToMinecraft(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (class_1299)CraftRegistry.getMinecraftRegistry(class_7924.field_41266).method_17966(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static String bukkitToString(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static EntityType stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEntityTypeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString(string);
        return CraftRegistry.get(Registry.ENTITY_TYPE, key, ApiVersion.CURRENT);
    }
}

