/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7102;
import net.minecraft.class_7106;
import net.minecraft.class_7924;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;

public class CraftFrog
extends CraftAnimals
implements Frog {
    public CraftFrog(CraftServer server, class_7102 entity) {
        super(server, (class_1429)entity);
    }

    public class_7102 getHandle() {
        return (class_7102)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFrog";
    }

    @Override
    public Entity getTongueTarget() {
        return this.getHandle().method_41360().map(class_1297::getBukkitEntity).orElse(null);
    }

    @Override
    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().method_41359();
        } else {
            this.getHandle().method_41352(((CraftEntity)target).getHandle());
        }
    }

    @Override
    public Frog.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit((class_6880<class_7106>)this.getHandle().method_41354());
    }

    @Override
    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().method_41353(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant {
        public static Frog.Variant minecraftToBukkit(class_7106 minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41272);
            Frog.Variant bukkit = Registry.FROG_VARIANT.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113((Object)minecraft).orElseThrow()).method_29177()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static Frog.Variant minecraftHolderToBukkit(class_6880<class_7106> minecraft) {
            return CraftVariant.minecraftToBukkit((class_7106)minecraft.comp_349());
        }

        public static class_7106 bukkitToMinecraft(Frog.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (class_7106)CraftRegistry.getMinecraftRegistry(class_7924.field_41272).method_17966(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }

        public static class_6880<class_7106> bukkitToMinecraftHolder(Frog.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41272);
            class_6880 class_68802 = registry.method_47983((Object)CraftVariant.bukkitToMinecraft(bukkit));
            if (class_68802 instanceof class_6880.class_6883) {
                class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
                return holder;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own frog variant with out properly registering it.");
        }
    }
}

