/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1699;
import net.minecraft.class_1952;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftMinecart;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.minecart.SpawnerMinecart;

final class CraftMinecartMobSpawner
extends CraftMinecart
implements SpawnerMinecart {
    CraftMinecartMobSpawner(CraftServer server, class_1699 entity) {
        super(server, (class_1688)entity);
    }

    @Override
    public EntityType getSpawnedType() {
        class_1952 spawnData = this.getHandle().method_35216().field_9155;
        if (spawnData == null) {
            return null;
        }
        Optional type = class_1299.method_17684((class_2487)spawnData.method_38093());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    @Override
    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            this.getHandle().method_35216().field_9152 = class_6005.method_38062();
            this.getHandle().method_35216().field_9155 = new class_1952();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        class_5819 rand = this.getHandle().method_37908().method_8409();
        this.getHandle().method_35216().method_8274(CraftEntityType.bukkitToMinecraft(entityType), this.getHandle().method_37908(), rand, this.getHandle().method_24515());
    }

    @Override
    public EntitySnapshot getSpawnedEntity() {
        class_1952 spawnData = this.getHandle().method_35216().field_9155;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.method_38093());
    }

    @Override
    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().method_35216(), snapshot, null, null);
    }

    @Override
    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().method_35216(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    @Override
    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().method_35216(), snapshot, weight, spawnRule, null);
    }

    @Override
    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().method_35216(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    @Override
    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(this.getHandle().method_35216(), entries);
    }

    @Override
    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(this.getHandle().method_35216());
    }

    @Override
    public int getDelay() {
        return this.getHandle().method_35216().field_9154;
    }

    @Override
    public void setDelay(int delay) {
        this.getHandle().method_35216().field_9154 = delay;
    }

    @Override
    public int getMinSpawnDelay() {
        return this.getHandle().method_35216().field_9151;
    }

    @Override
    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        this.getHandle().method_35216().field_9151 = spawnDelay;
    }

    @Override
    public int getMaxSpawnDelay() {
        return this.getHandle().method_35216().field_9150;
    }

    @Override
    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        this.getHandle().method_35216().field_9150 = spawnDelay;
    }

    @Override
    public int getMaxNearbyEntities() {
        return this.getHandle().method_35216().field_9160;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.getHandle().method_35216().field_9160 = maxNearbyEntities;
    }

    @Override
    public int getSpawnCount() {
        return this.getHandle().method_35216().field_9149;
    }

    @Override
    public void setSpawnCount(int count) {
        this.getHandle().method_35216().field_9149 = count;
    }

    @Override
    public int getRequiredPlayerRange() {
        return this.getHandle().method_35216().field_9158;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.getHandle().method_35216().field_9158 = requiredPlayerRange;
    }

    @Override
    public int getSpawnRange() {
        return this.getHandle().method_35216().field_9157;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        this.getHandle().method_35216().field_9157 = spawnRange;
    }

    public class_1699 getHandle() {
        return (class_1699)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMinecartMobSpawner";
    }
}

