/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_6880;
import net.minecraft.class_9298;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionUtil;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftCow
implements MushroomCow {
    public CraftMushroomCow(CraftServer server, class_1438 entity) {
        super(server, (class_1430)entity);
    }

    @Override
    public boolean hasEffectsForNextStew() {
        class_9298 stewEffects = this.getHandle().field_45752;
        return stewEffects != null && !stewEffects.comp_2416().isEmpty();
    }

    @Override
    public List<PotionEffect> getEffectsForNextStew() {
        class_9298 stewEffects = this.getHandle().field_45752;
        if (stewEffects != null) {
            return stewEffects.comp_2416().stream().map(recordSuspiciousEffect -> CraftPotionUtil.toBukkit(recordSuspiciousEffect.method_53247())).toList();
        }
        return ImmutableList.of();
    }

    @Override
    public boolean addEffectToNextStew(PotionEffect potionEffect, boolean overwrite) {
        Preconditions.checkArgument((potionEffect != null ? 1 : 0) != 0, (Object)"PotionEffect cannot be null");
        class_1293 minecraftPotionEffect = CraftPotionUtil.fromBukkit(potionEffect);
        if (!overwrite && this.hasEffectForNextStew(potionEffect.getType())) {
            return false;
        }
        class_9298 stewEffects = this.getHandle().field_45752;
        if (stewEffects == null) {
            stewEffects = class_9298.field_49362;
        }
        class_9298.class_8751 recordSuspiciousEffect = new class_9298.class_8751(minecraftPotionEffect.method_5579(), minecraftPotionEffect.method_5584());
        this.removeEffectFromNextStew(potionEffect.getType());
        this.getHandle().field_45752 = stewEffects.method_57514(recordSuspiciousEffect);
        return true;
    }

    @Override
    public boolean removeEffectFromNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectForNextStew(potionEffectType)) {
            return false;
        }
        class_9298 stewEffects = this.getHandle().field_45752;
        if (stewEffects == null) {
            return false;
        }
        class_6880<class_1291> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        this.getHandle().field_45752 = new class_9298(stewEffects.comp_2416().stream().filter(effect -> !effect.comp_1838().equals((Object)minecraftPotionEffectType)).toList());
        return true;
    }

    @Override
    public boolean hasEffectForNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        class_9298 stewEffects = this.getHandle().field_45752;
        if (stewEffects == null) {
            return false;
        }
        class_6880<class_1291> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        return stewEffects.comp_2416().stream().anyMatch(recordSuspiciousEffect -> recordSuspiciousEffect.comp_1838().equals((Object)minecraftPotionEffectType));
    }

    @Override
    public void clearEffectsForNextStew() {
        this.getHandle().field_45752 = null;
    }

    public class_1438 getHandle() {
        return (class_1438)this.entity;
    }

    @Override
    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().method_47847().ordinal()];
    }

    @Override
    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null");
        this.getHandle().method_47846(class_1438.class_4053.values()[variant.ordinal()]);
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

