/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1702;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1934;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2539;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2622;
import net.minecraft.class_2625;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2658;
import net.minecraft.class_2668;
import net.minecraft.class_2673;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2683;
import net.minecraft.class_2703;
import net.minecraft.class_2718;
import net.minecraft.class_2720;
import net.minecraft.class_2744;
import net.minecraft.class_2748;
import net.minecraft.class_2749;
import net.minecraft.class_2759;
import net.minecraft.class_2765;
import net.minecraft.class_2767;
import net.minecraft.class_2770;
import net.minecraft.class_2772;
import net.minecraft.class_2780;
import net.minecraft.class_2781;
import net.minecraft.class_2783;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3330;
import net.minecraft.class_3340;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5888;
import net.minecraft.class_5895;
import net.minecraft.class_5896;
import net.minecraft.class_5897;
import net.minecraft.class_5898;
import net.minecraft.class_5899;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7439;
import net.minecraft.class_7471;
import net.minecraft.class_7597;
import net.minecraft.class_7828;
import net.minecraft.class_8043;
import net.minecraft.class_8242;
import net.minecraft.class_8710;
import net.minecraft.class_8711;
import net.minecraft.class_9053;
import net.minecraft.class_9088;
import net.minecraft.class_9091;
import net.minecraft.class_9150;
import net.minecraft.class_9151;
import net.minecraft.class_9209;
import net.minecraft.class_9782;
import net.minecraft.class_9815;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.ServerLinks;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.ban.IpBanList;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_21_R1.CraftEffect;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R1.CraftSound;
import org.bukkit.craftbukkit.v1_21_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R1.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_21_R1.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R1.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> invertedVisibilityEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private CraftWorldBorder clientWorldBorder = null;
    private class_2780 clientWorldBorderListener = this.createWorldBorderListener();
    private final Queue<CookieFuture> requestedCookies = new LinkedList<CookieFuture>();
    private class_2561 playerListHeader;
    private class_2561 playerListFooter;
    private final Player.Spigot spigot = new Player.Spigot(){

        @Override
        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().field_13987.getRawAddress();
        }

        @Override
        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().method_13949().respawn(CraftPlayer.this.getHandle(), false, class_1297.class_5529.field_26998, PlayerRespawnEvent.RespawnReason.PLUGIN);
            }
        }

        @Override
        public Set<Player> getHiddenPlayers() {
            HashSet<Player> ret = new HashSet<Player>();
            for (Player player : CraftPlayer.this.getServer().getOnlinePlayers()) {
                if (CraftPlayer.this.canSee(player)) continue;
                ret.add(player);
            }
            return Collections.unmodifiableSet(ret);
        }

        @Override
        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
            this.sendMessage(ChatMessageType.SYSTEM, components);
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, sender, component);
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent ... components) {
            this.sendMessage(ChatMessageType.CHAT, sender, components);
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            this.sendMessage(position, (UUID)null, components);
        }

        @Override
        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent component) {
            this.sendMessage(position, sender, new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().field_13987 == null) {
                return;
            }
            CraftPlayer.this.getHandle().field_13987.method_14364((class_2596)new class_7439(components, position == ChatMessageType.ACTION_BAR));
        }
    };

    public CraftPlayer(CraftServer server, class_3222 entity) {
        super(server, (class_1657)entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().method_7334();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(String.format("Cannot remove player %s, use Player#kickPlayer(String) instead.", this.getName()));
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().method_14569(this.getProfile());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().method_14582(this.getProfile());
        } else {
            this.server.getHandle().method_14604(this.getProfile());
        }
        this.perm.recalculatePermissions();
    }

    @Override
    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    @Override
    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this.getProfile());
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.getHandle().field_13987.method_52280() == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().field_13987.method_48107();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    public boolean isAwaitingCookies() {
        return !this.requestedCookies.isEmpty();
    }

    public boolean handleCookieResponse(class_9091 response) {
        CookieFuture future = this.requestedCookies.peek();
        if (future != null && future.key.equals((Object)response.comp_2195())) {
            Preconditions.checkState((future == this.requestedCookies.poll() ? 1 : 0) != 0, (Object)"requestedCookies queue mismatch");
            future.future().complete(response.comp_2196());
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransferred() {
        return this.getHandle().transferCookieConnection.isTransferred();
    }

    @Override
    public CompletableFuture<byte[]> retrieveCookie(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        class_2960 nms = CraftNamespacedKey.toMinecraft(key);
        this.requestedCookies.add(new CookieFuture(nms, future));
        this.getHandle().transferCookieConnection.sendPacket((class_2596<?>)new class_9088(nms));
        return future;
    }

    @Override
    public void storeCookie(NamespacedKey key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Cookie value cannot be null");
        Preconditions.checkArgument((value.length <= 5120 ? 1 : 0) != 0, (Object)"Cookie value too large, must be smaller than 5120 bytes");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == class_2539.field_45671 || this.getHandle().transferCookieConnection.getProtocol() == class_2539.field_20591 ? 1 : 0) != 0, (Object)"Can only store cookie in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket((class_2596<?>)new class_9150(CraftNamespacedKey.toMinecraft(key), value));
    }

    @Override
    public void transfer(String host, int port) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"Host cannot be null");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == class_2539.field_45671 || this.getHandle().transferCookieConnection.getProtocol() == class_2539.field_20591 ? 1 : 0) != 0, (Object)"Can only transfer in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket((class_2596<?>)new class_9151(host, port));
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    @Override
    public void sendRawMessage(String message) {
        this.sendRawMessage(null, message);
    }

    @Override
    public void sendRawMessage(UUID sender, String message) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        for (class_2561 component : CraftChatMessage.fromString(message)) {
            this.getHandle().method_43496(component);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    @Override
    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    @Override
    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        for (class_3222 player : this.server.getHandle().field_14351) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_29139, this.getHandle()));
        }
    }

    @Override
    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : CraftChatMessage.fromComponent(this.playerListHeader);
    }

    @Override
    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : CraftChatMessage.fromComponent(this.playerListFooter);
    }

    @Override
    public void setPlayerListHeader(String header) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.updatePlayerListHeaderFooter();
    }

    @Override
    public void setPlayerListFooter(String footer) {
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    @Override
    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2772 packet = new class_2772((class_2561)(this.playerListHeader == null ? class_2561.method_43473() : this.playerListHeader), (class_2561)(this.playerListFooter == null ? class_2561.method_43473() : this.playerListFooter));
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    @Override
    public void kickPlayer(String message) {
        AsyncCatcher.catchOp("player kick");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_52396(CraftChatMessage.fromStringOrEmpty(message, true));
    }

    @Override
    public void setCompassTarget(Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2759(CraftLocation.toBlockPosition(loc), loc.getYaw()));
    }

    @Override
    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    @Override
    public void chat(String msg) {
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"msg cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.chat(msg, class_7471.method_45041((String)msg), false);
    }

    @Override
    public boolean performCommand(String command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"command cannot be null");
        return this.server.dispatchCommand(this, command);
    }

    @Override
    public void playNote(Location loc, byte instrument, byte note) {
        this.playNote(loc, Instrument.getByType(instrument), new Note(note));
    }

    @Override
    public void playNote(Location loc, Instrument instrument, Note note) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((instrument != null ? 1 : 0) != 0, (Object)"Instrument cannot be null");
        Preconditions.checkArgument((note != null ? 1 : 0) != 0, (Object)"Note cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        Sound instrumentSound = instrument.getSound();
        if (instrumentSound == null) {
            return;
        }
        float pitch = note.getPitch();
        this.getHandle().field_13987.method_14364((class_2596)new class_2767(CraftSound.bukkitToMinecraftHolder(instrumentSound), class_3419.field_15247, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, pitch, this.getHandle().method_59922().method_43055()));
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().field_5974.method_43055());
    }

    @Override
    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().field_5974.method_43055());
    }

    @Override
    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().field_13987 == null) {
            return;
        }
        this.playSound0(loc, CraftSound.bukkitToMinecraftHolder(sound), class_3419.valueOf((String)category.name()), volume, pitch, seed);
    }

    @Override
    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().field_13987 == null) {
            return;
        }
        this.playSound0(loc, (class_6880<class_3414>)class_6880.method_40223((Object)class_3414.method_47908((class_2960)class_2960.method_60654((String)sound))), class_3419.valueOf((String)category.name()), volume, pitch, seed);
    }

    private void playSound0(Location loc, class_6880<class_3414> soundEffectHolder, class_3419 categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2767 packet = new class_2767(soundEffectHolder, categoryNMS, loc.getX(), loc.getY(), loc.getZ(), volume, pitch, seed);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().field_5974.method_43055());
    }

    @Override
    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().field_5974.method_43055());
    }

    @Override
    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().field_13987 != null) break block3;
            }
            return;
        }
        this.playSound0(entity, CraftSound.bukkitToMinecraftHolder(sound), class_3419.valueOf((String)category.name()), volume, pitch, seed);
    }

    @Override
    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().field_13987 != null) break block3;
            }
            return;
        }
        this.playSound0(entity, (class_6880<class_3414>)class_6880.method_40223((Object)class_3414.method_47908((class_2960)class_2960.method_60654((String)sound))), class_3419.valueOf((String)category.name()), volume, pitch, seed);
    }

    private void playSound0(Entity entity, class_6880<class_3414> soundEffectHolder, class_3419 categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((soundEffectHolder != null ? 1 : 0) != 0, (Object)"Holder of SoundEffect cannot be null");
        Preconditions.checkArgument((categoryNMS != null ? 1 : 0) != 0, (Object)"SoundCategory cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (!(entity instanceof CraftEntity)) {
            return;
        }
        CraftEntity craftEntity = (CraftEntity)entity;
        class_2765 packet = new class_2765(soundEffectHolder, categoryNMS, craftEntity.getHandle(), volume, pitch, seed);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    @Override
    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    @Override
    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(sound.getKey().getKey(), category);
    }

    @Override
    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2770(class_2960.method_60654((String)sound), category == null ? class_3419.field_15250 : class_3419.valueOf((String)category.name())));
    }

    @Override
    public void stopSound(SoundCategory category) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2770(null, class_3419.valueOf((String)category.name())));
    }

    @Override
    public void stopAllSounds() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2770(null, null));
    }

    @Override
    public void playEffect(Location loc, Effect effect, int data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        int packetData = effect.getId();
        class_2673 packet = new class_2673(packetData, CraftLocation.toBlockPosition(loc), data, false);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)((Object)effect));
            Preconditions.checkArgument((boolean)effect.getData().isAssignableFrom(data.getClass()), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)((Object)effect));
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)((Object)effect));
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    @Override
    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals(this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().field_13974.method_14266(new class_2338(block.getX(), block.getY(), block.getZ()));
    }

    @Override
    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2626 packet = new class_2626(CraftLocation.toBlockPosition(loc), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2626 packet = new class_2626(CraftLocation.toBlockPosition(loc), ((CraftBlockData)block).getState());
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void sendBlockChanges(Collection<BlockState> blocks) {
        Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
        if (this.getHandle().field_13987 == null || blocks.isEmpty()) {
            return;
        }
        HashMap<class_4076, ChunkSectionChanges> changes = new HashMap<class_4076, ChunkSectionChanges>();
        for (BlockState blockState : blocks) {
            CraftBlockState cstate = (CraftBlockState)blockState;
            class_2338 blockPosition = cstate.getPosition();
            class_4076 sectionPosition = class_4076.method_18682((class_2338)blockPosition);
            ChunkSectionChanges sectionChanges = changes.computeIfAbsent(sectionPosition, ignore -> new ChunkSectionChanges());
            sectionChanges.positions().add(class_4076.method_19454((class_2338)blockPosition));
            sectionChanges.blockData().add(cstate.getHandle());
        }
        for (Map.Entry entry : changes.entrySet()) {
            ChunkSectionChanges chunkChanges = (ChunkSectionChanges)entry.getValue();
            class_2637 packet = new class_2637((class_4076)entry.getKey(), chunkChanges.positions(), (class_2680[])chunkChanges.blockData().toArray(class_2680[]::new));
            this.getHandle().field_13987.method_14364((class_2596)packet);
        }
    }

    @Override
    public void sendBlockChanges(Collection<BlockState> blocks, boolean suppressLightUpdates) {
        this.sendBlockChanges(blocks);
    }

    @Override
    public void sendBlockDamage(Location loc, float progress) {
        this.sendBlockDamage(loc, progress, this.getEntityId());
    }

    @Override
    public void sendBlockDamage(Location loc, float progress, Entity source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source must not be null");
        this.sendBlockDamage(loc, progress, source.getEntityId());
    }

    @Override
    public void sendBlockDamage(Location loc, float progress, int sourceId) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        if (progress == 0.0f) {
            stage = -1;
        }
        class_2620 packet = new class_2620(sourceId, CraftLocation.toBlockPosition(loc), stage);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor, boolean hasGlowingText) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new String[4];
        }
        Preconditions.checkArgument((lines.length >= 4 ? 1 : 0) != 0, (String)"Must have at least 4 lines (%s)", (int)lines.length);
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2561[] components = CraftSign.sanitizeLines(lines);
        class_2625 sign = new class_2625(CraftLocation.toBlockPosition(loc), class_2246.field_10121.method_9564());
        class_8242 text = sign.method_49853();
        text = text.method_49862(class_1767.method_7791((int)dyeColor.getWoolData()));
        text = text.method_49867(hasGlowingText);
        for (int i = 0; i < components.length; ++i) {
            text = text.method_49857(i, components[i]);
        }
        sign.method_49840(text, true);
        this.getHandle().field_13987.method_14364((class_2596)new class_2622(sign.method_11016(), sign.method_11017(), sign.method_16887((class_7225.class_7874)this.getHandle().method_56673())));
    }

    @Override
    public void sendBlockUpdate(@NotNull Location location, @NotNull TileState tileState) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location can not be null");
        Preconditions.checkArgument((tileState != null ? 1 : 0) != 0, (Object)"TileState can not be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        CraftBlockEntityState craftState = (CraftBlockEntityState)tileState;
        this.getHandle().field_13987.method_14364(craftState.getUpdatePacket(location));
    }

    @Override
    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, ItemStack item) {
        this.sendEquipmentChange(entity, Map.of(slot, item));
    }

    @Override
    public void sendEquipmentChange(LivingEntity entity, Map<EquipmentSlot, ItemStack> items) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        ArrayList<Pair> equipment = new ArrayList<Pair>(items.size());
        for (Map.Entry<EquipmentSlot, ItemStack> entry : items.entrySet()) {
            EquipmentSlot slot = entry.getKey();
            Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Cannot set null EquipmentSlot");
            equipment.add(new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(entry.getValue())));
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2744(entity.getEntityId(), equipment));
    }

    @Override
    public void sendPotionEffectChange(LivingEntity entity, PotionEffect effect) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2783(entity.getEntityId(), CraftPotionUtil.fromBukkit(effect), true));
    }

    @Override
    public void sendPotionEffectChangeRemove(LivingEntity entity, PotionEffectType type) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2718(entity.getEntityId(), CraftPotionEffectType.bukkitToMinecraftHolder(type)));
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.clientWorldBorder;
    }

    @Override
    public void setWorldBorder(WorldBorder border) {
        class_2784 newWorldBorder;
        CraftWorldBorder craftBorder = (CraftWorldBorder)border;
        if (border != null && !craftBorder.isVirtual() && !craftBorder.getWorld().equals(this.getWorld())) {
            throw new UnsupportedOperationException("Cannot set player world border to that of another world");
        }
        if (this.clientWorldBorder != null) {
            this.clientWorldBorder.getHandle().method_35318(this.clientWorldBorderListener);
        }
        if (craftBorder == null || !craftBorder.isVirtual()) {
            this.clientWorldBorder = null;
            newWorldBorder = ((CraftWorldBorder)this.getWorld().getWorldBorder()).getHandle();
        } else {
            this.clientWorldBorder = craftBorder;
            this.clientWorldBorder.getHandle().method_11983(this.clientWorldBorderListener);
            newWorldBorder = this.clientWorldBorder.getHandle();
        }
        class_3244 connection = this.getHandle().field_13987;
        connection.method_14364((class_2596)new class_5897(newWorldBorder));
        connection.method_14364((class_2596)new class_5896(newWorldBorder));
        connection.method_14364((class_2596)new class_5895(newWorldBorder));
        connection.method_14364((class_2596)new class_5898(newWorldBorder));
        connection.method_14364((class_2596)new class_5899(newWorldBorder));
    }

    private class_2780 createWorldBorderListener() {
        return new class_2780(){

            public void method_11934(class_2784 border, double size) {
                CraftPlayer.this.getHandle().field_13987.method_14364((class_2596)new class_5897(border));
            }

            public void method_11931(class_2784 border, double size, double newSize, long time) {
                CraftPlayer.this.getHandle().field_13987.method_14364((class_2596)new class_5896(border));
            }

            public void method_11930(class_2784 border, double x, double z) {
                CraftPlayer.this.getHandle().field_13987.method_14364((class_2596)new class_5895(border));
            }

            public void method_11932(class_2784 border, int warningTime) {
                CraftPlayer.this.getHandle().field_13987.method_14364((class_2596)new class_5898(border));
            }

            public void method_11933(class_2784 border, int warningBlocks) {
                CraftPlayer.this.getHandle().field_13987.method_14364((class_2596)new class_5899(border));
            }

            public void method_11929(class_2784 border, double damage) {
            }

            public void method_11935(class_2784 border, double blocks) {
            }
        };
    }

    public boolean hasClientWorldBorder() {
        return this.clientWorldBorder != null;
    }

    @Override
    public void sendMap(MapView map) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<class_20> icons = new ArrayList<class_20>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new class_20(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
        }
        class_2683 packet = new class_2683(new class_9209(map.getId()), map.getScale().getValue(), map.isLocked(), icons, new class_22.class_5637(0, 0, 128, 128, data.buffer));
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void sendHurtAnimation(float yaw) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().field_13987.method_14364((class_2596)new class_8043(this.getEntityId(), actualYaw));
    }

    @Override
    public void sendLinks(ServerLinks links) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        Preconditions.checkArgument((links != null ? 1 : 0) != 0, (Object)"links cannot be null");
        class_9782 nms = ((CraftServerLinks)links).getServerLinks();
        this.getHandle().field_13987.method_14364((class_2596)new class_9815(nms.method_60938()));
    }

    @Override
    public void addCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, class_7597.class_7598.field_39801);
    }

    @Override
    public void removeCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, class_7597.class_7598.field_39802);
    }

    @Override
    public void setCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, class_7597.class_7598.field_39803);
    }

    private void sendCustomChatCompletionPacket(Collection<String> completions, class_7597.class_7598 action) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_7597 packet = new class_7597(action, new ArrayList<String>(completions));
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        throw new UnsupportedOperationException("Cannot set rotation of players. Consider teleporting instead.");
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        location.checkFinite();
        class_3222 entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.method_31481()) {
            return false;
        }
        if (entity.field_13987 == null) {
            return false;
        }
        if (entity.method_5782()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        entity.method_5848();
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to = event.getTo();
        class_3218 fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        class_3218 toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().field_7512 != this.getHandle().field_7498) {
            this.getHandle().method_7346();
        }
        if (fromWorld == toWorld) {
            entity.field_13987.teleport(to);
        } else {
            entity.field_51994 = null;
            this.server.getHandle().respawn(entity, true, class_1297.class_5529.field_27002, null, to);
        }
        return true;
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().method_5660(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().method_5715();
    }

    @Override
    public boolean isSprinting() {
        return this.getHandle().method_5624();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.getHandle().method_5728(sprinting);
    }

    @Override
    public void loadData() {
        this.server.getHandle().field_14358.method_55789((class_1657)this.getHandle());
    }

    @Override
    public void saveData() {
        this.server.getHandle().field_14358.method_262((class_1657)this.getHandle());
    }

    @Override
    @Deprecated
    public void updateInventory() {
        this.getHandle().field_7512.method_34252();
    }

    @Override
    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().method_8448();
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    @Override
    public Location getBedSpawnLocation() {
        return this.getRespawnLocation();
    }

    @Override
    public Location getRespawnLocation() {
        Optional spawnLoc;
        class_3218 world = this.getHandle().field_13995.method_3847(this.getHandle().method_26281());
        class_2338 bed = this.getHandle().method_26280();
        if (world != null && bed != null && (spawnLoc = class_3222.method_60588((class_3218)world, (class_2338)bed, (float)this.getHandle().method_30631(), (boolean)this.getHandle().method_26282(), (boolean)true)).isPresent()) {
            class_3222.class_9773 vec = (class_3222.class_9773)spawnLoc.get();
            return CraftLocation.toBukkit(vec.comp_2811(), (World)world.getWorld(), vec.comp_2812(), 0.0f);
        }
        return null;
    }

    @Override
    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    @Override
    public void setRespawnLocation(Location location) {
        this.setRespawnLocation(location, false);
    }

    @Override
    public void setBedSpawnLocation(Location location, boolean override) {
        this.setRespawnLocation(location, override);
    }

    @Override
    public void setRespawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().setRespawnPosition(null, null, 0.0f, override, false, PlayerSpawnChangeEvent.Cause.PLUGIN);
        } else {
            this.getHandle().setRespawnPosition(((CraftWorld)location.getWorld()).getHandle().method_27983(), CraftLocation.toBlockPosition(location), location.getYaw(), override, false, PlayerSpawnChangeEvent.Cause.PLUGIN);
        }
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        class_2338 bed = this.getHandle().method_26280();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().method_14253().method_22845(CraftNamespacedKey.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().method_14253().field_15300.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key)));
        return bukkitRecipeKeys.build();
    }

    @Override
    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, this.getHandle());
    }

    @Override
    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, this.getHandle());
    }

    @Override
    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().method_14248(), statistic);
    }

    @Override
    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, amount, this.getHandle());
    }

    @Override
    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, amount, this.getHandle());
    }

    @Override
    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().method_14248(), statistic, newValue, this.getHandle());
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, material, this.getHandle());
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, material, this.getHandle());
    }

    @Override
    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().method_14248(), statistic, material);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, material, amount, this.getHandle());
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, material, amount, this.getHandle());
    }

    @Override
    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().method_14248(), statistic, material, newValue, this.getHandle());
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, entityType, this.getHandle());
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, entityType, this.getHandle());
    }

    @Override
    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().method_14248(), statistic, entityType);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, entityType, amount, this.getHandle());
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, entityType, amount, this.getHandle());
    }

    @Override
    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().method_14248(), statistic, entityType, newValue, this.getHandle());
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    @Override
    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    @Override
    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    @Override
    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    @Override
    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    @Override
    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    @Override
    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    @Override
    public int getExpCooldown() {
        return this.getHandle().field_7504;
    }

    @Override
    public void setExpCooldown(int ticks) {
        this.getHandle().field_7504 = CraftEventFactory.callPlayerXpCooldownEvent((class_1657)this.getHandle(), ticks, PlayerExpCooldownChangeEvent.ChangeReason.PLUGIN).getNewCooldown();
    }

    @Override
    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    @Override
    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned(this.getPlayerProfile());
    }

    @Override
    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return this.ban(reason, expires, source, true);
    }

    @Override
    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return this.ban(reason, expires != null ? Date.from(expires) : null, source);
    }

    @Override
    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source);
    }

    @Override
    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source, boolean kickPlayer) {
        BanEntry<PlayerProfile> banEntry = ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    @Override
    public BanEntry<PlayerProfile> ban(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.ban(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    @Override
    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    @Override
    public BanEntry<InetAddress> banIp(String reason, Date expires, String source, boolean kickPlayer) {
        Preconditions.checkArgument((this.getAddress() != null ? 1 : 0) != 0, (Object)"The Address of this Player is null");
        BanEntry<InetAddress> banEntry = ((IpBanList)this.server.getBanList(BanList.Type.IP)).addBan(this.getAddress().getAddress(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    @Override
    public BanEntry<InetAddress> banIp(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.banIp(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    @Override
    public BanEntry<InetAddress> banIp(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.banIp(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.getHandle().method_14590().method_14653(this.getProfile());
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().method_14590().method_14633((class_3330)new class_3340(this.getProfile()));
        } else {
            this.server.getHandle().method_14590().method_14635((Object)this.getProfile());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().method_7336(class_1934.method_8384((int)mode.getValue()));
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue(this.getHandle().field_13974.method_14257().method_8379());
    }

    @Override
    public GameMode getPreviousGameMode() {
        class_1934 previousGameMode = this.getHandle().field_13974.method_30119();
        return previousGameMode == null ? null : GameMode.getByValue(previousGameMode.method_8379());
    }

    @Override
    public void giveExp(int exp) {
        this.getHandle().method_7255(exp);
    }

    @Override
    public void giveExpLevels(int levels) {
        this.getHandle().method_7316(levels);
    }

    @Override
    public float getExp() {
        return this.getHandle().field_7510;
    }

    @Override
    public void setExp(float exp) {
        Preconditions.checkArgument(((double)exp >= 0.0 && (double)exp <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().field_7510 = exp;
        this.getHandle().field_13978 = -1;
    }

    @Override
    public int getLevel() {
        return this.getHandle().field_7520;
    }

    @Override
    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().field_7520 = level;
        this.getHandle().field_13978 = -1;
    }

    @Override
    public int getTotalExperience() {
        return this.getHandle().field_7495;
    }

    @Override
    public void setTotalExperience(int exp) {
        Preconditions.checkArgument((exp >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp);
        this.getHandle().field_7495 = exp;
    }

    @Override
    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    @Override
    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2748 packet = new class_2748(progress, this.getTotalExperience(), level);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Override
    @Deprecated
    public void hidePlayer(Player player) {
        this.hideEntity0(null, player);
    }

    @Override
    public void hidePlayer(Plugin plugin, Player player) {
        this.hideEntity(plugin, player);
    }

    @Override
    public void hideEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (String)"Plugin (%s) cannot be disabled", (Object)plugin.getName());
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity hidden cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldHide = entity.isVisibleByDefault() ? this.addInvertedVisibility(plugin, entity) : this.removeInvertedVisibility(plugin, entity);
        if (shouldHide) {
            this.untrackAndHideEntity(entity);
        }
    }

    private boolean addInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins != null) {
            invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return false;
        }
        invertedPlugins = new HashSet<WeakReference<Plugin>>();
        invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.invertedVisibilityEntities.put(entity.getUniqueId(), invertedPlugins);
        return true;
    }

    private void untrackAndHideEntity(Entity entity) {
        class_3898 tracker = ((class_3218)this.getHandle().method_37908()).method_14178().field_17254;
        class_1297 other = ((CraftEntity)entity).getHandle();
        class_3898.class_3208 entry = (class_3898.class_3208)tracker.field_18242.get(other.method_5628());
        if (entry != null) {
            entry.method_18733(this.getHandle());
        }
        if (other instanceof class_3222) {
            class_3222 otherPlayer = (class_3222)other;
            if (otherPlayer.sentListPacket) {
                this.getHandle().field_13987.method_14364((class_2596)new class_7828(List.of(otherPlayer.method_5667())));
            }
        }
        this.server.getPluginManager().callEvent(new PlayerHideEntityEvent((Player)this, entity));
    }

    void resetAndHideEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.untrackAndHideEntity(entity);
        }
    }

    @Override
    @Deprecated
    public void showPlayer(Player player) {
        this.showEntity0(null, player);
    }

    @Override
    public void showPlayer(Plugin plugin, Player player) {
        this.showEntity(plugin, player);
    }

    @Override
    public void showEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity show cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldShow = entity.isVisibleByDefault() ? this.removeInvertedVisibility(plugin, entity) : this.addInvertedVisibility(plugin, entity);
        if (shouldShow) {
            this.trackAndShowEntity(entity);
        }
    }

    private boolean removeInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins == null) {
            return false;
        }
        invertedPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!invertedPlugins.isEmpty()) {
            return false;
        }
        this.invertedVisibilityEntities.remove(entity.getUniqueId());
        return true;
    }

    private void trackAndShowEntity(Entity entity) {
        class_3898.class_3208 entry;
        class_3898 tracker = ((class_3218)this.getHandle().method_37908()).method_14178().field_17254;
        class_1297 other = ((CraftEntity)entity).getHandle();
        if (other instanceof class_3222) {
            class_3222 otherPlayer = (class_3222)other;
            this.getHandle().field_13987.method_14364((class_2596)class_2703.method_43886(List.of(otherPlayer)));
        }
        if ((entry = (class_3898.class_3208)tracker.field_18242.get(other.method_5628())) != null && !entry.field_18250.contains(this.getHandle().field_13987)) {
            entry.method_18736(this.getHandle());
        }
        this.server.getPluginManager().callEvent(new PlayerShowEntityEvent((Player)this, entity));
    }

    void resetAndShowEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.trackAndShowEntity(entity);
        }
    }

    public void onEntityRemove(class_1297 entity) {
        this.invertedVisibilityEntities.remove(entity.method_5667());
    }

    @Override
    public boolean canSee(Player player) {
        return this.canSee((Entity)player);
    }

    @Override
    public boolean canSee(Entity entity) {
        return this.equals(entity) || entity.isVisibleByDefault() ^ this.invertedVisibilityEntities.containsKey(entity.getUniqueId());
    }

    public boolean canSeePlayer(UUID uuid) {
        Player entity = this.getServer().getPlayer(uuid);
        return entity != null ? this.canSee((Entity)entity) : false;
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    @Override
    public Player getPlayer() {
        return this;
    }

    public class_3222 getHandle() {
        return (class_3222)this.entity;
    }

    public void setHandle(class_3222 entity) {
        super.setHandle((class_1657)entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + "}";
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    @Override
    public long getLastPlayed() {
        return this.lastPlayed;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(class_2487 nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.method_10545("bukkit")) {
            class_2487 data = nbttagcompound.method_10562("bukkit");
            if (data.method_10545("firstPlayed")) {
                this.firstPlayed = data.method_10537("firstPlayed");
                this.lastPlayed = data.method_10537("lastPlayed");
            }
            if (data.method_10545("newExp")) {
                class_3222 handle = this.getHandle();
                handle.newExp = data.method_10550("newExp");
                handle.newTotalExp = data.method_10550("newTotalExp");
                handle.newLevel = data.method_10550("newLevel");
                handle.expToDrop = data.method_10550("expToDrop");
                handle.keepLevel = data.method_10577("keepLevel");
            }
        }
    }

    public void setExtraData(class_2487 nbttagcompound) {
        if (!nbttagcompound.method_10545("bukkit")) {
            nbttagcompound.method_10566("bukkit", (class_2520)new class_2487());
        }
        class_2487 data = nbttagcompound.method_10562("bukkit");
        class_3222 handle = this.getHandle();
        data.method_10569("newExp", handle.newExp);
        data.method_10569("newTotalExp", handle.newTotalExp);
        data.method_10569("newLevel", handle.newLevel);
        data.method_10569("expToDrop", handle.expToDrop);
        data.method_10556("keepLevel", handle.keepLevel);
        data.method_10544("firstPlayed", this.getFirstPlayed());
        data.method_10544("lastPlayed", System.currentTimeMillis());
        data.method_10582("lastKnownName", handle.method_5820());
    }

    @Override
    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    @Override
    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, new ManuallyAbandonedConversationCanceller()));
    }

    @Override
    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    @Override
    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    @Override
    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            class_2960 id = class_2960.method_60654((String)StandardMessenger.validateAndCorrectChannel(channel));
            this.sendCustomPayload(id, message);
        }
    }

    private void sendCustomPayload(class_2960 id, byte[] message) {
        class_2658 packet = new class_2658((class_8710)new class_8711(id, Unpooled.wrappedBuffer((byte[])message)));
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    @Override
    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    @Override
    public void setResourcePack(String url) {
        this.setResourcePack(url, null);
    }

    @Override
    public void setResourcePack(String url, byte[] hash) {
        this.setResourcePack(url, hash, false);
    }

    @Override
    public void setResourcePack(String url, byte[] hash, String prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    @Override
    public void setResourcePack(String url, byte[] hash, boolean force) {
        this.setResourcePack(url, hash, null, force);
    }

    @Override
    public void setResourcePack(String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        this.setResourcePack(UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, hash, prompt, force);
    }

    @Override
    public void setResourcePack(UUID id, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack ID cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new class_2720(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), true);
    }

    @Override
    public void addResourcePack(UUID id, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new class_2720(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), false);
    }

    @Override
    public void removeResourcePack(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack id cannot be null");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_9053(Optional.of(id)));
    }

    @Override
    public void removeResourcePacks() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_9053(Optional.empty()));
    }

    private void handlePushResourcePack(class_2720 resourcePackPushPacket, boolean resetBeforePush) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (resetBeforePush) {
            this.removeResourcePacks();
        }
        this.getHandle().field_13987.method_14364((class_2596)resourcePackPushPacket);
    }

    public void addChannel(String channel) {
        Preconditions.checkState((this.channels.size() < 128 ? 1 : 0) != 0, (String)"Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel(channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent(new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel(channel))) {
            this.server.getPluginManager().callEvent(new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        Set<String> listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.sendCustomPayload(class_2960.method_60656((String)"register"), stream.toByteArray());
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        class_1703 container = this.getHandle().field_7512;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.method_7606(prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    @Override
    public boolean isFlying() {
        return this.getHandle().method_31549().field_7479;
    }

    @Override
    public void setFlying(boolean value) {
        if (!this.getAllowFlight()) {
            Preconditions.checkArgument((!value ? 1 : 0) != 0, (Object)"Player is not allowed to fly (check #getAllowFlight())");
        }
        this.getHandle().method_31549().field_7479 = value;
        this.getHandle().method_7355();
    }

    @Override
    public boolean getAllowFlight() {
        return this.getHandle().method_31549().field_7478;
    }

    @Override
    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().method_31549().field_7479 = false;
        }
        this.getHandle().method_31549().field_7478 = value;
        this.getHandle().method_7355();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().field_13998 > 0) {
            return Math.max(this.getHandle().field_13998, this.getHandle().field_6008);
        }
        return this.getHandle().field_6008;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        super.setNoDamageTicks(ticks);
        this.getHandle().field_13998 = ticks;
    }

    @Override
    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        class_3222 player = this.getHandle();
        player.method_31549().field_7481 = value / 2.0f;
        player.method_7355();
    }

    @Override
    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        class_3222 player = this.getHandle();
        player.method_31549().field_7482 = value / 2.0f;
        player.method_7355();
        this.getHandle().method_5996(class_5134.field_23719).method_6192((double)player.method_31549().field_7482);
    }

    @Override
    public float getFlySpeed() {
        return this.getHandle().method_31549().field_7481 * 2.0f;
    }

    @Override
    public float getWalkSpeed() {
        return this.getHandle().method_31549().field_7482 * 2.0f;
    }

    private void validateSpeed(float value) {
        Preconditions.checkArgument((value <= 1.0f && value >= -1.0f ? 1 : 0) != 0, (String)"Speed value (%s) need to be between -1f and 1f", (Object)Float.valueOf(value));
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, amount);
        this.getHandle().method_14217();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().method_14217();
    }

    @Override
    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Preconditions.checkArgument((scoreboard != null ? 1 : 0) != 0, (Object)"Scoreboard cannot be null");
        Preconditions.checkState((this.getHandle().field_13987 != null ? 1 : 0) != 0, (Object)"Cannot set scoreboard yet (invalid player connection)");
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    @Override
    public void setHealthScale(double value) {
        Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0, (String)"Health value (%s) must be greater than 0", (Object)value);
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    @Override
    public double getHealthScale() {
        return this.healthScale;
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    @Override
    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        class_5131 attributemapserver = this.getHandle().method_6127();
        Collection set = attributemapserver.method_26851();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().field_13987 != null) {
            this.getHandle().field_13987.method_14364((class_2596)new class_2781(this.getHandle().method_5628(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().method_5841().method_12778(class_1309.field_6247, (Object)Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    @Override
    public void sendHealthUpdate(double health, int foodLevel, float saturation) {
        this.getHandle().field_13987.method_14364((class_2596)new class_2749((float)health, foodLevel, saturation));
    }

    @Override
    public void sendHealthUpdate() {
        class_1702 foodData = this.getHandle().method_7344();
        this.sendHealthUpdate(this.getScaledHealth(), foodData.method_7586(), foodData.method_7589());
    }

    public void injectScaledMaxHealth(Collection<class_1324> collection, boolean force) {
        double healthMod;
        if (!this.scaledHealth && !force) {
            return;
        }
        for (class_1324 genericInstance : collection) {
            if (genericInstance.method_6198() != class_5134.field_23716) continue;
            collection.remove(genericInstance);
            break;
        }
        class_1324 dummy = new class_1324(class_5134.field_23716, attribute -> {});
        double d = healthMod = this.scaledHealth ? this.healthScale : this.getMaxHealth();
        if (healthMod >= 3.4028234663852886E38 || healthMod <= 0.0) {
            healthMod = 20.0;
            this.getServer().getLogger().warning(this.getName() + " tried to crash the server with a large health attribute");
        }
        dummy.method_6192(healthMod);
        collection.add(dummy);
    }

    @Override
    public Entity getSpectatorTarget() {
        class_1297 followed = this.getHandle().method_14242();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    @Override
    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().method_14224(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    @Override
    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    @Override
    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        class_5905 times = new class_5905(fadeIn, stay, fadeOut);
        this.getHandle().field_13987.method_14364((class_2596)times);
        if (title != null) {
            class_5904 packetTitle = new class_5904(CraftChatMessage.fromString(title)[0]);
            this.getHandle().field_13987.method_14364((class_2596)packetTitle);
        }
        if (subtitle != null) {
            class_5903 packetSubtitle = new class_5903(CraftChatMessage.fromString(subtitle)[0]);
            this.getHandle().field_13987.method_14364((class_2596)packetSubtitle);
        }
    }

    @Override
    public void resetTitle() {
        class_5888 packetReset = new class_5888(true);
        this.getHandle().field_13987.method_14364((class_2596)packetReset);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        class_2675 packetplayoutworldparticles = new class_2675(CraftParticle.createParticleParam(particle, data), force, (double)((float)x), (double)((float)y), (double)((float)z), (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().field_13987.method_14364((class_2596)packetplayoutworldparticles);
    }

    @Override
    public AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        class_2985 data = this.getHandle().method_14236();
        class_167 progress = data.method_12882(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    @Override
    public int getClientViewDistance() {
        return this.getHandle().method_52371() == 0 ? Bukkit.getViewDistance() : this.getHandle().method_52371();
    }

    @Override
    public int getPing() {
        return this.getHandle().field_13987.method_52405();
    }

    @Override
    public String getLocale() {
        return this.getHandle().field_46156;
    }

    @Override
    public void updateCommands() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13995.method_3734().method_9241(this.getHandle());
    }

    @Override
    public void openBook(ItemStack book) {
        Preconditions.checkArgument((book != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        Preconditions.checkArgument((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"ItemStack Material (%s) must be Material.WRITTEN_BOOK", (Object)book.getType());
        ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().method_7315(CraftItemStack.asNMSCopy(book), class_1268.field_5808);
        this.getInventory().setItemInMainHand(hand);
    }

    @Override
    public void openSign(Sign sign) {
        this.openSign(sign, Side.FRONT);
    }

    @Override
    public void openSign(@NotNull Sign sign, @NotNull Side side) {
        CraftSign.openSign(sign, this, side);
    }

    @Override
    public void showDemoScreen() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2668(class_2668.field_25650, 0.0f));
    }

    @Override
    public boolean isAllowingServerListings() {
        return this.getHandle().method_39426();
    }

    @Override
    public Player.Spigot spigot() {
        return this.spigot;
    }

    public record CookieFuture(class_2960 key, CompletableFuture<byte[]> future) {
    }

    public static interface TransferCookieConnection {
        public boolean isTransferred();

        public class_2539 getProtocol();

        public void sendPacket(class_2596<?> var1);
    }

    private record ChunkSectionChanges(ShortSet positions, List<class_2680> blockData) {
        public ChunkSectionChanges() {
            this((ShortSet)new ShortArraySet(), new ArrayList<class_2680>());
        }
    }
}

