/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.class_1429;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4140;
import net.minecraft.class_8153;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Sniffer;

public class CraftSniffer
extends CraftAnimals
implements Sniffer {
    public CraftSniffer(CraftServer server, class_8153 entity) {
        super(server, (class_1429)entity);
    }

    public class_8153 getHandle() {
        return (class_8153)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftSniffer";
    }

    @Override
    public Collection<Location> getExploredLocations() {
        return this.getHandle().method_49143().map(blockPosition -> CraftLocation.toBukkit(blockPosition.comp_2208(), (class_1937)this.server.getServer().method_3847(blockPosition.comp_2207()))).collect(Collectors.toList());
    }

    @Override
    public void removeExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        class_2338 blockPosition = CraftLocation.toBlockPosition(location);
        this.getHandle().method_18868().method_18878(class_4140.field_42637, this.getHandle().method_49143().filter(blockPositionExplored -> !blockPositionExplored.equals((Object)blockPosition)).collect(Collectors.toList()));
    }

    @Override
    public void addExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        this.getHandle().method_49145(CraftLocation.toBlockPosition(location));
    }

    @Override
    public Sniffer.State getState() {
        return this.stateToBukkit(this.getHandle().method_49138());
    }

    @Override
    public void setState(Sniffer.State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.getHandle().method_49132(this.stateToNMS(state));
    }

    @Override
    public Location findPossibleDigLocation() {
        return this.getHandle().method_49134().map(blockPosition -> CraftLocation.toBukkit(blockPosition, this.getLocation().getWorld())).orElse(null);
    }

    @Override
    public boolean canDig() {
        return this.getHandle().method_49135();
    }

    private class_8153.class_8154 stateToNMS(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.IDLING -> class_8153.class_8154.field_42665;
            case Sniffer.State.FEELING_HAPPY -> class_8153.class_8154.field_42666;
            case Sniffer.State.SCENTING -> class_8153.class_8154.field_42667;
            case Sniffer.State.SNIFFING -> class_8153.class_8154.field_42668;
            case Sniffer.State.SEARCHING -> class_8153.class_8154.field_42669;
            case Sniffer.State.DIGGING -> class_8153.class_8154.field_42670;
            case Sniffer.State.RISING -> class_8153.class_8154.field_42671;
        };
    }

    private Sniffer.State stateToBukkit(class_8153.class_8154 state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case class_8153.class_8154.field_42665 -> Sniffer.State.IDLING;
            case class_8153.class_8154.field_42666 -> Sniffer.State.FEELING_HAPPY;
            case class_8153.class_8154.field_42667 -> Sniffer.State.SCENTING;
            case class_8153.class_8154.field_42668 -> Sniffer.State.SNIFFING;
            case class_8153.class_8154.field_42669 -> Sniffer.State.SEARCHING;
            case class_8153.class_8154.field_42670 -> Sniffer.State.DIGGING;
            case class_8153.class_8154.field_42671 -> Sniffer.State.RISING;
        };
    }
}

