/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3988;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, class_1646 entity) {
        super(server, (class_3988)entity);
    }

    public class_1646 getHandle() {
        return (class_1646)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public void remove() {
        this.getHandle().method_30958();
        super.remove();
    }

    @Override
    public Villager.Profession getProfession() {
        return CraftProfession.minecraftToBukkit(this.getHandle().method_7231().method_16924());
    }

    @Override
    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().method_7195(this.getHandle().method_7231().method_16921(CraftProfession.bukkitToMinecraft(profession)));
    }

    @Override
    public Villager.Type getVillagerType() {
        return CraftType.minecraftToBukkit(this.getHandle().method_7231().method_16919());
    }

    @Override
    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().method_7195(this.getHandle().method_7231().method_16922(CraftType.bukkitToMinecraft(type)));
    }

    @Override
    public int getVillagerLevel() {
        return this.getHandle().method_7231().method_16925();
    }

    @Override
    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().method_7195(this.getHandle().method_7231().method_16920(level));
    }

    @Override
    public int getVillagerExperience() {
        return this.getHandle().method_19269();
    }

    @Override
    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().method_19625(experience);
    }

    @Override
    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        class_2338 position = CraftLocation.toBlockPosition(location);
        class_2680 iblockdata = this.getHandle().method_37908().method_8320(position);
        if (!(iblockdata.method_26204() instanceof class_2244)) {
            return false;
        }
        this.getHandle().method_18403(position);
        return true;
    }

    @Override
    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().method_18400();
    }

    @Override
    public void shakeHead() {
        this.getHandle().method_20264();
    }

    @Override
    public ZombieVillager zombify() {
        class_1641 entityzombievillager = class_1642.zombifyVillager((class_3218)this.getHandle().method_37908().getMinecraftWorld(), (class_1646)this.getHandle(), (class_2338)this.getHandle().method_24515(), (boolean)this.isSilent(), (CreatureSpawnEvent.SpawnReason)CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)((Object)entityzombievillager.getBukkitEntity()) : null;
    }

    public static class CraftProfession {
        public static Villager.Profession minecraftToBukkit(class_3852 minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41234);
            Villager.Profession bukkit = Registry.VILLAGER_PROFESSION.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113((Object)minecraft).orElseThrow()).method_29177()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static class_3852 bukkitToMinecraft(Villager.Profession bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (class_3852)CraftRegistry.getMinecraftRegistry(class_7924.field_41234).method_17966(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }

    public static class CraftType {
        public static Villager.Type minecraftToBukkit(class_3854 minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41235);
            Villager.Type bukkit = Registry.VILLAGER_TYPE.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113((Object)minecraft).orElseThrow()).method_29177()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static class_3854 bukkitToMinecraft(Villager.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (class_3854)CraftRegistry.getMinecraftRegistry(class_7924.field_41235).method_17966(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }
}

