/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_3532;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6012;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7869;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R1.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_21_R1.generator.InternalChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R1.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_21_R1.util.RandomSourceWrapper;
import org.bukkit.generator.ChunkGenerator;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    private final class_2794 delegate;
    private final ChunkGenerator generator;
    private final class_3218 world;
    private final Random random = new Random();
    private boolean newApi;
    private boolean implementBaseHeight = true;

    public CustomChunkGenerator(class_3218 world, class_2794 delegate, ChunkGenerator generator) {
        super(delegate.method_12098(), delegate.field_39413);
        this.world = world;
        this.delegate = delegate;
        this.generator = generator;
    }

    public class_2794 getDelegate() {
        return this.delegate;
    }

    private static class_2919 getSeededRandom() {
        return new class_2919((class_5819)new class_5820(0L));
    }

    public class_1966 method_12098() {
        return this.delegate.method_12098();
    }

    public int method_33730() {
        return this.delegate.method_33730();
    }

    public int method_16398() {
        return this.delegate.method_16398();
    }

    public void method_16129(class_5455 iregistrycustom, class_7869 chunkgeneratorstructurestate, class_5138 structuremanager, class_2791 ichunkaccess, class_3485 structuretemplatemanager) {
        class_2919 random = CustomChunkGenerator.getSeededRandom();
        int x = ichunkaccess.method_12004().field_9181;
        int z = ichunkaccess.method_12004().field_9180;
        random.method_43052(class_3532.method_15371((int)x, (int)"should-structures".hashCode(), (int)z) ^ this.world.method_8412());
        if (this.generator.shouldGenerateStructures(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z)) {
            super.method_16129(iregistrycustom, chunkgeneratorstructurestate, structuremanager, ichunkaccess, structuretemplatemanager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_12110(class_3233 regionlimitedworldaccess, class_5138 structuremanager, class_7138 randomstate, class_2791 ichunkaccess) {
        ChunkGenerator.ChunkData data;
        int z;
        int x;
        block15: {
            class_2919 random = CustomChunkGenerator.getSeededRandom();
            x = ichunkaccess.method_12004().field_9181;
            z = ichunkaccess.method_12004().field_9180;
            random.method_43052(class_3532.method_15371((int)x, (int)"should-surface".hashCode(), (int)z) ^ regionlimitedworldaccess.method_8412());
            if (this.generator.shouldGenerateSurface(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z)) {
                this.delegate.method_12110(regionlimitedworldaccess, structuremanager, randomstate, ichunkaccess);
            }
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
            random.method_43052((long)x * 341873128712L + (long)z * 132897987541L);
            this.generator.generateSurface(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z, chunkData);
            if (this.generator.shouldGenerateBedrock()) {
                random = CustomChunkGenerator.getSeededRandom();
                random.method_43052((long)x * 341873128712L + (long)z * 132897987541L);
            }
            random = CustomChunkGenerator.getSeededRandom();
            random.method_43052((long)x * 341873128712L + (long)z * 132897987541L);
            this.generator.generateBedrock(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z, chunkData);
            chunkData.breakLink();
            if (this.newApi) {
                return;
            }
            this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(ichunkaccess);
            try {
                if (this.generator.isParallelCapable()) {
                    data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
                    break block15;
                }
                CustomChunkGenerator customChunkGenerator = this;
                synchronized (customChunkGenerator) {
                    data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
                }
            }
            catch (UnsupportedOperationException exception) {
                this.newApi = true;
                return;
            }
        }
        Preconditions.checkArgument((boolean)(data instanceof OldCraftChunkData), (String)"Plugins must use createChunkData(World) rather than implementing ChunkData: %s", (Object)data);
        OldCraftChunkData craftData = (OldCraftChunkData)data;
        class_2826[] sections = craftData.getRawChunkData();
        class_2826[] csect = ichunkaccess.method_12006();
        int scnt = Math.min(csect.length, sections.length);
        for (int sec = 0; sec < scnt; ++sec) {
            if (sections[sec] == null) continue;
            class_2826 section = sections[sec];
            class_2826 oldSection = csect[sec];
            for (int biomeX = 0; biomeX < 4; ++biomeX) {
                for (int biomeY = 0; biomeY < 4; ++biomeY) {
                    for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                        section.setBiome(biomeX, biomeY, biomeZ, oldSection.method_38293(biomeX, biomeY, biomeZ));
                    }
                }
            }
            csect[sec] = section;
        }
        if (craftData.getTiles() != null) {
            for (class_2338 pos : craftData.getTiles()) {
                int tz;
                int ty;
                int tx = pos.method_10263();
                class_2680 block = craftData.getTypeId(tx, ty = pos.method_10264(), tz = pos.method_10260());
                if (!block.method_31709()) continue;
                class_2586 tile = ((class_2343)block.method_26204()).method_10123(new class_2338((x << 4) + tx, ty, (z << 4) + tz), block);
                ichunkaccess.method_12007(tile);
            }
        }
    }

    public void method_12108(class_3233 regionlimitedworldaccess, long seed, class_7138 randomstate, class_4543 biomemanager, class_5138 structuremanager, class_2791 ichunkaccess, class_2893.class_2894 worldgenstage_features) {
        class_2919 random = CustomChunkGenerator.getSeededRandom();
        int x = ichunkaccess.method_12004().field_9181;
        int z = ichunkaccess.method_12004().field_9180;
        random.method_43052(class_3532.method_15371((int)x, (int)"should-caves".hashCode(), (int)z) ^ regionlimitedworldaccess.method_8412());
        if (this.generator.shouldGenerateCaves(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z)) {
            this.delegate.method_12108(regionlimitedworldaccess, seed, randomstate, biomemanager, structuremanager, ichunkaccess, worldgenstage_features);
        }
        CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
        random.method_12661(seed, 0, 0);
        this.generator.generateCaves(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z, chunkData);
        chunkData.breakLink();
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 randomstate, class_5138 structuremanager, class_2791 ichunkaccess) {
        CompletableFuture future = null;
        class_2919 random = CustomChunkGenerator.getSeededRandom();
        int x = ichunkaccess.method_12004().field_9181;
        int z = ichunkaccess.method_12004().field_9180;
        random.method_43052(class_3532.method_15371((int)x, (int)"should-noise".hashCode(), (int)z) ^ this.world.method_8412());
        if (this.generator.shouldGenerateNoise(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z)) {
            future = this.delegate.method_12088(blender, randomstate, structuremanager, ichunkaccess);
        }
        Function<class_2791, class_2791> function = ichunkaccess1 -> {
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), (class_2791)ichunkaccess1);
            random.method_43052((long)x * 341873128712L + (long)z * 132897987541L);
            this.generator.generateNoise(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z, chunkData);
            chunkData.breakLink();
            return ichunkaccess1;
        };
        return future == null ? CompletableFuture.supplyAsync(() -> (class_2791)function.apply(ichunkaccess), class_156.method_18349()) : future.thenApply(function);
    }

    public int method_16397(int i, int j, class_2902.class_2903 heightmap_type, class_5539 levelheightaccessor, class_7138 randomstate) {
        if (this.implementBaseHeight) {
            try {
                class_2919 random = CustomChunkGenerator.getSeededRandom();
                int xChunk = i >> 4;
                int zChunk = j >> 4;
                random.method_43052((long)xChunk * 341873128712L + (long)zChunk * 132897987541L);
                return this.generator.getBaseHeight(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), i, j, CraftHeightMap.fromNMS(heightmap_type));
            }
            catch (UnsupportedOperationException exception) {
                this.implementBaseHeight = false;
            }
        }
        return this.delegate.method_16397(i, j, heightmap_type, levelheightaccessor, randomstate);
    }

    public class_6012<class_5483.class_1964> method_12113(class_6880<class_1959> holder, class_5138 structuremanager, class_1311 enumcreaturetype, class_2338 blockposition) {
        return this.delegate.method_12113(holder, structuremanager, enumcreaturetype, blockposition);
    }

    public void method_12102(class_5281 generatoraccessseed, class_2791 ichunkaccess, class_5138 structuremanager) {
        class_2919 random = CustomChunkGenerator.getSeededRandom();
        int x = ichunkaccess.method_12004().field_9181;
        int z = ichunkaccess.method_12004().field_9180;
        random.method_43052(class_3532.method_15371((int)x, (int)"should-decoration".hashCode(), (int)z) ^ generatoraccessseed.method_8412());
        super.applyBiomeDecoration(generatoraccessseed, ichunkaccess, structuremanager, this.generator.shouldGenerateDecorations(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z));
    }

    public void method_40450(List<String> list, class_7138 randomstate, class_2338 blockposition) {
        this.delegate.method_40450(list, randomstate, blockposition);
    }

    public void method_12107(class_3233 regionlimitedworldaccess) {
        class_2919 random = CustomChunkGenerator.getSeededRandom();
        int x = regionlimitedworldaccess.method_33561().field_9181;
        int z = regionlimitedworldaccess.method_33561().field_9180;
        random.method_43052(class_3532.method_15371((int)x, (int)"should-mobs".hashCode(), (int)z) ^ regionlimitedworldaccess.method_8412());
        if (this.generator.shouldGenerateMobs(this.world.getWorld(), new RandomSourceWrapper.RandomWrapper((class_5819)random), x, z)) {
            this.delegate.method_12107(regionlimitedworldaccess);
        }
    }

    public int method_12100(class_5539 levelheightaccessor) {
        return this.delegate.method_12100(levelheightaccessor);
    }

    public int method_12104() {
        return this.delegate.method_12104();
    }

    public class_4966 method_26261(int i, int j, class_5539 levelheightaccessor, class_7138 randomstate) {
        return this.delegate.method_26261(i, j, levelheightaccessor, randomstate);
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return MapCodec.unit(null);
    }

    @Deprecated
    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final class_2791 biome;

        public CustomBiomeGrid(class_2791 biome) {
            this.biome = biome;
        }

        @Override
        public Biome getBiome(int x, int z) {
            return this.getBiome(x, 0, z);
        }

        @Override
        public void setBiome(int x, int z, Biome bio) {
            for (int y = CustomChunkGenerator.this.world.getWorld().getMinHeight(); y < CustomChunkGenerator.this.world.getWorld().getMaxHeight(); y += 4) {
                this.setBiome(x, y, z, bio);
            }
        }

        @Override
        public Biome getBiome(int x, int y, int z) {
            return CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)this.biome.method_16359(x >> 2, y >> 2, z >> 2));
        }

        @Override
        public void setBiome(int x, int y, int z, Biome bio) {
            Preconditions.checkArgument((bio != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)bio);
            this.biome.setBiome(x >> 2, y >> 2, z >> 2, CraftBiome.bukkitToMinecraftHolder(bio));
        }
    }
}

