/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftBiomeParameterPoint;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CustomWorldChunkManager
extends class_1966 {
    private final WorldInfo worldInfo;
    private final BiomeProvider biomeProvider;
    private final class_2378<class_1959> registry;

    private static List<class_6880<class_1959>> biomeListToBiomeBaseList(List<Biome> biomes, class_2378<class_1959> registry) {
        ArrayList<class_6880<class_1959>> biomeBases = new ArrayList<class_6880<class_1959>>();
        for (Biome biome : biomes) {
            Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot use the biome %s", (Object)biome);
            biomeBases.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        return biomeBases;
    }

    public CustomWorldChunkManager(WorldInfo worldInfo, BiomeProvider biomeProvider, class_2378<class_1959> registry) {
        this.worldInfo = worldInfo;
        this.biomeProvider = biomeProvider;
        this.registry = registry;
    }

    protected MapCodec<? extends class_1966> method_28442() {
        throw new UnsupportedOperationException("Cannot serialize CustomWorldChunkManager");
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        Biome biome = this.biomeProvider.getBiome(this.worldInfo, x << 2, y << 2, z << 2, CraftBiomeParameterPoint.createBiomeParameterPoint(sampler, sampler.method_40444(x, y, z)));
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        return CraftBiome.bukkitToMinecraftHolder(biome);
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return CustomWorldChunkManager.biomeListToBiomeBaseList(this.biomeProvider.getBiomes(this.worldInfo), this.registry).stream();
    }
}

