/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1320;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2609;
import net.minecraft.class_3962;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemMetas;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftItemType<M extends ItemMeta>
implements ItemType.Typed<M>,
Handleable<class_1792> {
    private final NamespacedKey key;
    private final class_1792 item;
    private final Supplier<CraftItemMetas.ItemMetaData<M>> itemMetaData;

    public static Material minecraftToBukkit(class_1792 item) {
        return CraftMagicNumbers.getMaterial(item);
    }

    public static class_1792 bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getItem(material);
    }

    public static ItemType minecraftToBukkitNew(class_1792 minecraft) {
        return CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41197, Registry.ITEM);
    }

    public static class_1792 bukkitToMinecraftNew(ItemType bukkit) {
        return (class_1792)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftItemType(NamespacedKey key, class_1792 item) {
        this.key = key;
        this.item = item;
        this.itemMetaData = Suppliers.memoize(() -> CraftItemMetas.getItemMetaData(this));
    }

    @Override
    @NotNull
    public ItemType.Typed<ItemMeta> typed() {
        return this.typed((Class)ItemMeta.class);
    }

    @NotNull
    public <Other extends ItemMeta> ItemType.Typed<Other> typed(@NotNull Class<Other> itemMetaType) {
        if (itemMetaType.isAssignableFrom(this.itemMetaData.get().metaClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type item type " + this.key.toString() + " to meta type " + itemMetaType.getSimpleName());
    }

    @Override
    @NotNull
    public ItemStack createItemStack() {
        return this.createItemStack(1, null);
    }

    @Override
    @NotNull
    public ItemStack createItemStack(int amount) {
        return this.createItemStack(amount, null);
    }

    @Override
    @NotNull
    public ItemStack createItemStack(Consumer<? super M> metaConfigurator) {
        return this.createItemStack(1, metaConfigurator);
    }

    @Override
    @NotNull
    public ItemStack createItemStack(int amount, @Nullable Consumer<? super M> metaConfigurator) {
        ItemStack itemStack = new ItemStack(this.asMaterial(), amount);
        if (metaConfigurator != null) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            metaConfigurator.accept(itemMeta);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    @Override
    public class_1792 getHandle() {
        return this.item;
    }

    public M getItemMeta(class_1799 itemStack) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemStack().apply(itemStack));
    }

    public M getItemMeta(ItemMeta itemMeta) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemMeta().apply(this, (CraftMetaItem)itemMeta));
    }

    @Override
    public boolean hasBlockType() {
        return this.item instanceof class_1747;
    }

    @Override
    @NotNull
    public BlockType getBlockType() {
        class_1792 class_17922 = this.item;
        if (!(class_17922 instanceof class_1747)) {
            throw new IllegalStateException("The item type " + String.valueOf(this.getKey()) + " has no corresponding block type");
        }
        class_1747 block = (class_1747)class_17922;
        return CraftBlockType.minecraftToBukkitNew(block.method_7711());
    }

    @Override
    public Class<M> getItemMetaClass() {
        if (this == ItemType.AIR) {
            throw new UnsupportedOperationException("Air does not have ItemMeta");
        }
        return this.itemMetaData.get().metaClass();
    }

    @Override
    public int getMaxStackSize() {
        if (this == AIR) {
            return 0;
        }
        return (Integer)this.item.method_57347().method_57830(class_9334.field_50071, (Object)64);
    }

    @Override
    public short getMaxDurability() {
        return ((Integer)this.item.method_57347().method_57830(class_9334.field_50072, (Object)0)).shortValue();
    }

    @Override
    public boolean isEdible() {
        return this.item.method_57347().method_57832(class_9334.field_50075);
    }

    @Override
    public boolean isRecord() {
        return this.item.method_57347().method_57832(class_9334.field_52175);
    }

    @Override
    public boolean isFuel() {
        return class_2609.method_11195((class_1799)new class_1799((class_1935)this.item));
    }

    @Override
    public boolean isCompostable() {
        return class_3962.field_17566.containsKey((Object)this.item);
    }

    @Override
    public float getCompostChance() {
        Preconditions.checkArgument((boolean)this.isCompostable(), (Object)("The item type " + String.valueOf(this.getKey()) + " is not compostable"));
        return class_3962.field_17566.getFloat((Object)this.item);
    }

    @Override
    public ItemType getCraftingRemainingItem() {
        class_1792 expectedItem = this.item.method_7858();
        return expectedItem == null ? null : CraftItemType.minecraftToBukkitNew(expectedItem);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        ImmutableMultimap.Builder defaultAttributes = ImmutableMultimap.builder();
        class_9285 nmsDefaultAttributes = (class_9285)this.item.method_57347().method_57830(class_9334.field_49636, (Object)class_9285.field_49326);
        if (nmsDefaultAttributes.comp_2393().isEmpty()) {
            nmsDefaultAttributes = this.item.method_7844();
        }
        nmsDefaultAttributes.method_57482(CraftEquipmentSlot.getNMS(slot), (key, value) -> {
            Attribute attribute = CraftAttribute.minecraftToBukkit((class_1320)key.comp_349());
            defaultAttributes.put((Object)attribute, (Object)CraftAttributeInstance.convert(value, slot));
        });
        return defaultAttributes.build();
    }

    @Override
    public CreativeCategory getCreativeCategory() {
        return CreativeCategory.BUILDING_BLOCKS;
    }

    @Override
    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return this.getHandle().method_45382(((CraftWorld)world).getHandle().method_45162());
    }

    @Override
    @NotNull
    public String getTranslationKey() {
        return this.item.method_7876();
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    public Material asMaterial() {
        return Registry.MATERIAL.get(this.key);
    }
}

