/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9329;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class CraftMerchantRecipe
extends MerchantRecipe {
    private final class_1914 handle;

    public CraftMerchantRecipe(class_1914 merchantRecipe) {
        super(CraftItemStack.asBukkitCopy(merchantRecipe.field_9148), 0);
        this.handle = merchantRecipe;
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.field_9146.comp_2427()));
        merchantRecipe.field_9143.ifPresent(costB -> this.addIngredient(CraftItemStack.asBukkitCopy(costB.comp_2427())));
    }

    @Deprecated
    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, 0, 0);
    }

    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, int demand, int specialPrice) {
        super(result, uses, maxUses, experienceReward, experience, priceMultiplier, demand, specialPrice);
        this.handle = new class_1914(new class_9306((class_1935)class_1802.field_8162), Optional.empty(), CraftItemStack.asNMSCopy(result), uses, maxUses, experience, priceMultiplier, demand, this);
        this.setSpecialPrice(specialPrice);
        this.setExperienceReward(experienceReward);
    }

    @Override
    public int getSpecialPrice() {
        return this.handle.method_19277();
    }

    @Override
    public void setSpecialPrice(int specialPrice) {
        this.handle.field_18676 = specialPrice;
    }

    @Override
    public int getDemand() {
        return this.handle.field_18677;
    }

    @Override
    public void setDemand(int demand) {
        this.handle.field_18677 = demand;
    }

    @Override
    public int getUses() {
        return this.handle.field_9147;
    }

    @Override
    public void setUses(int uses) {
        this.handle.field_9147 = uses;
    }

    @Override
    public int getMaxUses() {
        return this.handle.field_9144;
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.handle.field_9144 = maxUses;
    }

    @Override
    public boolean hasExperienceReward() {
        return this.handle.field_9145;
    }

    @Override
    public void setExperienceReward(boolean flag) {
        this.handle.field_9145 = flag;
    }

    @Override
    public int getVillagerExperience() {
        return this.handle.field_18679;
    }

    @Override
    public void setVillagerExperience(int villagerExperience) {
        this.handle.field_18679 = villagerExperience;
    }

    @Override
    public float getPriceMultiplier() {
        return this.handle.field_18678;
    }

    @Override
    public void setPriceMultiplier(float priceMultiplier) {
        this.handle.field_18678 = priceMultiplier;
    }

    public class_1914 toMinecraft() {
        List<ItemStack> ingredients = this.getIngredients();
        Preconditions.checkState((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"No offered ingredients");
        class_1799 baseCostA = CraftItemStack.asNMSCopy(ingredients.get(0));
        this.handle.field_9146 = new class_9306(baseCostA.method_41409(), baseCostA.method_7947(), class_9329.method_57865((class_9323)baseCostA.method_57353()), baseCostA);
        if (ingredients.size() > 1) {
            class_1799 costB = CraftItemStack.asNMSCopy(ingredients.get(1));
            this.handle.field_9143 = Optional.of(new class_9306(costB.method_41409(), costB.method_7947(), class_9329.method_57865((class_9323)costB.method_57353()), costB));
        }
        return this.handle;
    }

    public static CraftMerchantRecipe fromBukkit(MerchantRecipe recipe) {
        if (recipe instanceof CraftMerchantRecipe) {
            return (CraftMerchantRecipe)recipe;
        }
        CraftMerchantRecipe craft = new CraftMerchantRecipe(recipe.getResult(), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier(), recipe.getDemand(), recipe.getSpecialPrice());
        craft.setIngredients(recipe.getIngredients());
        return craft;
    }
}

