/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.class_9336;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BlockStateMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    private static final Set<Material> SHULKER_BOX_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX});
    static final CraftMetaItem.ItemMetaKeyType<class_9279> BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49611, "BlockEntityTag");
    final Material material;
    private CraftBlockEntityState<?> blockEntityTag;
    private class_2487 internalTag;

    public CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.material = material;
        if (!(meta instanceof CraftMetaBlockState) || ((CraftMetaBlockState)meta).material != material) {
            this.blockEntityTag = null;
            return;
        }
        CraftMetaBlockState te = (CraftMetaBlockState)meta;
        this.blockEntityTag = te.blockEntityTag;
    }

    CraftMetaBlockState(class_9326 tag, Material material) {
        super(tag);
        this.material = material;
        CraftMetaBlockState.getOrEmpty(tag, BLOCK_ENTITY_TAG).ifPresent(nbt -> {
            this.blockEntityTag = CraftMetaBlockState.getBlockState(material, nbt.method_57461());
        });
        if (!tag.method_57848()) {
            CraftBlockEntityState<?> blockEntityTag = this.blockEntityTag;
            if (blockEntityTag == null) {
                blockEntityTag = CraftMetaBlockState.getBlockState(material, null);
            }
            class_9335 map = new class_9335(class_9323.field_49584);
            map.method_57936(tag);
            Set<class_9331<?>> applied = blockEntityTag.applyComponents((class_9323)map, tag);
            for (class_9331<?> seen : applied) {
                this.unhandledTags.clear(seen);
            }
            if (!applied.isEmpty()) {
                this.blockEntityTag = blockEntityTag;
            }
        }
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        String matName = SerializableMeta.getString(map, "blockMaterial", true);
        Material m = Material.getMaterial(matName);
        this.material = m != null ? m : Material.AIR;
        this.blockEntityTag = CraftMetaBlockState.getBlockState(this.material, this.internalTag);
        this.internalTag = null;
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.blockEntityTag != null) {
            tag.put(BLOCK_ENTITY_TAG, class_9279.method_57456((class_2487)this.blockEntityTag.getSnapshotNBTWithoutComponents()));
            for (class_9336 component : this.blockEntityTag.collectComponents()) {
                tag.putIfAbsent(component);
            }
        }
    }

    @Override
    void deserializeInternal(class_2487 tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.method_10573(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, 10)) {
            this.internalTag = tag.method_10562(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, class_2520> internalTags) {
        if (this.blockEntityTag != null) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, (class_2520)this.blockEntityTag.getSnapshotNBT());
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.blockEntityTag != null) {
            hash = 61 * hash + this.blockEntityTag.hashCode();
        }
        return original != hash ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState that = (CraftMetaBlockState)meta;
            return Objects.equal(this.blockEntityTag, that.blockEntityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag == null);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag == null;
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        if (this.blockEntityTag != null) {
            meta.blockEntityTag = this.blockEntityTag.copy();
        }
        return meta;
    }

    @Override
    public boolean hasBlockState() {
        return this.blockEntityTag != null;
    }

    @Override
    public BlockState getBlockState() {
        return this.blockEntityTag != null ? this.blockEntityTag.copy() : CraftMetaBlockState.getBlockState(this.material, null);
    }

    private static CraftBlockEntityState<?> getBlockState(Material material, class_2487 blockEntityTag) {
        Material stateMaterial;
        class_2338 pos = class_2338.field_10980;
        Material material2 = stateMaterial = material != Material.SHIELD ? material : CraftMetaBlockState.shieldToBannerHack();
        if (blockEntityTag != null) {
            if (material == Material.SHIELD) {
                blockEntityTag.method_10582("id", "minecraft:banner");
            } else if (material == Material.BEE_NEST || material == Material.BEEHIVE) {
                blockEntityTag.method_10582("id", "minecraft:beehive");
            } else if (SHULKER_BOX_MATERIALS.contains(material)) {
                blockEntityTag.method_10582("id", "minecraft:shulker_box");
            }
            pos = class_2586.method_38239((class_2487)blockEntityTag);
        }
        return (CraftBlockEntityState)CraftBlockStates.getBlockState(pos, stateMaterial, blockEntityTag);
    }

    @Override
    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState must not be null");
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack();
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Preconditions.checkArgument((blockStateType == blockState.getClass() && blockState instanceof CraftBlockEntityState ? 1 : 0) != 0, (Object)("Invalid blockState for " + String.valueOf(this.material)));
        this.blockEntityTag = (CraftBlockEntityState)blockState;
    }

    private static Material shieldToBannerHack() {
        return Material.WHITE_BANNER;
    }
}

