/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9291;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.inventory.meta.CompassMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaCompass
extends CraftMetaItem
implements CompassMeta {
    static final CraftMetaItem.ItemMetaKeyType<class_9291> LODESTONE_TARGET = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49614, "LodestoneDimension");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS = new CraftMetaItem.ItemMetaKey("lodestone");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_WORLD = new CraftMetaItem.ItemMetaKey("LodestonePosWorld");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_X = new CraftMetaItem.ItemMetaKey("LodestonePosX");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_Y = new CraftMetaItem.ItemMetaKey("LodestonePosY");
    static final CraftMetaItem.ItemMetaKey LODESTONE_POS_Z = new CraftMetaItem.ItemMetaKey("LodestonePosZ");
    static final CraftMetaItem.ItemMetaKey LODESTONE_TRACKED = new CraftMetaItem.ItemMetaKey("LodestoneTracked");
    private class_5321<class_1937> lodestoneWorld;
    private int lodestoneX;
    private int lodestoneY;
    private int lodestoneZ;
    private boolean tracked = true;

    CraftMetaCompass(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaCompass)) {
            return;
        }
        CraftMetaCompass compassMeta = (CraftMetaCompass)meta;
        this.lodestoneWorld = compassMeta.lodestoneWorld;
        this.lodestoneX = compassMeta.lodestoneX;
        this.lodestoneY = compassMeta.lodestoneY;
        this.lodestoneZ = compassMeta.lodestoneZ;
        this.tracked = compassMeta.tracked;
    }

    CraftMetaCompass(class_9326 tag) {
        super(tag);
        CraftMetaCompass.getOrEmpty(tag, LODESTONE_TARGET).ifPresent(lodestoneTarget -> {
            lodestoneTarget.comp_2402().ifPresent(target -> {
                this.lodestoneWorld = target.comp_2207();
                class_2338 pos = target.comp_2208();
                this.lodestoneX = pos.method_10263();
                this.lodestoneY = pos.method_10264();
                this.lodestoneZ = pos.method_10260();
            });
            this.tracked = lodestoneTarget.comp_2403();
        });
    }

    CraftMetaCompass(Map<String, Object> map) {
        super(map);
        String lodestoneWorldString = SerializableMeta.getString(map, CraftMetaCompass.LODESTONE_POS_WORLD.BUKKIT, true);
        if (lodestoneWorldString != null) {
            this.lodestoneWorld = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)lodestoneWorldString));
            this.lodestoneX = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_X.BUKKIT);
            this.lodestoneY = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_Y.BUKKIT);
            this.lodestoneZ = (Integer)map.get(CraftMetaCompass.LODESTONE_POS_Z.BUKKIT);
        } else {
            Location lodestone = SerializableMeta.getObject(Location.class, map, CraftMetaCompass.LODESTONE_POS.BUKKIT, true);
            if (lodestone != null && lodestone.getWorld() != null) {
                this.setLodestone(lodestone);
            }
        }
        this.tracked = SerializableMeta.getBoolean(map, CraftMetaCompass.LODESTONE_TRACKED.BUKKIT);
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        Optional<Object> target = Optional.empty();
        if (this.lodestoneWorld != null) {
            target = Optional.of(new class_4208(this.lodestoneWorld, new class_2338(this.lodestoneX, this.lodestoneY, this.lodestoneZ)));
        }
        if (target.isPresent() || this.hasLodestoneTracked()) {
            tag.put(LODESTONE_TARGET, new class_9291(target, this.tracked));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isCompassEmpty();
    }

    boolean isCompassEmpty() {
        return !this.hasLodestone() && !this.hasLodestoneTracked();
    }

    @Override
    public CraftMetaCompass clone() {
        CraftMetaCompass clone = (CraftMetaCompass)super.clone();
        return clone;
    }

    @Override
    public boolean hasLodestone() {
        return this.lodestoneWorld != null;
    }

    @Override
    public Location getLodestone() {
        if (this.lodestoneWorld == null) {
            return null;
        }
        class_3218 worldServer = MinecraftServer.getServer().method_3847(this.lodestoneWorld);
        CraftWorld world = worldServer != null ? worldServer.getWorld() : null;
        return new Location(world, this.lodestoneX, this.lodestoneY, this.lodestoneZ);
    }

    @Override
    public void setLodestone(Location lodestone) {
        Preconditions.checkArgument((lodestone == null || lodestone.getWorld() != null ? 1 : 0) != 0, (Object)"world is null");
        if (lodestone == null) {
            this.lodestoneWorld = null;
        } else {
            this.lodestoneWorld = ((CraftWorld)lodestone.getWorld()).getHandle().method_27983();
            this.lodestoneX = lodestone.getBlockX();
            this.lodestoneY = lodestone.getBlockY();
            this.lodestoneZ = lodestone.getBlockZ();
        }
    }

    boolean hasLodestoneTracked() {
        return !this.tracked;
    }

    @Override
    public boolean isLodestoneTracked() {
        return this.tracked;
    }

    @Override
    public void setLodestoneTracked(boolean tracked) {
        this.tracked = tracked;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasLodestone()) {
            hash = 73 * hash + this.lodestoneWorld.hashCode();
            hash = 73 * hash + this.lodestoneX;
            hash = 73 * hash + this.lodestoneY;
            hash = 73 * hash + this.lodestoneZ;
        }
        if (this.hasLodestoneTracked()) {
            hash = 73 * hash + (this.isLodestoneTracked() ? 1231 : 1237);
        }
        return original != hash ? CraftMetaCompass.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaCompass) {
            CraftMetaCompass that = (CraftMetaCompass)meta;
            return (this.hasLodestone() ? that.hasLodestone() && this.lodestoneWorld.equals(that.lodestoneWorld) && this.lodestoneX == that.lodestoneX && this.lodestoneY == that.lodestoneY && this.lodestoneZ == that.lodestoneZ : !that.hasLodestone()) && this.tracked == that.tracked;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaCompass || this.isCompassEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasLodestone()) {
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_WORLD.BUKKIT, (Object)this.lodestoneWorld.method_29177().toString());
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_X.BUKKIT, (Object)this.lodestoneX);
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_Y.BUKKIT, (Object)this.lodestoneY);
            builder.put((Object)CraftMetaCompass.LODESTONE_POS_Z.BUKKIT, (Object)this.lodestoneZ);
        }
        if (this.hasLodestoneTracked()) {
            builder.put((Object)CraftMetaCompass.LODESTONE_TRACKED.BUKKIT, (Object)this.tracked);
        }
        return builder;
    }
}

