/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.inventory.meta.FireworkMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaFirework
extends CraftMetaItem
implements FireworkMeta {
    static final CraftMetaItem.ItemMetaKeyType<class_9284> FIREWORKS = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49616, "Fireworks");
    static final CraftMetaItem.ItemMetaKey FLIGHT = new CraftMetaItem.ItemMetaKey("power");
    static final CraftMetaItem.ItemMetaKey EXPLOSIONS = new CraftMetaItem.ItemMetaKey("firework-effects");
    private List<FireworkEffect> effects;
    private int power;

    public CraftMetaFirework(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaFirework)) {
            return;
        }
        CraftMetaFirework that = (CraftMetaFirework)meta;
        this.power = that.power;
        if (that.hasEffects()) {
            this.effects = new ArrayList<FireworkEffect>(that.effects);
        }
    }

    CraftMetaFirework(class_9326 tag) {
        super(tag);
        CraftMetaFirework.getOrEmpty(tag, FIREWORKS).ifPresent(fireworks -> {
            this.power = fireworks.comp_2391();
            List fireworkEffects = fireworks.comp_2392();
            this.effects = new ArrayList<FireworkEffect>(fireworkEffects.size());
            ArrayList<FireworkEffect> effects = this.effects;
            for (int i = 0; i < fireworkEffects.size(); ++i) {
                try {
                    effects.add(CraftMetaFirework.getEffect((class_9283)fireworkEffects.get(i)));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    static FireworkEffect getEffect(class_9283 explosion) {
        int color;
        FireworkEffect.Builder effect = FireworkEffect.builder().flicker(explosion.comp_2390()).trail(explosion.comp_2389()).with(CraftMetaFirework.getEffectType(explosion.comp_2386()));
        IntList colors = explosion.comp_2387();
        if (colors.isEmpty()) {
            effect.withColor(Color.WHITE);
        }
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            color = (Integer)intListIterator.next();
            effect.withColor(Color.fromRGB(color));
        }
        intListIterator = explosion.comp_2388().iterator();
        while (intListIterator.hasNext()) {
            color = (Integer)intListIterator.next();
            effect.withFade(Color.fromRGB(color));
        }
        return effect.build();
    }

    static class_9283 getExplosion(FireworkEffect effect) {
        IntList colors = CraftMetaFirework.addColors(effect.getColors());
        IntList fadeColors = CraftMetaFirework.addColors(effect.getFadeColors());
        return new class_9283(CraftMetaFirework.getNBT(effect.getType()), colors, fadeColors, effect.hasTrail(), effect.hasFlicker());
    }

    static class_9283.class_1782 getNBT(FireworkEffect.Type type) {
        switch (type) {
            case BALL: {
                return class_9283.class_1782.field_7976;
            }
            case BALL_LARGE: {
                return class_9283.class_1782.field_7977;
            }
            case STAR: {
                return class_9283.class_1782.field_7973;
            }
            case CREEPER: {
                return class_9283.class_1782.field_7974;
            }
            case BURST: {
                return class_9283.class_1782.field_7970;
            }
        }
        throw new IllegalArgumentException("Unknown effect type " + String.valueOf((Object)type));
    }

    static FireworkEffect.Type getEffectType(class_9283.class_1782 nbt) {
        switch (nbt) {
            case field_7976: {
                return FireworkEffect.Type.BALL;
            }
            case field_7977: {
                return FireworkEffect.Type.BALL_LARGE;
            }
            case field_7973: {
                return FireworkEffect.Type.STAR;
            }
            case field_7974: {
                return FireworkEffect.Type.CREEPER;
            }
            case field_7970: {
                return FireworkEffect.Type.BURST;
            }
        }
        throw new IllegalArgumentException("Unknown effect type " + String.valueOf(nbt));
    }

    CraftMetaFirework(Map<String, Object> map) {
        super(map);
        Integer power = SerializableMeta.getObject(Integer.class, map, CraftMetaFirework.FLIGHT.BUKKIT, true);
        if (power != null) {
            this.power = power;
        }
        Iterable effects = SerializableMeta.getObject(Iterable.class, map, CraftMetaFirework.EXPLOSIONS.BUKKIT, true);
        this.safelyAddEffects(effects);
    }

    @Override
    public boolean hasEffects() {
        return this.effects != null && !this.effects.isEmpty();
    }

    void safelyAddEffects(Iterable<?> collection) {
        if (collection == null || collection instanceof Collection && ((Collection)collection).isEmpty()) {
            return;
        }
        List<FireworkEffect> effects = this.effects;
        if (effects == null) {
            effects = this.effects = new ArrayList<FireworkEffect>();
        }
        for (Object obj : collection) {
            Preconditions.checkArgument((boolean)(obj instanceof FireworkEffect), (String)"%s in %s is not a FireworkEffect", obj, collection);
            effects.add((FireworkEffect)obj);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator itemTag) {
        super.applyToItem(itemTag);
        if (this.isFireworkEmpty()) {
            return;
        }
        ArrayList<class_9283> effects = new ArrayList<class_9283>();
        if (this.hasEffects()) {
            for (FireworkEffect effect : this.effects) {
                effects.add(CraftMetaFirework.getExplosion(effect));
            }
        }
        itemTag.put(FIREWORKS, new class_9284(this.power, effects));
    }

    static IntList addColors(List<Color> colors) {
        if (colors.isEmpty()) {
            return IntList.of();
        }
        int[] colorArray = new int[colors.size()];
        int i = 0;
        for (Color color : colors) {
            colorArray[i++] = color.asRGB();
        }
        return IntList.of((int[])colorArray);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isFireworkEmpty();
    }

    boolean isFireworkEmpty() {
        return !this.hasEffects() && !this.hasPower();
    }

    boolean hasPower() {
        return this.power != 0;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaFirework) {
            CraftMetaFirework that = (CraftMetaFirework)meta;
            return (this.hasPower() ? that.hasPower() && this.power == that.power : !that.hasPower()) && (this.hasEffects() ? that.hasEffects() && this.effects.equals(that.effects) : !that.hasEffects());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaFirework || this.isFireworkEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasPower()) {
            hash = 61 * hash + this.power;
        }
        if (this.hasEffects()) {
            hash = 61 * hash + 13 * this.effects.hashCode();
        }
        return hash != original ? CraftMetaFirework.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasEffects()) {
            builder.put((Object)CraftMetaFirework.EXPLOSIONS.BUKKIT, (Object)ImmutableList.copyOf(this.effects));
        }
        if (this.hasPower()) {
            builder.put((Object)CraftMetaFirework.FLIGHT.BUKKIT, (Object)this.power);
        }
        return builder;
    }

    @Override
    public CraftMetaFirework clone() {
        CraftMetaFirework meta = (CraftMetaFirework)super.clone();
        if (this.effects != null) {
            meta.effects = new ArrayList<FireworkEffect>(this.effects);
        }
        return meta;
    }

    @Override
    public void addEffect(FireworkEffect effect) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"FireworkEffect cannot be null");
        if (this.effects == null) {
            this.effects = new ArrayList<FireworkEffect>();
        }
        this.effects.add(effect);
    }

    @Override
    public void addEffects(FireworkEffect ... effects) {
        Preconditions.checkArgument((effects != null ? 1 : 0) != 0, (Object)"effects cannot be null");
        if (effects.length == 0) {
            return;
        }
        List<FireworkEffect> list = this.effects;
        if (list == null) {
            list = this.effects = new ArrayList<FireworkEffect>();
        }
        for (FireworkEffect effect : effects) {
            Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"effects cannot contain null FireworkEffect");
            list.add(effect);
        }
    }

    @Override
    public void addEffects(Iterable<FireworkEffect> effects) {
        Preconditions.checkArgument((effects != null ? 1 : 0) != 0, (Object)"effects cannot be null");
        this.safelyAddEffects(effects);
    }

    @Override
    public List<FireworkEffect> getEffects() {
        return this.effects == null ? ImmutableList.of() : ImmutableList.copyOf(this.effects);
    }

    @Override
    public int getEffectsSize() {
        return this.effects == null ? 0 : this.effects.size();
    }

    @Override
    public void removeEffect(int index) {
        if (this.effects == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }
        this.effects.remove(index);
    }

    @Override
    public void clearEffects() {
        this.effects = null;
    }

    @Override
    public int getPower() {
        return this.hasPower() ? this.power : 0;
    }

    @Override
    public void setPower(int power) {
        Preconditions.checkArgument((power >= 0 ? 1 : 0) != 0, (String)"power cannot be less than zero: %s", (int)power);
        Preconditions.checkArgument((power < 128 ? 1 : 0) != 0, (String)"power cannot be more than 127: %s", (int)power);
        this.power = power;
    }
}

