/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_9296;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaSkull
extends CraftMetaItem
implements SkullMeta {
    static final CraftMetaItem.ItemMetaKeyType<class_9296> SKULL_PROFILE = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49617, "SkullProfile");
    static final CraftMetaItem.ItemMetaKey SKULL_OWNER = new CraftMetaItem.ItemMetaKey("skull-owner");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKey("BlockEntityTag");
    static final CraftMetaItem.ItemMetaKeyType<class_2960> NOTE_BLOCK_SOUND = new CraftMetaItem.ItemMetaKeyType(class_9334.field_49618, "note_block_sound");
    static final int MAX_OWNER_LENGTH = 16;
    private GameProfile profile;
    private class_2960 noteBlockSound;

    public CraftMetaSkull(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSkull)) {
            return;
        }
        CraftMetaSkull skullMeta = (CraftMetaSkull)meta;
        this.setProfile(skullMeta.profile);
        this.noteBlockSound = skullMeta.noteBlockSound;
    }

    CraftMetaSkull(class_9326 tag) {
        super(tag);
        CraftMetaSkull.getOrEmpty(tag, SKULL_PROFILE).ifPresent(resolvableProfile -> this.setProfile(resolvableProfile.comp_2413()));
        CraftMetaSkull.getOrEmpty(tag, NOTE_BLOCK_SOUND).ifPresent(minecraftKey -> {
            this.noteBlockSound = minecraftKey;
        });
    }

    CraftMetaSkull(Map<String, Object> map) {
        super(map);
        Object object;
        if (this.profile == null) {
            object = map.get(CraftMetaSkull.SKULL_OWNER.BUKKIT);
            if (object instanceof PlayerProfile) {
                this.setOwnerProfile((PlayerProfile)object);
            } else {
                this.setOwner(SerializableMeta.getString(map, CraftMetaSkull.SKULL_OWNER.BUKKIT, true));
            }
        }
        if (this.noteBlockSound == null && (object = map.get(CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT)) != null) {
            this.setNoteBlockSound(NamespacedKey.fromString(object.toString()));
        }
    }

    @Override
    void deserializeInternal(class_2487 tag, Object context) {
        class_2487 nbtTagCompound;
        super.deserializeInternal(tag, context);
        if (tag.method_10573(CraftMetaSkull.SKULL_PROFILE.NBT, 10)) {
            class_2487 skullTag = tag.method_10562(CraftMetaSkull.SKULL_PROFILE.NBT);
            if (skullTag.method_10573("Id", 8)) {
                UUID uuid = UUID.fromString(skullTag.method_10558("Id"));
                skullTag.method_25927("Id", uuid);
            }
            this.setProfile(((class_9296)class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)skullTag).result().get()).comp_2413());
        }
        if (tag.method_10573(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT, 10) && (nbtTagCompound = tag.method_10562(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT).method_10553()).method_10573(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT, 8)) {
            this.noteBlockSound = class_2960.method_12829((String)nbtTagCompound.method_10558(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT));
        }
    }

    private void setProfile(GameProfile profile) {
        this.profile = profile;
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.profile != null) {
            tag.put(SKULL_PROFILE, new class_9296(this.profile));
            CraftPlayerProfile ownerProfile = new CraftPlayerProfile(this.profile);
            if (ownerProfile.getTextures().isEmpty()) {
                ownerProfile.update().thenAccept(filledProfile -> {
                    this.setOwnerProfile((PlayerProfile)filledProfile);
                    tag.put(SKULL_PROFILE, new class_9296(this.profile));
                });
            }
        }
        if (this.noteBlockSound != null) {
            tag.put(NOTE_BLOCK_SOUND, this.noteBlockSound);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isSkullEmpty();
    }

    boolean isSkullEmpty() {
        return this.profile == null && this.noteBlockSound == null;
    }

    @Override
    public CraftMetaSkull clone() {
        return (CraftMetaSkull)super.clone();
    }

    @Override
    public boolean hasOwner() {
        return this.profile != null && !this.profile.getName().isEmpty();
    }

    @Override
    public String getOwner() {
        return this.hasOwner() ? this.profile.getName() : null;
    }

    @Override
    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            if (!this.profile.getId().equals(class_156.field_25140)) {
                return Bukkit.getOfflinePlayer(this.profile.getId());
            }
            if (!this.profile.getName().isEmpty()) {
                return Bukkit.getOfflinePlayer(this.profile.getName());
            }
        }
        return null;
    }

    @Override
    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (name == null) {
            this.setProfile(null);
        } else {
            this.setProfile(new GameProfile(class_156.field_25140, name));
        }
        return true;
    }

    @Override
    public boolean setOwningPlayer(OfflinePlayer owner) {
        if (owner == null) {
            this.setProfile(null);
        } else if (owner instanceof CraftPlayer) {
            this.setProfile(((CraftPlayer)owner).getProfile());
        } else {
            this.setProfile(new GameProfile(owner.getUniqueId(), owner.getName()));
        }
        return true;
    }

    @Override
    public PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    @Override
    public void setOwnerProfile(PlayerProfile profile) {
        if (profile == null) {
            this.setProfile(null);
        } else {
            this.setProfile(CraftPlayerProfile.validateSkullProfile(((CraftPlayerProfile)profile).buildGameProfile()));
        }
    }

    @Override
    public void setNoteBlockSound(NamespacedKey noteBlockSound) {
        this.noteBlockSound = noteBlockSound == null ? null : CraftNamespacedKey.toMinecraft(noteBlockSound);
    }

    @Override
    public NamespacedKey getNoteBlockSound() {
        return this.noteBlockSound == null ? null : CraftNamespacedKey.fromMinecraft(this.noteBlockSound);
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasOwner()) {
            hash = 61 * hash + this.profile.hashCode();
        }
        if (this.noteBlockSound != null) {
            hash = 61 * hash + this.noteBlockSound.hashCode();
        }
        return original != hash ? CraftMetaSkull.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSkull) {
            CraftMetaSkull that = (CraftMetaSkull)meta;
            return (this.profile != null ? that.profile != null && this.profile.equals((Object)that.profile) && this.profile.getProperties().equals((Object)that.profile.getProperties()) : that.profile == null) && Objects.equals(this.noteBlockSound, that.noteBlockSound);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSkull || this.isSkullEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        NamespacedKey namespacedKeyNB;
        super.serialize(builder);
        if (this.profile != null) {
            builder.put((Object)CraftMetaSkull.SKULL_OWNER.BUKKIT, (Object)new CraftPlayerProfile(this.profile));
        }
        if ((namespacedKeyNB = this.getNoteBlockSound()) != null) {
            builder.put((Object)CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT, (Object)namespacedKeyNB.toString());
        }
        return builder;
    }
}

