/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_4174;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionUtil;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.potion.PotionEffect;

@SerializableAs(value="Food")
public final class CraftFoodComponent
implements FoodComponent {
    private class_4174 handle;

    public CraftFoodComponent(class_4174 food) {
        this.handle = food;
    }

    public CraftFoodComponent(CraftFoodComponent food) {
        this.handle = food.handle;
    }

    public CraftFoodComponent(Map<String, Object> map) {
        Integer nutrition = SerializableMeta.getObject(Integer.class, map, "nutrition", false);
        Float saturationModifier = SerializableMeta.getObject(Float.class, map, "saturation", false);
        Boolean canAlwaysEat = SerializableMeta.getBoolean(map, "can-always-eat");
        Float eatSeconds = SerializableMeta.getObject(Float.class, map, "eat-seconds", true);
        if (eatSeconds == null) {
            eatSeconds = Float.valueOf(1.6f);
        }
        ItemStack usingConvertsTo = SerializableMeta.getObject(ItemStack.class, map, "using-converts-to", true);
        ImmutableList.Builder effects = ImmutableList.builder();
        Iterable rawEffectList = SerializableMeta.getObject(Iterable.class, map, "effects", true);
        if (rawEffectList != null) {
            for (Object obj : rawEffectList) {
                Preconditions.checkArgument((boolean)(obj instanceof FoodComponent.FoodEffect), (String)"Object (%s) in effect list is not valid", obj.getClass());
                effects.add((Object)new CraftFoodEffect((FoodComponent.FoodEffect)obj));
            }
        }
        this.handle = new class_4174(nutrition.intValue(), saturationModifier.floatValue(), canAlwaysEat.booleanValue(), eatSeconds.floatValue(), Optional.ofNullable(usingConvertsTo).map(CraftItemStack::asNMSCopy), effects.build().stream().map(CraftFoodEffect::new).map(CraftFoodEffect::getHandle).toList());
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("nutrition", this.getNutrition());
        result.put("saturation", Float.valueOf(this.getSaturation()));
        result.put("can-always-eat", this.canAlwaysEat());
        result.put("eat-seconds", Float.valueOf(this.getEatSeconds()));
        result.put("using-converts-to", this.getUsingConvertsTo());
        result.put("effects", this.getEffects());
        return result;
    }

    public class_4174 getHandle() {
        return this.handle;
    }

    @Override
    public int getNutrition() {
        return this.handle.comp_2491();
    }

    @Override
    public void setNutrition(int nutrition) {
        Preconditions.checkArgument((nutrition >= 0 ? 1 : 0) != 0, (Object)"Nutrition cannot be negative");
        this.handle = new class_4174(nutrition, this.handle.comp_2492(), this.handle.comp_2493(), this.handle.comp_2494(), this.handle.comp_2794(), this.handle.comp_2495());
    }

    @Override
    public float getSaturation() {
        return this.handle.comp_2492();
    }

    @Override
    public void setSaturation(float saturation) {
        this.handle = new class_4174(this.handle.comp_2491(), saturation, this.handle.comp_2493(), this.handle.comp_2494(), this.handle.comp_2794(), this.handle.comp_2495());
    }

    @Override
    public boolean canAlwaysEat() {
        return this.handle.comp_2493();
    }

    @Override
    public void setCanAlwaysEat(boolean canAlwaysEat) {
        this.handle = new class_4174(this.handle.comp_2491(), this.handle.comp_2492(), canAlwaysEat, this.handle.comp_2494(), this.handle.comp_2794(), this.handle.comp_2495());
    }

    @Override
    public float getEatSeconds() {
        return this.handle.comp_2494();
    }

    @Override
    public void setEatSeconds(float eatSeconds) {
        this.handle = new class_4174(this.handle.comp_2491(), this.handle.comp_2492(), this.handle.comp_2493(), eatSeconds, this.handle.comp_2794(), this.handle.comp_2495());
    }

    @Override
    public ItemStack getUsingConvertsTo() {
        return this.handle.comp_2794().map(CraftItemStack::asBukkitCopy).orElse(null);
    }

    @Override
    public void setUsingConvertsTo(ItemStack item) {
        this.handle = new class_4174(this.handle.comp_2491(), this.handle.comp_2492(), this.handle.comp_2493(), this.handle.comp_2494(), Optional.ofNullable(item).map(CraftItemStack::asNMSCopy), this.handle.comp_2495());
    }

    @Override
    public List<FoodComponent.FoodEffect> getEffects() {
        return this.handle.comp_2495().stream().map(CraftFoodEffect::new).collect(Collectors.toList());
    }

    @Override
    public void setEffects(List<FoodComponent.FoodEffect> effects) {
        this.handle = new class_4174(this.handle.comp_2491(), this.handle.comp_2492(), this.handle.comp_2493(), this.handle.comp_2494(), this.handle.comp_2794(), effects.stream().map(CraftFoodEffect::new).map(CraftFoodEffect::getHandle).toList());
    }

    @Override
    public FoodComponent.FoodEffect addEffect(PotionEffect effect, float probability) {
        ArrayList<class_4174.class_9423> effects = new ArrayList<class_4174.class_9423>(this.handle.comp_2495());
        class_4174.class_9423 newEffect = new class_4174.class_9423(CraftPotionUtil.fromBukkit(effect), probability);
        effects.add(newEffect);
        this.handle = new class_4174(this.handle.comp_2491(), this.handle.comp_2492(), this.handle.comp_2493(), this.handle.comp_2494(), this.handle.comp_2794(), effects);
        return new CraftFoodEffect(newEffect);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftFoodComponent other = (CraftFoodComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftFoodComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="FoodEffect")
    public static class CraftFoodEffect
    implements FoodComponent.FoodEffect {
        private class_4174.class_9423 handle;

        public CraftFoodEffect(class_4174.class_9423 handle) {
            this.handle = handle;
        }

        public CraftFoodEffect(FoodComponent.FoodEffect bukkit) {
            this.handle = new class_4174.class_9423(CraftPotionUtil.fromBukkit(bukkit.getEffect()), bukkit.getProbability());
        }

        public CraftFoodEffect(Map<String, Object> map) {
            PotionEffect effect = SerializableMeta.getObject(PotionEffect.class, map, "effect", false);
            Float probability = SerializableMeta.getObject(Float.class, map, "probability", true);
            if (probability == null) {
                probability = Float.valueOf(1.0f);
            }
            this.handle = new class_4174.class_9423(CraftPotionUtil.fromBukkit(effect), probability.floatValue());
        }

        @Override
        public Map<String, Object> serialize() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("effect", this.getEffect());
            result.put("probability", Float.valueOf(this.getProbability()));
            return result;
        }

        public class_4174.class_9423 getHandle() {
            return this.handle;
        }

        @Override
        public PotionEffect getEffect() {
            return CraftPotionUtil.toBukkit(this.handle.comp_2496());
        }

        @Override
        public void setEffect(PotionEffect effect) {
            this.handle = new class_4174.class_9423(CraftPotionUtil.fromBukkit(effect), this.handle.comp_2497());
        }

        @Override
        public float getProbability() {
            return this.handle.comp_2497();
        }

        @Override
        public void setProbability(float probability) {
            Preconditions.checkArgument((0.0f <= probability && probability <= 1.0f ? 1 : 0) != 0, (Object)"Probability cannot be outside range [0,1]");
            this.handle = new class_4174.class_9423(this.handle.comp_2496(), probability);
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftFoodEffect other = (CraftFoodEffect)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftFoodEffect{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

