/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_266;
import net.minecraft.class_274;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.RenderType;

public final class CraftCriteria
implements Criteria {
    static final Map<String, CraftCriteria> DEFAULTS;
    static final CraftCriteria DUMMY;
    final class_274 criteria;
    final String bukkitName;

    private CraftCriteria(String bukkitName) {
        this.bukkitName = bukkitName;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(class_274 criteria) {
        this.criteria = criteria;
        this.bukkitName = criteria.method_1225();
    }

    @Override
    public String getName() {
        return this.bukkitName;
    }

    @Override
    public boolean isReadOnly() {
        return this.criteria.method_1226();
    }

    @Override
    public RenderType getDefaultRenderType() {
        return RenderType.values()[this.criteria.method_1227().ordinal()];
    }

    static CraftCriteria getFromNMS(class_266 objective) {
        return DEFAULTS.get(objective.method_1116().method_1225());
    }

    public static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        return class_274.method_1224((String)name).map(CraftCriteria::new).orElseGet(() -> new CraftCriteria(name));
    }

    public boolean equals(Object that) {
        if (!(that instanceof CraftCriteria)) {
            return false;
        }
        return ((CraftCriteria)that).bukkitName.equals(this.bukkitName);
    }

    public int hashCode() {
        return this.bukkitName.hashCode() ^ CraftCriteria.class.hashCode();
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (Map.Entry entry : class_274.field_1455.entrySet()) {
            String name = (String)entry.getKey();
            class_274 criteria = (class_274)entry.getValue();
            defaults.put((Object)name, (Object)new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get("dummy");
    }
}

