/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.scoreboard;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_2751;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_5900;
import net.minecraft.class_8646;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R1.util.WeakCollection;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.spigotmc.AsyncCatcher;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, class_269 scoreboardServer) {
        this.mainScoreboard = new CraftScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    @Override
    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    @Override
    public CraftScoreboard getNewScoreboard() {
        AsyncCatcher.catchOp("scoreboard creation");
        CraftScoreboard scoreboard = new CraftScoreboard((class_269)new class_2995(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, Scoreboard bukkitScoreboard) {
        Preconditions.checkArgument((boolean)(bukkitScoreboard instanceof CraftScoreboard), (Object)"Cannot set player scoreboard to an unregistered Scoreboard");
        CraftScoreboard scoreboard = (CraftScoreboard)bukkitScoreboard;
        class_269 oldboard = this.getPlayerBoard(player).getHandle();
        class_269 newboard = scoreboard.getHandle();
        class_3222 entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<class_266> removed = new HashSet<class_266>();
        for (int i = 0; i < 3; ++i) {
            class_266 scoreboardobjective = oldboard.method_1189((class_8646)class_8646.field_45176.apply(i));
            if (scoreboardobjective == null || removed.contains(scoreboardobjective)) continue;
            entityplayer.field_13987.method_14364((class_2596)new class_2751(scoreboardobjective, 1));
            removed.add(scoreboardobjective);
        }
        for (class_268 scoreboardteam : oldboard.method_1159()) {
            entityplayer.field_13987.method_14364((class_2596)class_5900.method_34170((class_268)scoreboardteam));
        }
        this.server.method_3760().method_14588((class_2995)newboard, player.getHandle());
    }

    public void removePlayer(CraftPlayer player) {
        this.playerBoards.remove(player);
    }

    public void forAllObjectives(class_274 criteria, class_9015 holder, Consumer<class_9014> consumer) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            class_269 board = scoreboard.board;
            board.method_1162(criteria, holder, score -> consumer.accept((class_9014)score));
        }
    }
}

