/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.structure;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_5455;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;

public class CraftStructureManager
implements StructureManager {
    private final class_3485 structureManager;
    private final class_5455 registry;

    public CraftStructureManager(class_3485 structureManager, class_5455 registry) {
        this.structureManager = structureManager;
        this.registry = registry;
    }

    @Override
    public Map<NamespacedKey, Structure> getStructures() {
        HashMap cachedStructures = new HashMap();
        for (Map.Entry entry : this.structureManager.field_15513.entrySet()) {
            ((Optional)entry.getValue()).ifPresent(definedStructure -> cachedStructures.put(CraftNamespacedKey.fromMinecraft((class_2960)entry.getKey()), new CraftStructure((class_3499)definedStructure, this.registry)));
        }
        return Collections.unmodifiableMap(cachedStructures);
    }

    @Override
    public Structure getStructure(NamespacedKey structureKey) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        Optional definedStructure = (Optional)this.structureManager.field_15513.get(CraftNamespacedKey.toMinecraft(structureKey));
        if (definedStructure == null) {
            return null;
        }
        return definedStructure.map(s -> new CraftStructure((class_3499)s, this.registry)).orElse(null);
    }

    @Override
    public Structure loadStructure(NamespacedKey structureKey, boolean register) {
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional structure = (Optional)this.structureManager.field_15513.get(minecraftKey);
        structure = structure == null ? Optional.empty() : structure;
        structure = structure.isPresent() ? structure : this.structureManager.method_15092(minecraftKey);
        Optional optional = structure = structure.isPresent() ? structure : this.structureManager.method_15088(minecraftKey);
        if (register) {
            this.structureManager.field_15513.put(minecraftKey, structure);
        }
        return structure.map(s -> new CraftStructure((class_3499)s, this.registry)).orElse(null);
    }

    @Override
    public Structure loadStructure(NamespacedKey structureKey) {
        return this.loadStructure(structureKey, true);
    }

    @Override
    public void saveStructure(NamespacedKey structureKey) {
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        this.structureManager.method_15093(minecraftKey);
    }

    @Override
    public void saveStructure(NamespacedKey structureKey, Structure structure) throws IOException {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structure cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        File structureFile = this.getStructureFile(structureKey);
        Files.createDirectories(structureFile.toPath().getParent(), new FileAttribute[0]);
        this.saveStructure(structureFile, structure);
    }

    @Override
    public Structure registerStructure(NamespacedKey structureKey, Structure structure) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<class_3499> optionalDefinedStructure = Optional.of(((CraftStructure)structure).getHandle());
        Optional<class_3499> previousStructure = this.structureManager.field_15513.put(minecraftKey, optionalDefinedStructure);
        return previousStructure == null ? null : (Structure)previousStructure.map(s -> new CraftStructure((class_3499)s, this.registry)).orElse(null);
    }

    @Override
    public Structure unregisterStructure(NamespacedKey structureKey) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional previousStructure = (Optional)this.structureManager.field_15513.remove(minecraftKey);
        return previousStructure == null ? null : (Structure)previousStructure.map(s -> new CraftStructure((class_3499)s, this.registry)).orElse(null);
    }

    @Override
    public void deleteStructure(NamespacedKey structureKey) throws IOException {
        this.deleteStructure(structureKey, true);
    }

    @Override
    public void deleteStructure(NamespacedKey structureKey, boolean unregister) throws IOException {
        class_2960 key = CraftNamespacedKey.toMinecraft(structureKey);
        if (unregister) {
            this.structureManager.field_15513.remove(key);
        }
        Path path = this.structureManager.method_15085(key, ".nbt");
        Files.deleteIfExists(path);
    }

    @Override
    public File getStructureFile(NamespacedKey structureKey) {
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        return this.structureManager.method_15085(minecraftKey, ".nbt").toFile();
    }

    @Override
    public Structure loadStructure(File file) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        FileInputStream fileinputstream = new FileInputStream(file);
        return this.loadStructure(fileinputstream);
    }

    @Override
    public Structure loadStructure(InputStream inputStream) throws IOException {
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (Object)"inputStream cannot be null");
        return new CraftStructure(this.structureManager.method_15090(inputStream), this.registry);
    }

    @Override
    public void saveStructure(File file, Structure structure) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"structure cannot be null");
        FileOutputStream fileoutputstream = new FileOutputStream(file);
        this.saveStructure(fileoutputstream, structure);
    }

    @Override
    public void saveStructure(OutputStream outputStream, Structure structure) throws IOException {
        Preconditions.checkArgument((outputStream != null ? 1 : 0) != 0, (Object)"outputStream cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"structure cannot be null");
        class_2487 nbttagcompound = ((CraftStructure)structure).getHandle().method_15175(new class_2487());
        class_2507.method_10634((class_2487)nbttagcompound, (OutputStream)outputStream);
    }

    @Override
    public Structure createStructure() {
        return new CraftStructure(new class_3499(), this.registry);
    }

    private class_2960 createAndValidateMinecraftStructureKey(NamespacedKey structureKey) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        class_2960 minecraftkey = CraftNamespacedKey.toMinecraft(structureKey);
        Preconditions.checkArgument((!minecraftkey.method_12832().contains("//") ? 1 : 0) != 0, (Object)"Resource key for Structures can not contain \"//\"");
        return minecraftkey;
    }

    @Override
    public Structure copy(Structure structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        return new CraftStructure(this.structureManager.method_21891(((CraftStructure)structure).getHandle().method_15175(new class_2487())), this.registry);
    }
}

