/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.util;

import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R1.generator.structure.CraftStructure;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.bukkit.util.BlockTransformer;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EntityTransformer;

public class CraftStructureTransformer {
    private CraftLimitedRegion limitedRegion;
    private BlockTransformer[] blockTransformers;
    private EntityTransformer[] entityTransformers;

    public CraftStructureTransformer(AsyncStructureGenerateEvent.Cause cause, class_5281 generatoraccessseed, class_5138 structuremanager, class_3195 structure, class_3341 structureboundingbox, class_1923 chunkcoordintpair) {
        AsyncStructureGenerateEvent event = new AsyncStructureGenerateEvent(structuremanager.field_24404.getMinecraftWorld().getWorld(), !Bukkit.isPrimaryThread(), cause, CraftStructure.minecraftToBukkit(structure), new BoundingBox(structureboundingbox.method_35415(), structureboundingbox.method_35416(), structureboundingbox.method_35417(), structureboundingbox.method_35418(), structureboundingbox.method_35419(), structureboundingbox.method_35420()), chunkcoordintpair.field_9181, chunkcoordintpair.field_9180);
        Bukkit.getPluginManager().callEvent(event);
        this.blockTransformers = (BlockTransformer[])event.getBlockTransformers().values().toArray(BlockTransformer[]::new);
        this.entityTransformers = (EntityTransformer[])event.getEntityTransformers().values().toArray(EntityTransformer[]::new);
        this.limitedRegion = new CraftLimitedRegion(generatoraccessseed, chunkcoordintpair);
    }

    public CraftStructureTransformer(class_5281 generatoraccessseed, class_1923 chunkcoordintpair, Collection<BlockTransformer> blockTransformers, Collection<EntityTransformer> entityTransformers) {
        this.blockTransformers = (BlockTransformer[])blockTransformers.toArray(BlockTransformer[]::new);
        this.entityTransformers = (EntityTransformer[])entityTransformers.toArray(EntityTransformer[]::new);
        this.limitedRegion = new CraftLimitedRegion(generatoraccessseed, chunkcoordintpair);
    }

    public boolean transformEntity(class_1297 entity) {
        EntityTransformer[] transformers = this.entityTransformers;
        if (transformers == null || transformers.length == 0) {
            return true;
        }
        CraftLimitedRegion region = this.limitedRegion;
        if (region == null) {
            return true;
        }
        entity.generation = true;
        CraftEntity craftEntity = entity.getBukkitEntity();
        int x = entity.method_31477();
        int y = entity.method_31478();
        int z = entity.method_31479();
        boolean allowedToSpawn = true;
        for (EntityTransformer transformer : transformers) {
            allowedToSpawn = transformer.transform(region, x, y, z, craftEntity, allowedToSpawn);
        }
        return allowedToSpawn;
    }

    public boolean canTransformBlocks() {
        return this.blockTransformers != null && this.blockTransformers.length != 0 && this.limitedRegion != null;
    }

    public CraftBlockState transformCraftState(CraftBlockState originalState) {
        BlockTransformer[] transformers = this.blockTransformers;
        if (transformers == null || transformers.length == 0) {
            return originalState;
        }
        CraftLimitedRegion region = this.limitedRegion;
        if (region == null) {
            return originalState;
        }
        originalState.setWorldHandle((class_1936)region.getHandle());
        class_2338 position = originalState.getPosition();
        BlockState blockState = originalState.copy();
        CraftTransformationState transformationState = new CraftTransformationState(originalState, region.getBlockState(position.method_10263(), position.method_10264(), position.method_10260()));
        for (BlockTransformer transformer : transformers) {
            blockState = Objects.requireNonNull(transformer.transform(region, position.method_10263(), position.method_10264(), position.method_10260(), blockState, transformationState), "BlockState can't be null");
            transformationState.destroyCopies();
        }
        return blockState;
    }

    public void discard() {
        this.limitedRegion.saveEntities();
        this.limitedRegion.breakLink();
        this.limitedRegion = null;
        this.blockTransformers = null;
        this.entityTransformers = null;
    }

    private static class CraftTransformationState
    implements BlockTransformer.TransformationState {
        private final BlockState original;
        private final BlockState world;
        private BlockState originalCopy;
        private BlockState worldCopy;

        private CraftTransformationState(BlockState original, BlockState world) {
            this.original = original;
            this.world = world;
        }

        @Override
        public BlockState getOriginal() {
            if (this.originalCopy != null) {
                return this.originalCopy;
            }
            this.originalCopy = this.original.copy();
            return this.originalCopy;
        }

        @Override
        public BlockState getWorld() {
            if (this.worldCopy != null) {
                return this.worldCopy;
            }
            this.worldCopy = this.world.copy();
            return this.worldCopy;
        }

        private void destroyCopies() {
            this.originalCopy = null;
            this.worldCopy = null;
        }
    }
}

