/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1421;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1538;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1668;
import net.minecraft.class_1671;
import net.minecraft.class_1682;
import net.minecraft.class_1685;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3763;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static class_238 maxBB = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType initializeEntityActivationType(class_1297 entity) {
        if (entity instanceof class_3763) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof class_1588 || entity instanceof class_1621) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof class_1314 || entity instanceof class_1421) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(class_1297 entity, SpigotWorldConfig config) {
        return entity.activationType == ActivationType.MISC && config.miscActivationRange == 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange == 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange == 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange == 0 || entity instanceof class_1657 || entity instanceof class_1682 || entity instanceof class_1510 || entity instanceof class_1508 || entity instanceof class_1528 || entity instanceof class_1668 || entity instanceof class_1538 || entity instanceof class_1541 || entity instanceof class_1511 || entity instanceof class_1671 || entity instanceof class_1685;
    }

    public static void activateEntities(class_1937 world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (class_1657 player : world.method_18456()) {
            player.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && player.method_7325()) continue;
            maxBB = player.method_5829().method_1009((double)maxRange, 256.0, (double)maxRange);
            ActivationType.MISC.boundingBox = player.method_5829().method_1009((double)miscActivationRange, 256.0, (double)miscActivationRange);
            ActivationType.RAIDER.boundingBox = player.method_5829().method_1009((double)raiderActivationRange, 256.0, (double)raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = player.method_5829().method_1009((double)animalActivationRange, 256.0, (double)animalActivationRange);
            ActivationType.MONSTER.boundingBox = player.method_5829().method_1009((double)monsterActivationRange, 256.0, (double)monsterActivationRange);
            world.method_31592().method_31807(maxBB, ActivationRange::activateEntity);
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateEntity(class_1297 entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.method_994(entity.method_5829())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static boolean checkEntityImmunities(class_1297 entity) {
        if (entity.field_5957 || entity.method_20802() > 0) {
            return true;
        }
        if (!(entity instanceof class_1665) ? !entity.method_24828() || !entity.field_5979.isEmpty() || entity.method_5765() : !((class_1665)entity).field_7588) {
            return true;
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (living.field_6235 > 0 || living.field_6280.size() > 0) {
                return true;
            }
            if (entity instanceof class_1314 && ((class_1314)entity).method_5968() != null) {
                return true;
            }
            if (entity instanceof class_1646 && ((class_1646)entity).method_19184()) {
                return true;
            }
            if (entity instanceof class_1429) {
                class_1429 animal = (class_1429)entity;
                if (animal.method_6109() || animal.method_6479()) {
                    return true;
                }
                if (entity instanceof class_1472 && ((class_1472)entity).method_6629()) {
                    return true;
                }
            }
            if (entity instanceof class_1548 && ((class_1548)entity).method_7000()) {
                return true;
            }
        }
        return entity instanceof class_1303;
    }

    public static boolean checkIfActive(class_1297 entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (entity instanceof class_1671) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.field_6012 % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }

    public static enum ActivationType {
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        public class_238 boundingBox = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

