/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl;

import com.llamalad7.mixinextras.injector.StackExtension;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicationException;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicator;
import com.llamalad7.mixinextras.sugar.impl.SugarParameter;
import com.llamalad7.mixinextras.sugar.impl.SugarPostProcessingExtension;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefUtils;
import com.llamalad7.mixinextras.utils.CompatibilityHelper;
import java.util.HashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

class LocalSugarApplicator
extends SugarApplicator {
    private final boolean isArgsOnly;
    private final Type targetLocalType;
    private final boolean isMutable;

    LocalSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.targetLocalType = LocalRefUtils.getTargetType(this.paramType, this.paramGeneric);
        this.isMutable = this.targetLocalType != this.paramType;
        this.isArgsOnly = (Boolean)Annotations.getValue((AnnotationNode)this.sugar, (String)"argsOnly", (Object)false);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode node) {
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        LocalVariableDiscriminator.Context context = this.getOrCreateLocalContext(target, node);
        if (discriminator.printLVT()) {
            this.printLocals(target, node.getCurrentTarget(), context, discriminator);
            this.info.addCallbackInvocation(this.info.getMethod());
            throw new SugarApplicationException("Application aborted because locals are being printed instead.");
        }
        try {
            if (discriminator.findLocal(context) < 0) {
                throw new SugarApplicationException("Unable to find matching local!");
            }
        }
        catch (InvalidImplicitDiscriminatorException e) {
            throw new SugarApplicationException("Invalid implicit variable discriminator: ", e);
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode node) {
        this.getOrCreateLocalContext(target, node);
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode node, StackExtension stack) {
        LocalVariableDiscriminator.Context context;
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        int index = discriminator.findLocal(context = (LocalVariableDiscriminator.Context)node.getDecoration(this.getLocalContextKey()));
        if (index < 0) {
            throw new SugarApplicationException("Failed to match a local, this should have been caught during validation.");
        }
        if (this.isMutable) {
            this.initAndLoadLocalRef(target, node, index, stack);
        } else {
            stack.extra(this.targetLocalType.getSize());
            target.insns.insertBefore(node.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), index));
        }
    }

    private void initAndLoadLocalRef(Target target, InjectionNodes.InjectionNode node, int index, StackExtension stack) {
        String refName = LocalRefClassGenerator.getForType(this.targetLocalType);
        int refIndex = this.getOrCreateRef(target, node, index, refName, stack);
        stack.extra(1);
        target.insns.insertBefore(node.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, refIndex));
    }

    private int getOrCreateRef(Target target, InjectionNodes.InjectionNode node, int index, String refImpl, StackExtension stack) {
        HashMap<Integer, Integer> refIndices = (HashMap<Integer, Integer>)node.getDecoration("mixinextras_localRefMap");
        if (refIndices == null) {
            refIndices = new HashMap<Integer, Integer>();
            node.decorate("mixinextras_localRefMap", refIndices);
        }
        if (refIndices.containsKey(index)) {
            return (Integer)refIndices.get(index);
        }
        int refIndex = target.allocateLocal();
        target.addLocalVariable(refIndex, "ref" + refIndex, 'L' + refImpl + ';');
        InsnList construction = new InsnList();
        LocalRefUtils.generateNew(construction, this.targetLocalType);
        construction.add((AbstractInsnNode)new VarInsnNode(58, refIndex));
        target.insertBefore(node, construction);
        SugarPostProcessingExtension.enqueuePostProcessing(this, () -> {
            InsnList initialization = new InsnList();
            initialization.add((AbstractInsnNode)new VarInsnNode(25, refIndex));
            initialization.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), index));
            LocalRefUtils.generateInitialization(initialization, this.targetLocalType);
            target.insertBefore(node, initialization);
            stack.extra(this.targetLocalType.getSize() + 1);
            InsnList after = new InsnList();
            after.add((AbstractInsnNode)new VarInsnNode(25, refIndex));
            LocalRefUtils.generateDisposal(after, this.targetLocalType);
            after.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(54), index));
            target.insns.insert(node.getCurrentTarget(), after);
        });
        refIndices.put(index, refIndex);
        return refIndex;
    }

    private LocalVariableDiscriminator.Context getOrCreateLocalContext(Target target, InjectionNodes.InjectionNode node) {
        String decorationKey = this.getLocalContextKey();
        if (node.hasDecoration(decorationKey)) {
            return (LocalVariableDiscriminator.Context)node.getDecoration(decorationKey);
        }
        LocalVariableDiscriminator.Context context = CompatibilityHelper.makeLvtContext(this.info, this.targetLocalType, this.isArgsOnly, target, node.getCurrentTarget());
        node.decorate(decorationKey, (Object)context);
        return context;
    }

    private String getLocalContextKey() {
        return String.format("mixinextras_persistent_localSugarContext(%s,%s)", this.targetLocalType, this.isArgsOnly ? "argsOnly" : "fullFrame");
    }

    private void printLocals(Target target, AbstractInsnNode node, LocalVariableDiscriminator.Context context, LocalVariableDiscriminator discriminator) {
        int baseArgIndex = target.isStatic ? 0 : 1;
        new PrettyPrinter().kvWidth(20).kv("Target Class", (Object)target.classNode.name.replace('/', '.')).kv("Target Method", (Object)target.method.name).kv("Capture Type", (Object)SignaturePrinter.getTypeName((Type)this.targetLocalType, (boolean)false)).kv("Instruction", "[%d] %s %s", new Object[]{target.insns.indexOf(node), node.getClass().getSimpleName(), Bytecode.getOpcodeName((int)node.getOpcode())}).hr().kv("Match mode", (Object)(this.isImplicit(discriminator, baseArgIndex) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)")).kv("Match ordinal", discriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(discriminator.getOrdinal())).kv("Match index", discriminator.getIndex() < baseArgIndex ? "any" : Integer.valueOf(discriminator.getIndex())).kv("Match name(s)", discriminator.hasNames() ? discriminator.getNames() : "any").kv("Args only", (Object)this.isArgsOnly).hr().add((PrettyPrinter.IPrettyPrintable)context).print(System.err);
    }

    private boolean isImplicit(LocalVariableDiscriminator discriminator, int baseArgIndex) {
        return discriminator.getOrdinal() < 0 && discriminator.getIndex() < baseArgIndex && discriminator.getNames().isEmpty();
    }
}

