/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mapping.util;

import net.fabricmc.mapping.util.ClassMapper;

public final class EntryTriple {
    private final String owner;
    private final String name;
    private final String descriptor;

    public EntryTriple(String owner, String name, String descriptor) {
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public EntryTriple map(ClassMapper mapper, String newName) {
        return new EntryTriple(mapper.mapClass(this.owner), newName, mapper.mapDescriptor(this.descriptor));
    }

    public String toString() {
        return "EntryTriple{owner=" + this.owner + ",name=" + this.name + ",desc=" + this.descriptor + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof EntryTriple)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EntryTriple other = (EntryTriple)o;
        return other.owner.equals(this.owner) && other.name.equals(this.name) && other.descriptor.equals(this.descriptor);
    }

    public int hashCode() {
        return this.owner.hashCode() * 37 + this.name.hashCode() * 19 + this.descriptor.hashCode();
    }
}

