/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.coremod.transformer;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Set;
import java.util.function.Function;
import net.minecraftforge.coremod.CoreMod;
import net.minecraftforge.coremod.CoreModTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public abstract class CoreModBaseTransformer<T>
implements ITransformer<T> {
    static final Logger LOGGER = LogManager.getLogger();
    static final Marker COREMOD = MarkerManager.getMarker((String)"COREMOD");
    final CoreMod coreMod;
    final Set<ITransformer.Target> targets;
    final Function<T, T> function;
    final String coreName;

    public CoreModBaseTransformer(CoreMod coreMod, String coreName, Set<ITransformer.Target> targets, Function<T, T> function) {
        this.coreMod = coreMod;
        this.coreName = coreName;
        this.targets = targets;
        this.function = function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T transform(T input, ITransformerVotingContext context) {
        CoreModTracker.setCoreMod(this.coreMod);
        T result = input;
        try {
            result = this.runCoremod(result);
        }
        catch (Exception e) {
            LOGGER.error(COREMOD, "Error occurred applying transform of coremod {} function {}", (Object)this.coreMod.getPath(), (Object)this.coreName, (Object)e);
        }
        finally {
            CoreModTracker.clearCoreMod();
        }
        return result;
    }

    abstract T runCoremod(T var1);

    @NotNull
    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @NotNull
    public Set<ITransformer.Target> targets() {
        return this.targets;
    }

    public String[] labels() {
        return new String[]{this.coreMod.getFile().getOwnerId(), this.coreName};
    }
}

