/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.NoopTransition;
import net.minecraftforge.fml.ThreadSelector;

public interface IModStateTransition {
    public static IModStateTransition buildNoopTransition() {
        return new NoopTransition();
    }

    default public <T extends Event> CompletableFuture<Void> build(Executor syncExecutor, Executor parallelExecutor, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        ArrayList futures = new ArrayList();
        this.eventFunctionStream().get().map(f -> f).reduce((head, tail) -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, futures, (EventGenerator)head, ModLoadingStage::currentState, (EventGenerator)tail)).ifPresent(last -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, futures, (EventGenerator)last, this.nextModLoadingStage(), null));
        CompletableFuture<Void> preSyncTaskCF = preSyncTask.apply(syncExecutor);
        CompletionStage eventDispatchCF = ModList.gather(futures).thenCompose(ModList::completableFutureFromExceptionList);
        CompletionStage postEventDispatchCF = ((CompletableFuture)preSyncTaskCF.thenComposeAsync(arg_0 -> IModStateTransition.lambda$build$3((CompletableFuture)eventDispatchCF, arg_0), parallelExecutor)).thenApply(r -> {
            postSyncTask.apply(syncExecutor);
            return null;
        });
        return this.finalActivityGenerator().apply(syncExecutor, (CompletableFuture<Void>)postEventDispatchCF);
    }

    default public BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextModLoadingStage() {
        return ModLoadingStage::nextState;
    }

    private <T extends Event> EventGenerator<T> addCompletableFutureTaskForModDispatch(Executor syncExecutor, Executor parallelExecutor, List<CompletableFuture<Void>> completableFutures, EventGenerator<T> eventGenerator, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextState, EventGenerator<T> nextGenerator) {
        Executor selectedExecutor = this.threadSelector().apply(syncExecutor, parallelExecutor);
        BiFunction<Executor, EventGenerator<?>, CompletableFuture<Void>> preDispatchHook = this.preDispatchHook();
        completableFutures.add(preDispatchHook.apply(selectedExecutor, eventGenerator));
        completableFutures.add(ModList.get().futureVisitor(eventGenerator, nextState).apply(this.threadSelector().apply(syncExecutor, parallelExecutor)));
        BiFunction<Executor, EventGenerator<?>, CompletableFuture<Void>> postDispatchHook = this.postDispatchHook();
        completableFutures.add(postDispatchHook.apply(selectedExecutor, eventGenerator));
        return nextGenerator;
    }

    public Supplier<Stream<EventGenerator<?>>> eventFunctionStream();

    public ThreadSelector threadSelector();

    public BiFunction<Executor, CompletableFuture<Void>, CompletableFuture<Void>> finalActivityGenerator();

    public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<Void>> preDispatchHook();

    public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<Void>> postDispatchHook();

    private static /* synthetic */ CompletionStage lambda$build$3(CompletableFuture eventDispatchCF, Void n) {
        return eventDispatchCF;
    }

    public static interface EventGenerator<T extends Event>
    extends Function<ModContainer, T> {
        public static <FN extends Event> EventGenerator<FN> fromFunction(Function<ModContainer, FN> fn) {
            return fn::apply;
        }
    }
}

