/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.TabOrderedElement;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.ScreenNarrationCollector;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Matrix4f;
import org.joml.Vector2ic;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class Screen
extends AbstractContainerEventHandler
implements Renderable {
    private static final Logger f_96536_ = LogUtils.getLogger();
    private static final Set<String> f_96537_ = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private static final int f_169366_ = 2;
    private static final Component f_169367_ = Component.m_237115_((String)"narrator.screen.usage");
    protected final Component f_96539_;
    private final List<GuiEventListener> f_96540_ = Lists.newArrayList();
    private final List<NarratableEntry> f_169368_ = Lists.newArrayList();
    @Nullable
    protected Minecraft f_96541_;
    private boolean f_267454_;
    protected ItemRenderer f_96542_;
    public int f_96543_;
    public int f_96544_;
    public final List<Renderable> f_169369_ = Lists.newArrayList();
    public boolean f_96546_;
    protected Font f_96547_;
    @Nullable
    private URI f_96538_;
    private static final long f_169370_;
    private static final long f_169371_;
    private static final long f_169372_ = 750L;
    private static final long f_169373_ = 200L;
    private static final long f_169374_ = 200L;
    private final ScreenNarrationCollector f_169375_ = new ScreenNarrationCollector();
    private long f_169376_ = Long.MIN_VALUE;
    private long f_169377_ = Long.MAX_VALUE;
    @Nullable
    private NarratableEntry f_169365_;
    @Nullable
    private DeferredTooltipRendering f_262730_;
    private Font tooltipFont = null;
    private ItemStack tooltipStack = ItemStack.f_41583_;

    protected Screen(Component p_96550_) {
        this.f_96539_ = p_96550_;
    }

    public Component m_96636_() {
        return this.f_96539_;
    }

    public Component m_142562_() {
        return this.m_96636_();
    }

    public final void m_257612_(PoseStack p_259694_, int p_260150_, int p_259877_, float p_259252_) {
        this.m_86412_(p_259694_, p_260150_, p_259877_, p_259252_);
        if (this.f_262730_ != null) {
            this.m_262835_(p_259694_, this.f_262730_, p_260150_, p_259877_);
            this.f_262730_ = null;
        }
    }

    public void m_86412_(PoseStack p_96562_, int p_96563_, int p_96564_, float p_96565_) {
        for (Renderable renderable : this.f_169369_) {
            renderable.m_86412_(p_96562_, p_96563_, p_96564_, p_96565_);
        }
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        if (p_96552_ == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (super.m_7933_(p_96552_, p_96553_, p_96554_)) {
            return true;
        }
        FocusNavigationEvent focusnavigationevent = (FocusNavigationEvent)(switch (p_96552_) {
            case 258 -> this.m_264442_();
            default -> null;
            case 262 -> this.m_264409_(ScreenDirection.RIGHT);
            case 263 -> this.m_264409_(ScreenDirection.LEFT);
            case 264 -> this.m_264409_(ScreenDirection.DOWN);
            case 265 -> this.m_264409_(ScreenDirection.UP);
        });
        if (focusnavigationevent != null) {
            ComponentPath componentpath = super.m_264064_(focusnavigationevent);
            if (componentpath == null && focusnavigationevent instanceof FocusNavigationEvent.TabNavigation) {
                this.m_264131_();
                componentpath = super.m_264064_(focusnavigationevent);
            }
            if (componentpath != null) {
                this.m_264158_(componentpath);
            }
        }
        return false;
    }

    private FocusNavigationEvent.TabNavigation m_264442_() {
        boolean flag = !Screen.m_96638_();
        return new FocusNavigationEvent.TabNavigation(flag);
    }

    private FocusNavigationEvent.ArrowNavigation m_264409_(ScreenDirection p_265049_) {
        return new FocusNavigationEvent.ArrowNavigation(p_265049_);
    }

    protected void m_264313_(GuiEventListener p_265756_) {
        ComponentPath componentpath = ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)p_265756_.m_264064_((FocusNavigationEvent)new FocusNavigationEvent.InitialFocus()));
        if (componentpath != null) {
            this.m_264158_(componentpath);
        }
    }

    private void m_264131_() {
        ComponentPath componentpath = this.m_264435_();
        if (componentpath != null) {
            componentpath.m_264432_(false);
        }
    }

    @VisibleForTesting
    protected void m_264158_(ComponentPath p_265308_) {
        this.m_264131_();
        p_265308_.m_264432_(true);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.f_96541_.popGuiLayer();
    }

    protected <T extends GuiEventListener & Renderable> T m_142416_(T p_169406_) {
        this.f_169369_.add(p_169406_);
        return this.m_7787_(p_169406_);
    }

    protected <T extends Renderable> T m_169394_(T p_254514_) {
        this.f_169369_.add(p_254514_);
        return p_254514_;
    }

    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T p_96625_) {
        this.f_96540_.add(p_96625_);
        this.f_169368_.add(p_96625_);
        return p_96625_;
    }

    protected void m_169411_(GuiEventListener p_169412_) {
        if (p_169412_ instanceof Renderable) {
            this.f_169369_.remove((Renderable)p_169412_);
        }
        if (p_169412_ instanceof NarratableEntry) {
            this.f_169368_.remove((NarratableEntry)p_169412_);
        }
        this.f_96540_.remove(p_169412_);
    }

    protected void m_169413_() {
        this.f_169369_.clear();
        this.f_96540_.clear();
        this.f_169368_.clear();
    }

    protected void m_6057_(PoseStack p_96566_, ItemStack p_96567_, int p_96568_, int p_96569_) {
        this.tooltipStack = p_96567_;
        this.m_169388_(p_96566_, this.m_96555_(p_96567_), p_96567_.m_150921_(), p_96568_, p_96569_);
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void renderTooltip(PoseStack poseStack, List<Component> textComponents, Optional<TooltipComponent> tooltipComponent, int x, int y, ItemStack stack) {
        this.renderTooltip(poseStack, textComponents, tooltipComponent, x, y, null, stack);
    }

    public void renderTooltip(PoseStack poseStack, List<Component> textComponents, Optional<TooltipComponent> tooltipComponent, int x, int y, @Nullable Font font) {
        this.renderTooltip(poseStack, textComponents, tooltipComponent, x, y, font, ItemStack.f_41583_);
    }

    public void renderTooltip(PoseStack poseStack, List<Component> textComponents, Optional<TooltipComponent> tooltipComponent, int x, int y, @Nullable Font font, ItemStack stack) {
        this.tooltipFont = font;
        this.tooltipStack = stack;
        this.m_169388_(poseStack, textComponents, tooltipComponent, x, y);
        this.tooltipFont = null;
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void m_169388_(PoseStack p_169389_, List<Component> p_169390_, Optional<TooltipComponent> p_169391_, int p_169392_, int p_169393_) {
        List list = ForgeHooksClient.gatherTooltipComponents((ItemStack)this.tooltipStack, p_169390_, p_169391_, (int)p_169392_, (int)this.f_96543_, (int)this.f_96544_, (Font)this.tooltipFont, (Font)this.f_96547_);
        this.m_262809_(p_169389_, list, p_169392_, p_169393_, DefaultTooltipPositioner.f_262752_);
    }

    public List<Component> m_96555_(ItemStack p_96556_) {
        return p_96556_.m_41651_(this.f_96541_.f_91074_, (TooltipFlag)(this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }

    public void m_96602_(PoseStack p_96603_, Component p_96604_, int p_96605_, int p_96606_) {
        this.m_96617_(p_96603_, Arrays.asList(p_96604_.m_7532_()), p_96605_, p_96606_);
    }

    public void m_96597_(PoseStack p_96598_, List<Component> p_96599_, int p_96600_, int p_96601_) {
        List components = ForgeHooksClient.gatherTooltipComponents((ItemStack)this.tooltipStack, p_96599_, (int)p_96600_, (int)this.f_96543_, (int)this.f_96544_, (Font)this.tooltipFont, (Font)this.f_96547_);
        this.m_262809_(p_96598_, components, p_96600_, p_96601_, DefaultTooltipPositioner.f_262752_);
    }

    public void renderComponentTooltip(PoseStack poseStack, List<? extends FormattedText> tooltips, int mouseX, int mouseY, ItemStack stack) {
        this.renderComponentTooltip(poseStack, tooltips, mouseX, mouseY, null, stack);
    }

    public void renderComponentTooltip(PoseStack poseStack, List<? extends FormattedText> tooltips, int mouseX, int mouseY, @Nullable Font font) {
        this.renderComponentTooltip(poseStack, tooltips, mouseX, mouseY, font, ItemStack.f_41583_);
    }

    public void renderComponentTooltip(PoseStack poseStack, List<? extends FormattedText> tooltips, int mouseX, int mouseY, @Nullable Font font, ItemStack stack) {
        this.tooltipFont = font;
        this.tooltipStack = stack;
        List components = ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, tooltips, (int)mouseX, (int)this.f_96543_, (int)this.f_96544_, (Font)this.tooltipFont, (Font)this.f_96547_);
        this.m_262809_(poseStack, components, mouseX, mouseY, DefaultTooltipPositioner.f_262752_);
        this.tooltipFont = null;
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void m_96617_(PoseStack p_96618_, List<? extends FormattedCharSequence> p_96619_, int p_96620_, int p_96621_) {
        this.m_262809_(p_96618_, p_96619_.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), p_96620_, p_96621_, DefaultTooltipPositioner.f_262752_);
    }

    public void renderTooltip(PoseStack poseStack, List<? extends FormattedCharSequence> lines, int x, int y, Font font) {
        this.tooltipFont = font;
        this.m_96617_(poseStack, lines, x, y);
        this.tooltipFont = null;
    }

    private void m_262835_(PoseStack p_263080_, DeferredTooltipRendering p_262968_, int p_263034_, int p_263076_) {
        this.m_262809_(p_263080_, p_262968_.f_262736_().stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), p_263034_, p_263076_, p_262968_.f_262758_());
    }

    private void m_262809_(PoseStack p_263064_, List<ClientTooltipComponent> p_262990_, int p_263065_, int p_262996_, ClientTooltipPositioner p_262920_) {
        if (!p_262990_.isEmpty()) {
            RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)this.tooltipStack, (PoseStack)p_263064_, (int)p_263065_, (int)p_262996_, (int)this.f_96543_, (int)this.f_96544_, p_262990_, (Font)this.tooltipFont, (Font)this.f_96547_);
            if (preEvent.isCanceled()) {
                return;
            }
            int i = 0;
            int j = p_262990_.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : p_262990_) {
                int k = clienttooltipcomponent.m_142069_(preEvent.getFont());
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.m_142103_();
            }
            Vector2ic vector2ic = p_262920_.m_262814_(this, preEvent.getX(), preEvent.getY(), i, j);
            int l = vector2ic.x();
            int i1 = vector2ic.y();
            p_263064_.m_85836_();
            int j1 = 400;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = p_263064_.m_85850_().m_252922_();
            RenderTooltipEvent.Color colorEvent = ForgeHooksClient.onRenderTooltipColor((ItemStack)this.tooltipStack, (PoseStack)p_263064_, (int)l, (int)i1, (Font)preEvent.getFont(), p_262990_);
            TooltipRenderUtil.renderTooltipBackground((p_262872_, p_262873_, p_262874_, p_262875_, p_262876_, p_262877_, p_262878_, p_262879_, p_262880_) -> GuiComponent.m_93123_((Matrix4f)p_262872_, (BufferBuilder)p_262873_, (int)p_262874_, (int)p_262875_, (int)p_262876_, (int)p_262877_, (int)p_262878_, (int)p_262879_, (int)p_262880_), matrix4f, bufferbuilder, l, i1, i, j, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), colorEvent.getBorderStart(), colorEvent.getBorderEnd());
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            p_263064_.m_252880_(0.0f, 0.0f, 400.0f);
            int k1 = i1;
            for (int l1 = 0; l1 < p_262990_.size(); ++l1) {
                ClientTooltipComponent clienttooltipcomponent1 = p_262990_.get(l1);
                clienttooltipcomponent1.m_142440_(preEvent.getFont(), l, k1, matrix4f, multibuffersource$buffersource);
                k1 += clienttooltipcomponent1.m_142103_() + (l1 == 0 ? 2 : 0);
            }
            multibuffersource$buffersource.m_109911_();
            k1 = i1;
            for (int i2 = 0; i2 < p_262990_.size(); ++i2) {
                ClientTooltipComponent clienttooltipcomponent2 = p_262990_.get(i2);
                clienttooltipcomponent2.m_183452_(preEvent.getFont(), l, k1, p_263064_, this.f_96542_);
                k1 += clienttooltipcomponent2.m_142103_() + (i2 == 0 ? 2 : 0);
            }
            p_263064_.m_85849_();
        }
    }

    protected void m_96570_(PoseStack p_96571_, @Nullable Style p_96572_, int p_96573_, int p_96574_) {
        if (p_96572_ != null && p_96572_.m_131186_() != null) {
            HoverEvent hoverevent = p_96572_.m_131186_();
            HoverEvent.ItemStackInfo hoverevent$itemstackinfo = (HoverEvent.ItemStackInfo)hoverevent.m_130823_(HoverEvent.Action.f_130832_);
            if (hoverevent$itemstackinfo != null) {
                this.m_6057_(p_96571_, hoverevent$itemstackinfo.m_130898_(), p_96573_, p_96574_);
            } else {
                HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo = (HoverEvent.EntityTooltipInfo)hoverevent.m_130823_(HoverEvent.Action.f_130833_);
                if (hoverevent$entitytooltipinfo != null) {
                    if (this.f_96541_.f_91066_.f_92125_) {
                        this.m_96597_(p_96571_, hoverevent$entitytooltipinfo.m_130884_(), p_96573_, p_96574_);
                    }
                } else {
                    Component component = (Component)hoverevent.m_130823_(HoverEvent.Action.f_130831_);
                    if (component != null) {
                        this.m_96617_(p_96571_, this.f_96541_.f_91062_.m_92923_((FormattedText)component, Math.max(this.f_96543_ / 2, 200)), p_96573_, p_96574_);
                    }
                }
            }
        }
    }

    protected void m_6697_(String p_96587_, boolean p_96588_) {
    }

    public boolean m_5561_(@Nullable Style p_96592_) {
        if (p_96592_ == null) {
            return false;
        }
        ClickEvent clickevent = p_96592_.m_131182_();
        if (Screen.m_96638_()) {
            if (p_96592_.m_131189_() != null) {
                this.m_6697_(p_96592_.m_131189_(), false);
            }
        } else if (clickevent != null) {
            block24: {
                if (clickevent.m_130622_() == ClickEvent.Action.OPEN_URL) {
                    if (!((Boolean)this.f_96541_.f_91066_.m_231815_().m_231551_()).booleanValue()) {
                        return false;
                    }
                    try {
                        URI uri = new URI(clickevent.m_130623_());
                        String s = uri.getScheme();
                        if (s == null) {
                            throw new URISyntaxException(clickevent.m_130623_(), "Missing protocol");
                        }
                        if (!f_96537_.contains(s.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(clickevent.m_130623_(), "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
                        }
                        if (((Boolean)this.f_96541_.f_91066_.m_231816_().m_231551_()).booleanValue()) {
                            this.f_96538_ = uri;
                            this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(this::m_96622_, clickevent.m_130623_(), false));
                            break block24;
                        }
                        this.m_96589_(uri);
                    }
                    catch (URISyntaxException urisyntaxexception) {
                        f_96536_.error("Can't open url for {}", (Object)clickevent, (Object)urisyntaxexception);
                    }
                } else if (clickevent.m_130622_() == ClickEvent.Action.OPEN_FILE) {
                    URI uri1 = new File(clickevent.m_130623_()).toURI();
                    this.m_96589_(uri1);
                } else if (clickevent.m_130622_() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.m_6697_(SharedConstants.m_136190_(clickevent.m_130623_()), true);
                } else if (clickevent.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
                    String s1 = SharedConstants.m_136190_(clickevent.m_130623_());
                    if (s1.startsWith("/")) {
                        if (!this.f_96541_.f_91074_.f_108617_.m_246979_(s1.substring(1))) {
                            f_96536_.error("Not allowed to run command with signed argument from click event: '{}'", (Object)s1);
                        }
                    } else {
                        f_96536_.error("Failed to run command without '/' prefix from click event: '{}'", (Object)s1);
                    }
                } else if (clickevent.m_130622_() == ClickEvent.Action.COPY_TO_CLIPBOARD) {
                    this.f_96541_.f_91068_.m_90911_(clickevent.m_130623_());
                } else {
                    f_96536_.error("Don't know how to handle {}", (Object)clickevent);
                }
            }
            return true;
        }
        return false;
    }

    public final void m_6575_(Minecraft p_96607_, int p_96608_, int p_96609_) {
        this.f_96541_ = p_96607_;
        this.f_96542_ = p_96607_.m_91291_();
        this.f_96547_ = p_96607_.f_91062_;
        this.f_96543_ = p_96608_;
        this.f_96544_ = p_96609_;
        if (!this.f_267454_) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.Init.Pre(this, this.f_96540_, this::addEventWidget, this::m_169411_))) {
                this.m_7856_();
            }
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.Init.Post(this, this.f_96540_, this::addEventWidget, this::m_169411_));
        } else {
            this.m_267719_();
        }
        this.f_267454_ = true;
        this.m_169407_(false);
        this.m_169378_(f_169370_);
    }

    protected void m_232761_() {
        this.m_169413_();
        this.m_264131_();
        if (!MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.Init.Pre(this, this.f_96540_, this::addEventWidget, this::m_169411_))) {
            this.m_7856_();
        }
        MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.Init.Post(this, this.f_96540_, this::addEventWidget, this::m_169411_));
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.f_96540_;
    }

    protected void m_7856_() {
    }

    public void m_86600_() {
    }

    public void m_7861_() {
    }

    public void m_274333_() {
    }

    public void m_7333_(PoseStack p_96557_) {
        if (this.f_96541_.f_91073_ != null) {
            Screen.m_93179_((PoseStack)p_96557_, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-1072689136, (int)-804253680);
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered(this, p_96557_));
        } else {
            this.m_264065_(p_96557_);
        }
    }

    public void m_264065_(PoseStack p_265092_) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        int i = 32;
        Screen.m_93143_((PoseStack)p_265092_, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)this.f_96544_, (int)32, (int)32);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered(this, p_265092_));
    }

    public boolean m_7043_() {
        return true;
    }

    private void m_96622_(boolean p_96623_) {
        if (p_96623_) {
            this.m_96589_(this.f_96538_);
        }
        this.f_96538_ = null;
        this.f_96541_.m_91152_(this);
    }

    private void m_96589_(URI p_96590_) {
        Util.m_137581_().m_137648_(p_96590_);
    }

    public static boolean m_96637_() {
        if (Minecraft.f_91002_) {
            return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)343) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)347);
        }
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)345);
    }

    public static boolean m_96638_() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
    }

    public static boolean m_96639_() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)342) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)346);
    }

    public static boolean m_96628_(int p_96629_) {
        return p_96629_ == 88 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean m_96630_(int p_96631_) {
        return p_96631_ == 86 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean m_96632_(int p_96633_) {
        return p_96633_ == 67 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean m_96634_(int p_96635_) {
        return p_96635_ == 65 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    protected void m_267719_() {
        this.m_232761_();
    }

    public void m_6574_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        this.f_96543_ = p_96576_;
        this.f_96544_ = p_96577_;
        this.m_267719_();
    }

    public static void m_96579_(Runnable p_96580_, String p_96581_, String p_96582_) {
        try {
            p_96580_.run();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, p_96581_);
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Affected screen");
            crashreportcategory.m_128165_("Screen name", (CrashReportDetail<String>)((CrashReportDetail)() -> p_96582_));
            throw new ReportedException(crashreport);
        }
    }

    protected boolean m_96583_(String p_96584_, char p_96585_, int p_96586_) {
        int i = p_96584_.indexOf(58);
        int j = p_96584_.indexOf(47);
        if (p_96585_ == ':') {
            return (j == -1 || p_96586_ <= j) && i == -1;
        }
        if (p_96585_ == '/') {
            return p_96586_ > i;
        }
        return p_96585_ == '_' || p_96585_ == '-' || p_96585_ >= 'a' && p_96585_ <= 'z' || p_96585_ >= '0' && p_96585_ <= '9' || p_96585_ == '.';
    }

    public boolean m_5953_(double p_96595_, double p_96596_) {
        return true;
    }

    public void m_7400_(List<Path> p_96591_) {
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    private void m_169380_(long p_169381_, boolean p_169382_) {
        this.f_169377_ = Util.m_137550_() + p_169381_;
        if (p_169382_) {
            this.f_169376_ = Long.MIN_VALUE;
        }
    }

    private void m_169378_(long p_169379_) {
        this.f_169376_ = Util.m_137550_() + p_169379_;
    }

    public void m_169414_() {
        this.m_169380_(750L, false);
    }

    public void m_169415_() {
        this.m_169380_(200L, true);
    }

    public void m_169416_() {
        this.m_169380_(200L, true);
    }

    private boolean m_169419_() {
        return this.f_96541_.m_240477_().m_93316_();
    }

    public void m_169417_() {
        long i;
        if (this.m_169419_() && (i = Util.m_137550_()) > this.f_169377_ && i > this.f_169376_) {
            this.m_169409_(true);
            this.f_169377_ = Long.MAX_VALUE;
        }
    }

    public void m_169407_(boolean p_169408_) {
        if (this.m_169419_()) {
            this.m_169409_(p_169408_);
        }
    }

    private void m_169409_(boolean p_169410_) {
        this.f_169375_.m_169186_(this::m_142228_);
        String s = this.f_169375_.m_169188_(!p_169410_);
        if (!s.isEmpty()) {
            this.f_96541_.m_240477_().m_93319_(s);
        }
    }

    protected boolean m_264396_() {
        return true;
    }

    protected void m_142228_(NarrationElementOutput p_169396_) {
        p_169396_.m_169146_(NarratedElementType.TITLE, this.m_142562_());
        if (this.m_264396_()) {
            p_169396_.m_169146_(NarratedElementType.USAGE, f_169367_);
        }
        this.m_142227_(p_169396_);
    }

    protected void m_142227_(NarrationElementOutput p_169403_) {
        List list = this.f_169368_.stream().filter(NarratableEntry::m_142518_).collect(Collectors.toList());
        Collections.sort(list, Comparator.comparingInt(TabOrderedElement::m_267579_));
        NarratableSearchResult screen$narratablesearchresult = Screen.m_169400_(list, this.f_169365_);
        if (screen$narratablesearchresult != null) {
            if (screen$narratablesearchresult.f_169422_.m_169123_()) {
                this.f_169365_ = screen$narratablesearchresult.f_169420_;
            }
            if (list.size() > 1) {
                p_169403_.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.screen", (Object[])new Object[]{screen$narratablesearchresult.f_169421_ + 1, list.size()}));
                if (screen$narratablesearchresult.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                    p_169403_.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
                }
            }
            screen$narratablesearchresult.f_169420_.m_142291_(p_169403_.m_142047_());
        }
    }

    @Nullable
    public static NarratableSearchResult m_169400_(List<? extends NarratableEntry> p_169401_, @Nullable NarratableEntry p_169402_) {
        NarratableSearchResult screen$narratablesearchresult = null;
        NarratableSearchResult screen$narratablesearchresult1 = null;
        int j = p_169401_.size();
        for (int i = 0; i < j; ++i) {
            NarratableEntry narratableentry = p_169401_.get(i);
            NarratableEntry.NarrationPriority narratableentry$narrationpriority = narratableentry.m_142684_();
            if (narratableentry$narrationpriority.m_169123_()) {
                if (narratableentry != p_169402_) {
                    return new NarratableSearchResult(narratableentry, i, narratableentry$narrationpriority);
                }
                screen$narratablesearchresult1 = new NarratableSearchResult(narratableentry, i, narratableentry$narrationpriority);
                continue;
            }
            if (narratableentry$narrationpriority.compareTo((Enum)(screen$narratablesearchresult != null ? screen$narratablesearchresult.f_169422_ : NarratableEntry.NarrationPriority.NONE)) <= 0) continue;
            screen$narratablesearchresult = new NarratableSearchResult(narratableentry, i, narratableentry$narrationpriority);
        }
        return screen$narratablesearchresult != null ? screen$narratablesearchresult : screen$narratablesearchresult1;
    }

    public void m_169418_() {
        this.m_169380_(f_169371_, false);
    }

    public void m_257959_(List<FormattedCharSequence> p_259937_) {
        this.m_262861_(p_259937_, DefaultTooltipPositioner.f_262752_, true);
    }

    public void m_262861_(List<FormattedCharSequence> p_262939_, ClientTooltipPositioner p_263078_, boolean p_263107_) {
        if (this.f_262730_ == null || p_263107_) {
            this.f_262730_ = new DeferredTooltipRendering(p_262939_, p_263078_);
        }
    }

    protected void m_257404_(Component p_259986_) {
        this.m_257959_(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)p_259986_));
    }

    public void m_262791_(Tooltip p_262992_, ClientTooltipPositioner p_262980_, boolean p_262988_) {
        this.m_262861_(p_262992_.m_257408_(this.f_96541_), p_262980_, p_262988_);
    }

    protected static void m_202376_(AbstractWidget ... p_202377_) {
        for (AbstractWidget abstractwidget : p_202377_) {
            abstractwidget.f_93624_ = false;
        }
    }

    public ScreenRectangle m_264198_() {
        return new ScreenRectangle(0, 0, this.f_96543_, this.f_96544_);
    }

    private void addEventWidget(GuiEventListener b) {
        if (b instanceof Renderable) {
            Renderable r = (Renderable)b;
            this.f_169369_.add(r);
        }
        if (b instanceof NarratableEntry) {
            NarratableEntry ne = (NarratableEntry)b;
            this.f_169368_.add(ne);
        }
        this.f_96540_.add(b);
    }

    static {
        f_169371_ = f_169370_ = TimeUnit.SECONDS.toMillis(2L);
    }

    @OnlyIn(value=Dist.CLIENT)
    record DeferredTooltipRendering(List<FormattedCharSequence> f_262736_, ClientTooltipPositioner f_262758_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DeferredTooltipRendering.class, "tooltip;positioner", "f_262736_", "f_262758_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DeferredTooltipRendering.class, "tooltip;positioner", "f_262736_", "f_262758_"}, this);
        }

        @Override
        public final boolean equals(Object p_263099_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DeferredTooltipRendering.class, "tooltip;positioner", "f_262736_", "f_262758_"}, this, p_263099_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NarratableSearchResult {
        public final NarratableEntry f_169420_;
        public final int f_169421_;
        public final NarratableEntry.NarrationPriority f_169422_;

        public NarratableSearchResult(NarratableEntry p_169424_, int p_169425_, NarratableEntry.NarrationPriority p_169426_) {
            this.f_169420_ = p_169424_;
            this.f_169421_ = p_169425_;
            this.f_169422_ = p_169426_;
        }
    }
}

