/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ConditionalAdvancement {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final ResourceLocation DOESNT_MATTER = ResourceLocation.fromNamespaceAndPath((String)"doesnt", (String)"matter");
        private List<Adv> advancements = new ArrayList<Adv>();
        private ICondition condition;

        public Builder condition(ICondition value) {
            this.condition = value;
            return this;
        }

        public Builder advancement(Consumer<Consumer<Advancement.Builder>> callable) {
            callable.accept(this::advancement);
            return this;
        }

        public Builder advancement(Advancement.Builder builder) {
            return this.advancement(builder.build(DOESNT_MATTER).value());
        }

        public Builder advancement(AdvancementHolder holder) {
            return this.advancement(holder.value());
        }

        public Builder advancement(JsonObject value) {
            return this.advancement(null, value);
        }

        private Builder advancement(Advancement value) {
            return this.advancement(value, null);
        }

        private Builder advancement(Advancement value, JsonObject json) {
            if (this.condition == null) {
                throw new IllegalStateException("Can not add a advancement with no conditions.");
            }
            if (value == null) {
                throw new IllegalStateException("Can not add a null advancement");
            }
            this.advancements.add(new Adv(this.condition, value, json));
            this.condition = null;
            return this;
        }

        public JsonObject build(HolderLookup.Provider lookup) {
            JsonObject json = new JsonObject();
            JsonArray array = new JsonArray();
            json.add("advancements", (JsonElement)array);
            RegistryOps ops = lookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            for (Adv pair : this.advancements) {
                JsonObject holder = null;
                holder = pair.json != null ? pair.json : (JsonObject)Advancement.CODEC.encodeStart((DynamicOps)ops, (Object)pair.adv()).getOrThrow(IllegalStateException::new);
                if (holder.has("forge:condition")) {
                    throw new IllegalStateException("Recipe already serialized conditions!");
                }
                ForgeHooks.writeCondition(pair.condition(), holder);
                array.add((JsonElement)holder);
            }
            return json;
        }
    }

    private record Adv(ICondition condition, Advancement adv, JsonObject json) {
    }
}

