/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;

class TagsCommand {
    private static final long PAGE_SIZE = 8L;
    private static final ResourceKey<Registry<Registry<?>>> ROOT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.parse((String)"root"));
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY = new DynamicCommandExceptionType(key -> Component.translatable((String)"commands.forge.tags.error.unknown_registry", (Object[])new Object[]{key}));
    private static final Dynamic2CommandExceptionType UNKNOWN_TAG = new Dynamic2CommandExceptionType((tag, registry) -> Component.translatable((String)"commands.forge.tags.error.unknown_tag", (Object[])new Object[]{tag, registry}));
    private static final Dynamic2CommandExceptionType UNKNOWN_ELEMENT = new Dynamic2CommandExceptionType((tag, registry) -> Component.translatable((String)"commands.forge.tags.error.unknown_element", (Object[])new Object[]{tag, registry}));

    TagsCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"tags").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"registry", (ArgumentType)ResourceKeyArgument.key(ROOT_REGISTRY_KEY)).suggests(TagsCommand::suggestRegistries).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> TagsCommand.listTags((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.listTags((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(Commands.literal((String)"get").then(((RequiredArgumentBuilder)Commands.argument((String)"tag", (ArgumentType)ResourceLocationArgument.id()).suggests(TagsCommand.suggestFromRegistry(r -> r.getTagNames().map(TagKey::location)::iterator)).executes(ctx -> TagsCommand.listTagElements((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.listTagElements((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))).then(Commands.literal((String)"query").then(((RequiredArgumentBuilder)Commands.argument((String)"element", (ArgumentType)ResourceLocationArgument.id()).suggests(TagsCommand.suggestFromRegistry(Registry::keySet)).executes(ctx -> TagsCommand.queryElementTags((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TagsCommand.queryElementTags((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))));
    }

    private static int listTags(CommandContext<CommandSourceStack> ctx, int page) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = TagsCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        Registry registry = (Registry)((CommandSourceStack)ctx.getSource()).getServer().registryAccess().registry(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.location()));
        long tagCount = registry.getTags().count();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> TagsCommand.createMessage(Component.translatable((String)"commands.forge.tags.registry_key", (Object[])new Object[]{Component.literal((String)registryKey.location().toString()).withStyle(ChatFormatting.GOLD)}), "commands.forge.tags.tag_count", "commands.forge.tags.copy_tag_names", tagCount, page, ChatFormatting.DARK_GREEN, () -> registry.getTags().map(Pair::getSecond).map(s -> (String)s.unwrap().map(k -> k.location().toString(), Object::toString))), false);
        return (int)tagCount;
    }

    private static int listTagElements(CommandContext<CommandSourceStack> ctx, int page) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = TagsCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        Registry registry = (Registry)((CommandSourceStack)ctx.getSource()).getServer().registryAccess().registry(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.location()));
        ResourceLocation tagLocation = ResourceLocationArgument.getId(ctx, (String)"tag");
        TagKey tagKey = TagKey.create((ResourceKey)((ResourceKey)TagsCommand.cast(registryKey)), (ResourceLocation)tagLocation);
        HolderSet.Named tag = (HolderSet.Named)registry.getTag((TagKey)TagsCommand.cast(tagKey)).orElseThrow(() -> UNKNOWN_TAG.create((Object)tagKey.location(), (Object)registryKey.location()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> TagsCommand.createMessage(Component.translatable((String)"commands.forge.tags.tag_key", (Object[])new Object[]{Component.literal((String)tagKey.registry().location().toString()).withStyle(ChatFormatting.GOLD), Component.literal((String)tagKey.location().toString()).withStyle(ChatFormatting.DARK_GREEN)}), "commands.forge.tags.element_count", "commands.forge.tags.copy_element_names", tag.size(), page, ChatFormatting.YELLOW, () -> tag.stream().map(s -> (String)s.unwrap().map(k -> k.location().toString(), Object::toString))), false);
        return tag.size();
    }

    private static <T> int queryElementTags(CommandContext<CommandSourceStack> ctx, int page) throws CommandSyntaxException {
        ResourceKey<Registry<?>> registryKey = TagsCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        Registry registry = (Registry)((CommandSourceStack)ctx.getSource()).getServer().registryAccess().registry(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.location()));
        ResourceLocation elementLocation = ResourceLocationArgument.getId(ctx, (String)"element");
        ResourceKey elementKey = ResourceKey.create((ResourceKey)((ResourceKey)TagsCommand.cast(registryKey)), (ResourceLocation)elementLocation);
        Holder elementHolder = (Holder)registry.getHolder(elementKey).orElseThrow(() -> UNKNOWN_ELEMENT.create((Object)elementLocation, (Object)registryKey.location()));
        long containingTagsCount = elementHolder.tags().count();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> TagsCommand.createMessage(Component.translatable((String)"commands.forge.tags.element", (Object[])new Object[]{Component.literal((String)registryKey.location().toString()).withStyle(ChatFormatting.GOLD), Component.literal((String)elementLocation.toString()).withStyle(ChatFormatting.YELLOW)}), "commands.forge.tags.containing_tag_count", "commands.forge.tags.copy_tag_names", containingTagsCount, page, ChatFormatting.DARK_GREEN, () -> elementHolder.tags().map(k -> k.location().toString())), false);
        return (int)containingTagsCount;
    }

    private static MutableComponent createMessage(MutableComponent header, String containsText, String copyHoverText, long count, long currentPage, ChatFormatting elementColor, Supplier<Stream<String>> names) {
        String allElementNames = names.get().sorted().collect(Collectors.joining("\n"));
        long totalPages = (count - 1L) / 8L + 1L;
        long actualPage = Mth.clamp((long)currentPage, (long)1L, (long)totalPages);
        MutableComponent containsComponent = Component.translatable((String)containsText, (Object[])new Object[]{count});
        if (count > 0L) {
            containsComponent = ComponentUtils.wrapInSquareBrackets((Component)containsComponent.withStyle(s -> s.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, allElementNames)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)copyHoverText)))));
            containsComponent = Component.translatable((String)"commands.forge.tags.page_info", (Object[])new Object[]{containsComponent, actualPage, totalPages});
        }
        MutableComponent tagElements = Component.literal((String)"").append((Component)containsComponent);
        names.get().sorted().skip(8L * (actualPage - 1L)).limit(8L).map(Component::literal).map(t -> t.withStyle(elementColor)).map(t -> Component.translatable((String)"\n - ").append((Component)t)).forEach(arg_0 -> ((MutableComponent)tagElements).append(arg_0));
        return header.append("\n").append((Component)tagElements);
    }

    private static CompletableFuture<Suggestions> suggestRegistries(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        ((CommandSourceStack)ctx.getSource()).registryAccess().registries().map(RegistryAccess.RegistryEntry::key).map(ResourceKey::location).map(ResourceLocation::toString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static SuggestionProvider<CommandSourceStack> suggestFromRegistry(Function<Registry<?>, Iterable<ResourceLocation>> namesFunction) {
        return (ctx, builder) -> TagsCommand.getResourceKey((CommandContext<CommandSourceStack>)ctx, "registry", ROOT_REGISTRY_KEY).flatMap(key -> ((CommandSourceStack)ctx.getSource()).registryAccess().registry(key).map(registry -> {
            SharedSuggestionProvider.suggestResource((Iterable)((Iterable)namesFunction.apply((Registry<?>)registry)), (SuggestionsBuilder)builder);
            return builder.buildFuture();
        })).orElseGet(() -> ((SuggestionsBuilder)builder).buildFuture());
    }

    private static <T> Optional<ResourceKey<T>> getResourceKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> registryKey) {
        ResourceKey key = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
        return key.cast(registryKey);
    }

    private static <O> O cast(Object input) {
        return (O)input;
    }
}

