/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.MapMaker;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ResourceKey<T>
implements Comparable<ResourceKey<?>> {
    private static final ConcurrentMap<InternKey, ResourceKey<?>> VALUES = new MapMaker().weakValues().makeMap();
    private final ResourceLocation registryName;
    private final ResourceLocation location;

    public static <T> Codec<ResourceKey<T>> codec(ResourceKey<? extends Registry<T>> p_195967_) {
        return ResourceLocation.CODEC.xmap(p_195979_ -> ResourceKey.create(p_195967_, p_195979_), ResourceKey::location);
    }

    public static <T> StreamCodec<ByteBuf, ResourceKey<T>> streamCodec(ResourceKey<? extends Registry<T>> p_335484_) {
        return ResourceLocation.STREAM_CODEC.map(p_326178_ -> ResourceKey.create(p_335484_, p_326178_), ResourceKey::location);
    }

    public static <T> ResourceKey<T> create(ResourceKey<? extends Registry<T>> p_135786_, ResourceLocation p_135787_) {
        return ResourceKey.create(p_135786_.location, p_135787_);
    }

    public static <T> ResourceKey<Registry<T>> createRegistryKey(ResourceLocation p_135789_) {
        return ResourceKey.create(Registries.ROOT_REGISTRY_NAME, p_135789_);
    }

    private static <T> ResourceKey<T> create(ResourceLocation p_135791_, ResourceLocation p_135792_) {
        return VALUES.computeIfAbsent(new InternKey(p_135791_, p_135792_), p_258225_ -> new ResourceKey(p_258225_.registry, p_258225_.location));
    }

    private ResourceKey(ResourceLocation p_135780_, ResourceLocation p_135781_) {
        this.registryName = p_135780_;
        this.location = p_135781_;
    }

    public String toString() {
        return "ResourceKey[" + String.valueOf(this.registryName) + " / " + String.valueOf(this.location) + "]";
    }

    public boolean isFor(ResourceKey<? extends Registry<?>> p_135784_) {
        return this.registryName.equals(p_135784_.location());
    }

    public <E> Optional<ResourceKey<E>> cast(ResourceKey<? extends Registry<E>> p_195976_) {
        return this.isFor(p_195976_) ? Optional.of(this) : Optional.empty();
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceLocation registry() {
        return this.registryName;
    }

    public ResourceKey<Registry<T>> registryKey() {
        return ResourceKey.createRegistryKey(this.registryName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceKey)) {
            return false;
        }
        ResourceKey resourceKey = (ResourceKey)obj;
        return this.location.equals(resourceKey.location) && this.registryName.equals(resourceKey.registryName);
    }

    @Override
    public int compareTo(ResourceKey<?> resourceKey) {
        int ret = this.registryName.compareTo(resourceKey.registryName);
        return ret == 0 ? this.location.compareTo(resourceKey.location) : ret;
    }

    record InternKey(ResourceLocation registry, ResourceLocation location) {
    }
}

