/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Comparators;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class PlayerChunkSender {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float MIN_CHUNKS_PER_TICK = 0.01f;
    public static final float MAX_CHUNKS_PER_TICK = 64.0f;
    private static final float START_CHUNKS_PER_TICK = 9.0f;
    private static final int MAX_UNACKNOWLEDGED_BATCHES = 10;
    private final LongSet pendingChunks = new LongOpenHashSet();
    private final boolean memoryConnection;
    private float desiredChunksPerTick = 9.0f;
    private float batchQuota;
    private int unacknowledgedBatches;
    private int maxUnacknowledgedBatches = 1;

    public PlayerChunkSender(boolean p_300389_) {
        this.memoryConnection = p_300389_;
    }

    public void markChunkPendingToSend(LevelChunk p_298187_) {
        this.pendingChunks.add(p_298187_.getPos().toLong());
    }

    public void dropChunk(ServerPlayer p_298166_, ChunkPos p_300687_) {
        if (!this.pendingChunks.remove(p_300687_.toLong()) && p_298166_.isAlive()) {
            p_298166_.connection.send(new ClientboundForgetLevelChunkPacket(p_300687_));
            ForgeEventFactory.fireChunkUnWatch((ServerPlayer)p_298166_, (ChunkPos)p_300687_, (ServerLevel)((ServerLevel)p_298166_.level()));
        }
    }

    public void sendNextChunks(ServerPlayer p_297274_) {
        if (this.unacknowledgedBatches < this.maxUnacknowledgedBatches) {
            float f = Math.max(1.0f, this.desiredChunksPerTick);
            this.batchQuota = Math.min(this.batchQuota + this.desiredChunksPerTick, f);
            if (!(this.batchQuota < 1.0f) && !this.pendingChunks.isEmpty()) {
                ServerLevel serverlevel = p_297274_.serverLevel();
                ChunkMap chunkmap = serverlevel.getChunkSource().chunkMap;
                List<LevelChunk> list = this.collectChunksToSend(chunkmap, p_297274_.chunkPosition());
                if (!list.isEmpty()) {
                    ServerGamePacketListenerImpl servergamepacketlistenerimpl = p_297274_.connection;
                    ++this.unacknowledgedBatches;
                    servergamepacketlistenerimpl.send(ClientboundChunkBatchStartPacket.INSTANCE);
                    for (LevelChunk levelchunk : list) {
                        PlayerChunkSender.sendChunk(servergamepacketlistenerimpl, serverlevel, levelchunk);
                    }
                    servergamepacketlistenerimpl.send(new ClientboundChunkBatchFinishedPacket(list.size()));
                    this.batchQuota -= (float)list.size();
                }
            }
        }
    }

    private static void sendChunk(ServerGamePacketListenerImpl p_299748_, ServerLevel p_298120_, LevelChunk p_297712_) {
        p_299748_.send(new ClientboundLevelChunkWithLightPacket(p_297712_, p_298120_.getLightEngine(), null, null));
        ChunkPos chunkpos = p_297712_.getPos();
        DebugPackets.sendPoiPacketsForChunk(p_298120_, chunkpos);
        ForgeEventFactory.fireChunkWatch((ServerPlayer)p_299748_.player, (LevelChunk)p_297712_, (ServerLevel)p_298120_);
    }

    private List<LevelChunk> collectChunksToSend(ChunkMap p_298180_, ChunkPos p_298514_) {
        int i = Mth.floor(this.batchQuota);
        List<LevelChunk> list = !this.memoryConnection && this.pendingChunks.size() > i ? ((List)this.pendingChunks.stream().collect(Comparators.least((int)i, Comparator.comparingInt(p_298514_::distanceSquared)))).stream().mapToLong(Long::longValue).mapToObj(p_298180_::getChunkToSend).filter(Objects::nonNull).toList() : this.pendingChunks.longStream().mapToObj(p_298180_::getChunkToSend).filter(Objects::nonNull).sorted(Comparator.comparingInt(p_299102_ -> p_298514_.distanceSquared(p_299102_.getPos()))).toList();
        for (LevelChunk levelchunk : list) {
            this.pendingChunks.remove(levelchunk.getPos().toLong());
        }
        return list;
    }

    public void onChunkBatchReceivedByClient(float p_298238_) {
        --this.unacknowledgedBatches;
        float f = this.desiredChunksPerTick = Double.isNaN(p_298238_) ? 0.01f : Mth.clamp(p_298238_, 0.01f, 64.0f);
        if (this.unacknowledgedBatches == 0) {
            this.batchQuota = 1.0f;
        }
        this.maxUnacknowledgedBatches = 10;
    }

    public boolean isPending(long p_299869_) {
        return this.pendingChunks.contains(p_299869_);
    }
}

