/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkRocketItem
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public FireworkRocketItem(Item.Properties $$0) {
        super($$0);
    }

    @Override
    public InteractionResult useOn(UseOnContext $$0) {
        Level $$1 = $$0.getLevel();
        if (!$$1.isClientSide) {
            ItemStack $$2 = $$0.getItemInHand();
            Vec3 $$3 = $$0.getClickLocation();
            Direction $$4 = $$0.getClickedFace();
            FireworkRocketEntity $$5 = new FireworkRocketEntity($$1, $$0.getPlayer(), $$3.x + (double)$$4.getStepX() * 0.15, $$3.y + (double)$$4.getStepY() * 0.15, $$3.z + (double)$$4.getStepZ() * 0.15, $$2);
            $$1.addFreshEntity($$5);
            $$2.shrink(1);
        }
        return InteractionResult.sidedSuccess($$1.isClientSide);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        if ($$1.isFallFlying()) {
            ItemStack $$3 = $$1.getItemInHand($$2);
            if (!$$0.isClientSide) {
                FireworkRocketEntity $$4 = new FireworkRocketEntity($$0, $$3, $$1);
                $$0.addFreshEntity($$4);
                $$3.consume(1, $$1);
                $$1.awardStat(Stats.ITEM_USED.get(this));
            }
            return InteractionResultHolder.sidedSuccess($$1.getItemInHand($$2), $$0.isClientSide());
        }
        return InteractionResultHolder.pass($$1.getItemInHand($$2));
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        Fireworks $$4 = $$0.get(DataComponents.FIREWORKS);
        if ($$4 != null) {
            $$4.addToTooltip($$1, $$2::add, $$3);
        }
    }

    @Override
    public Projectile asProjectile(Level $$0, Position $$1, ItemStack $$2, Direction $$3) {
        return new FireworkRocketEntity($$0, $$2.copyWithCount(1), $$1.x(), $$1.y(), $$1.z(), true);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction(FireworkRocketItem::getEntityPokingOutOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3 getEntityPokingOutOfBlockPos(BlockSource $$0, Direction $$1) {
        return $$0.center().add((double)$$1.getStepX() * (0.5000099999997474 - (double)EntityType.FIREWORK_ROCKET.getWidth() / 2.0), (double)$$1.getStepY() * (0.5000099999997474 - (double)EntityType.FIREWORK_ROCKET.getHeight() / 2.0) - (double)EntityType.FIREWORK_ROCKET.getHeight() / 2.0, (double)$$1.getStepZ() * (0.5000099999997474 - (double)EntityType.FIREWORK_ROCKET.getWidth() / 2.0));
    }
}

