/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.event.ForgeEventFactory;

public class PotionBrewing {
    public static final int BREWING_TIME_SECONDS = 20;
    public static final PotionBrewing EMPTY = new PotionBrewing(List.of(), List.of(), List.of());
    private final List<Ingredient> containers;
    private final List<Mix<Potion>> potionMixes;
    private final List<Mix<Item>> containerMixes;
    private final List<IBrewingRecipe> recipes;

    PotionBrewing(List<Ingredient> p_331253_, List<Mix<Potion>> p_333814_, List<Mix<Item>> p_332419_) {
        this(p_331253_, p_333814_, p_332419_, null);
    }

    PotionBrewing(List<Ingredient> p_331253_, List<Mix<Potion>> p_333814_, List<Mix<Item>> p_332419_, Builder builder) {
        this.containers = p_331253_;
        this.potionMixes = p_333814_;
        this.containerMixes = p_332419_;
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.add(new VanillaBrewingRecipe(this, this::mixVanilla));
        if (builder != null) {
            tmp.addAll(builder.recipes);
        }
        this.recipes = Collections.unmodifiableList(tmp);
    }

    public boolean isIngredient(ItemStack p_43507_) {
        if (p_43507_.isEmpty()) {
            return false;
        }
        for (IBrewingRecipe recipe : this.recipes) {
            if (!recipe.isIngredient(p_43507_)) continue;
            return true;
        }
        return false;
    }

    private boolean isContainer(ItemStack p_328293_) {
        for (Ingredient ingredient : this.containers) {
            if (!ingredient.test(p_328293_)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainerIngredient(ItemStack p_43518_) {
        for (Mix<Item> mix : this.containerMixes) {
            if (!mix.ingredient.test(p_43518_)) continue;
            return true;
        }
        return false;
    }

    public boolean isPotionIngredient(ItemStack p_43523_) {
        for (Mix<Potion> mix : this.potionMixes) {
            if (!mix.ingredient.test(p_43523_)) continue;
            return true;
        }
        return false;
    }

    public boolean isBrewablePotion(Holder<Potion> p_330984_) {
        for (Mix<Potion> mix : this.potionMixes) {
            if (!mix.to.is(p_330984_)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMix(ItemStack p_43509_, ItemStack p_43510_) {
        return !this.mix(p_43510_, p_43509_).isEmpty();
    }

    public boolean hasContainerMix(ItemStack p_43520_, ItemStack p_43521_) {
        for (Mix<Item> mix : this.containerMixes) {
            if (!p_43520_.is(mix.from) || !mix.ingredient.test(p_43521_)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPotionMix(ItemStack p_43525_, ItemStack p_43526_) {
        Optional<Holder<Potion>> optional = p_43525_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion();
        if (optional.isEmpty()) {
            return false;
        }
        for (Mix<Potion> mix : this.potionMixes) {
            if (!mix.from.is(optional.get()) || !mix.ingredient.test(p_43526_)) continue;
            return true;
        }
        return false;
    }

    public ItemStack mix(ItemStack p_43530_, ItemStack p_43531_) {
        if (p_43531_.isEmpty() || p_43531_.getCount() != 1) {
            return ItemStack.EMPTY;
        }
        if (p_43530_.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (IBrewingRecipe recipe : this.recipes) {
            ItemStack output = recipe.getOutput(p_43531_, p_43530_);
            if (output.isEmpty()) continue;
            return output;
        }
        return ItemStack.EMPTY;
    }

    private ItemStack mixVanilla(ItemStack p_43530_, ItemStack p_43531_) {
        if (p_43531_.isEmpty()) {
            return p_43531_;
        }
        Optional<Holder<Potion>> optional = p_43531_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion();
        if (optional.isEmpty()) {
            return p_43531_;
        }
        for (Mix<Item> mix : this.containerMixes) {
            if (!p_43531_.is(mix.from) || !mix.ingredient.test(p_43530_)) continue;
            return PotionContents.createItemStack((Item)mix.to.value(), optional.get());
        }
        for (Mix<FeatureElement> mix : this.potionMixes) {
            if (!mix.from.is(optional.get()) || !mix.ingredient.test(p_43530_)) continue;
            return PotionContents.createItemStack(p_43531_.getItem(), mix.to);
        }
        return p_43531_;
    }

    public boolean isValidInput(ItemStack stack) {
        for (IBrewingRecipe recipe : this.recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public List<IBrewingRecipe> getRecipes() {
        return this.recipes;
    }

    public static PotionBrewing bootstrap(FeatureFlagSet p_329176_) {
        Builder potionbrewing$builder = new Builder(p_329176_);
        PotionBrewing.addVanillaMixes(potionbrewing$builder);
        ForgeEventFactory.onBrewingRecipeRegister((Builder)potionbrewing$builder, (FeatureFlagSet)p_329176_);
        return potionbrewing$builder.build();
    }

    public static void addVanillaMixes(Builder p_332525_) {
        p_332525_.addContainer(Items.POTION);
        p_332525_.addContainer(Items.SPLASH_POTION);
        p_332525_.addContainer(Items.LINGERING_POTION);
        p_332525_.addContainerRecipe(Items.POTION, Items.GUNPOWDER, Items.SPLASH_POTION);
        p_332525_.addContainerRecipe(Items.SPLASH_POTION, Items.DRAGON_BREATH, Items.LINGERING_POTION);
        p_332525_.addMix(Potions.WATER, Items.GLOWSTONE_DUST, Potions.THICK);
        p_332525_.addMix(Potions.WATER, Items.REDSTONE, Potions.MUNDANE);
        p_332525_.addMix(Potions.WATER, Items.NETHER_WART, Potions.AWKWARD);
        p_332525_.addStartMix(Items.BREEZE_ROD, Potions.WIND_CHARGED);
        p_332525_.addStartMix(Items.SLIME_BLOCK, Potions.OOZING);
        p_332525_.addStartMix(Items.STONE, Potions.INFESTED);
        p_332525_.addStartMix(Items.COBWEB, Potions.WEAVING);
        p_332525_.addMix(Potions.AWKWARD, Items.GOLDEN_CARROT, Potions.NIGHT_VISION);
        p_332525_.addMix(Potions.NIGHT_VISION, Items.REDSTONE, Potions.LONG_NIGHT_VISION);
        p_332525_.addMix(Potions.NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.INVISIBILITY);
        p_332525_.addMix(Potions.LONG_NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.LONG_INVISIBILITY);
        p_332525_.addMix(Potions.INVISIBILITY, Items.REDSTONE, Potions.LONG_INVISIBILITY);
        p_332525_.addStartMix(Items.MAGMA_CREAM, Potions.FIRE_RESISTANCE);
        p_332525_.addMix(Potions.FIRE_RESISTANCE, Items.REDSTONE, Potions.LONG_FIRE_RESISTANCE);
        p_332525_.addStartMix(Items.RABBIT_FOOT, Potions.LEAPING);
        p_332525_.addMix(Potions.LEAPING, Items.REDSTONE, Potions.LONG_LEAPING);
        p_332525_.addMix(Potions.LEAPING, Items.GLOWSTONE_DUST, Potions.STRONG_LEAPING);
        p_332525_.addMix(Potions.LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        p_332525_.addMix(Potions.LONG_LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        p_332525_.addMix(Potions.SLOWNESS, Items.REDSTONE, Potions.LONG_SLOWNESS);
        p_332525_.addMix(Potions.SLOWNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SLOWNESS);
        p_332525_.addMix(Potions.AWKWARD, Items.TURTLE_HELMET, Potions.TURTLE_MASTER);
        p_332525_.addMix(Potions.TURTLE_MASTER, Items.REDSTONE, Potions.LONG_TURTLE_MASTER);
        p_332525_.addMix(Potions.TURTLE_MASTER, Items.GLOWSTONE_DUST, Potions.STRONG_TURTLE_MASTER);
        p_332525_.addMix(Potions.SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        p_332525_.addMix(Potions.LONG_SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        p_332525_.addStartMix(Items.SUGAR, Potions.SWIFTNESS);
        p_332525_.addMix(Potions.SWIFTNESS, Items.REDSTONE, Potions.LONG_SWIFTNESS);
        p_332525_.addMix(Potions.SWIFTNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SWIFTNESS);
        p_332525_.addMix(Potions.AWKWARD, Items.PUFFERFISH, Potions.WATER_BREATHING);
        p_332525_.addMix(Potions.WATER_BREATHING, Items.REDSTONE, Potions.LONG_WATER_BREATHING);
        p_332525_.addStartMix(Items.GLISTERING_MELON_SLICE, Potions.HEALING);
        p_332525_.addMix(Potions.HEALING, Items.GLOWSTONE_DUST, Potions.STRONG_HEALING);
        p_332525_.addMix(Potions.HEALING, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        p_332525_.addMix(Potions.STRONG_HEALING, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        p_332525_.addMix(Potions.HARMING, Items.GLOWSTONE_DUST, Potions.STRONG_HARMING);
        p_332525_.addMix(Potions.POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        p_332525_.addMix(Potions.LONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        p_332525_.addMix(Potions.STRONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        p_332525_.addStartMix(Items.SPIDER_EYE, Potions.POISON);
        p_332525_.addMix(Potions.POISON, Items.REDSTONE, Potions.LONG_POISON);
        p_332525_.addMix(Potions.POISON, Items.GLOWSTONE_DUST, Potions.STRONG_POISON);
        p_332525_.addStartMix(Items.GHAST_TEAR, Potions.REGENERATION);
        p_332525_.addMix(Potions.REGENERATION, Items.REDSTONE, Potions.LONG_REGENERATION);
        p_332525_.addMix(Potions.REGENERATION, Items.GLOWSTONE_DUST, Potions.STRONG_REGENERATION);
        p_332525_.addStartMix(Items.BLAZE_POWDER, Potions.STRENGTH);
        p_332525_.addMix(Potions.STRENGTH, Items.REDSTONE, Potions.LONG_STRENGTH);
        p_332525_.addMix(Potions.STRENGTH, Items.GLOWSTONE_DUST, Potions.STRONG_STRENGTH);
        p_332525_.addMix(Potions.WATER, Items.FERMENTED_SPIDER_EYE, Potions.WEAKNESS);
        p_332525_.addMix(Potions.WEAKNESS, Items.REDSTONE, Potions.LONG_WEAKNESS);
        p_332525_.addMix(Potions.AWKWARD, Items.PHANTOM_MEMBRANE, Potions.SLOW_FALLING);
        p_332525_.addMix(Potions.SLOW_FALLING, Items.REDSTONE, Potions.LONG_SLOW_FALLING);
    }

    public static class Builder {
        private final List<Ingredient> containers = new ArrayList<Ingredient>();
        private final List<Mix<Potion>> potionMixes = new ArrayList<Mix<Potion>>();
        private final List<Mix<Item>> containerMixes = new ArrayList<Mix<Item>>();
        private final FeatureFlagSet enabledFeatures;
        private final List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

        public Builder(FeatureFlagSet p_332559_) {
            this.enabledFeatures = p_332559_;
        }

        private static void expectPotion(Item p_335280_) {
            if (!(p_335280_ instanceof PotionItem)) {
                throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.ITEM.getKey(p_335280_)));
            }
        }

        public void addContainerRecipe(Item p_332816_, Item p_336336_, Item p_330133_) {
            if (p_332816_.isEnabled(this.enabledFeatures) && p_336336_.isEnabled(this.enabledFeatures) && p_330133_.isEnabled(this.enabledFeatures)) {
                Builder.expectPotion(p_332816_);
                Builder.expectPotion(p_330133_);
                this.containerMixes.add(new Mix<Item>(p_332816_.builtInRegistryHolder(), Ingredient.of(p_336336_), p_330133_.builtInRegistryHolder()));
            }
        }

        public void addContainer(Item p_329695_) {
            if (p_329695_.isEnabled(this.enabledFeatures)) {
                Builder.expectPotion(p_329695_);
                this.containers.add(Ingredient.of(p_329695_));
            }
        }

        public void addMix(Holder<Potion> p_333042_, Item p_331299_, Holder<Potion> p_328607_) {
            if (p_333042_.value().isEnabled(this.enabledFeatures) && p_331299_.isEnabled(this.enabledFeatures) && p_328607_.value().isEnabled(this.enabledFeatures)) {
                this.potionMixes.add(new Mix<Potion>(p_333042_, Ingredient.of(p_331299_), p_328607_));
            }
        }

        public void addStartMix(Item p_327705_, Holder<Potion> p_328478_) {
            if (p_328478_.value().isEnabled(this.enabledFeatures)) {
                this.addMix(Potions.WATER, p_327705_, Potions.MUNDANE);
                this.addMix(Potions.AWKWARD, p_327705_, p_328478_);
            }
        }

        public Builder add(IBrewingRecipe recipe) {
            this.recipes.add(recipe);
            return this;
        }

        public PotionBrewing build() {
            return new PotionBrewing(List.copyOf(this.containers), List.copyOf(this.potionMixes), List.copyOf(this.containerMixes), this);
        }
    }

    public record Mix<T>(Holder<T> from, Ingredient ingredient, Holder<T> to) {
    }
}

