/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FireworkStarRecipe
extends CustomRecipe {
    private static final Ingredient SHAPE_INGREDIENT = Ingredient.of(Items.FIRE_CHARGE, Items.FEATHER, Items.GOLD_NUGGET, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, Items.CREEPER_HEAD, Items.PLAYER_HEAD, Items.DRAGON_HEAD, Items.ZOMBIE_HEAD, Items.PIGLIN_HEAD);
    private static final Ingredient TRAIL_INGREDIENT = Ingredient.of(Items.DIAMOND);
    private static final Ingredient TWINKLE_INGREDIENT = Ingredient.of(Items.GLOWSTONE_DUST);
    private static final Map<Item, FireworkExplosion.Shape> SHAPE_BY_ITEM = Util.make(Maps.newHashMap(), $$0 -> {
        $$0.put(Items.FIRE_CHARGE, FireworkExplosion.Shape.LARGE_BALL);
        $$0.put(Items.FEATHER, FireworkExplosion.Shape.BURST);
        $$0.put(Items.GOLD_NUGGET, FireworkExplosion.Shape.STAR);
        $$0.put(Items.SKELETON_SKULL, FireworkExplosion.Shape.CREEPER);
        $$0.put(Items.WITHER_SKELETON_SKULL, FireworkExplosion.Shape.CREEPER);
        $$0.put(Items.CREEPER_HEAD, FireworkExplosion.Shape.CREEPER);
        $$0.put(Items.PLAYER_HEAD, FireworkExplosion.Shape.CREEPER);
        $$0.put(Items.DRAGON_HEAD, FireworkExplosion.Shape.CREEPER);
        $$0.put(Items.ZOMBIE_HEAD, FireworkExplosion.Shape.CREEPER);
        $$0.put(Items.PIGLIN_HEAD, FireworkExplosion.Shape.CREEPER);
    });
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.of(Items.GUNPOWDER);

    public FireworkStarRecipe(CraftingBookCategory $$0) {
        super($$0);
    }

    @Override
    public boolean matches(CraftingInput $$0, Level $$1) {
        boolean $$2 = false;
        boolean $$3 = false;
        boolean $$4 = false;
        boolean $$5 = false;
        boolean $$6 = false;
        for (int $$7 = 0; $$7 < $$0.size(); ++$$7) {
            ItemStack $$8 = $$0.getItem($$7);
            if ($$8.isEmpty()) continue;
            if (SHAPE_INGREDIENT.test($$8)) {
                if ($$4) {
                    return false;
                }
                $$4 = true;
                continue;
            }
            if (TWINKLE_INGREDIENT.test($$8)) {
                if ($$6) {
                    return false;
                }
                $$6 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test($$8)) {
                if ($$5) {
                    return false;
                }
                $$5 = true;
                continue;
            }
            if (GUNPOWDER_INGREDIENT.test($$8)) {
                if ($$2) {
                    return false;
                }
                $$2 = true;
                continue;
            }
            if ($$8.getItem() instanceof DyeItem) {
                $$3 = true;
                continue;
            }
            return false;
        }
        return $$2 && $$3;
    }

    @Override
    public ItemStack assemble(CraftingInput $$0, HolderLookup.Provider $$1) {
        FireworkExplosion.Shape $$2 = FireworkExplosion.Shape.SMALL_BALL;
        boolean $$3 = false;
        boolean $$4 = false;
        IntArrayList $$5 = new IntArrayList();
        for (int $$6 = 0; $$6 < $$0.size(); ++$$6) {
            ItemStack $$7 = $$0.getItem($$6);
            if ($$7.isEmpty()) continue;
            if (SHAPE_INGREDIENT.test($$7)) {
                $$2 = SHAPE_BY_ITEM.get($$7.getItem());
                continue;
            }
            if (TWINKLE_INGREDIENT.test($$7)) {
                $$3 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test($$7)) {
                $$4 = true;
                continue;
            }
            if (!($$7.getItem() instanceof DyeItem)) continue;
            $$5.add(((DyeItem)$$7.getItem()).getDyeColor().getFireworkColor());
        }
        ItemStack $$8 = new ItemStack(Items.FIREWORK_STAR);
        $$8.set(DataComponents.FIREWORK_EXPLOSION, new FireworkExplosion($$2, (IntList)$$5, IntList.of(), $$4, $$3));
        return $$8;
    }

    @Override
    public boolean canCraftInDimensions(int $$0, int $$1) {
        return $$0 * $$1 >= 2;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider $$0) {
        return new ItemStack(Items.FIREWORK_STAR);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR;
    }
}

