/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class KilledByCrossbowTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    @Override
    public void trigger(ServerPlayer $$0, Collection<Entity> $$1) {
        ArrayList $$22 = Lists.newArrayList();
        HashSet $$3 = Sets.newHashSet();
        for (Entity $$4 : $$1) {
            $$3.add($$4.getType());
            $$22.add(EntityPredicate.createContext($$0, $$4));
        }
        this.trigger($$0, (T $$2) -> $$2.matches($$22, $$3.size()));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, List<ContextAwarePredicate> victims, MinMaxBounds.Ints uniqueEntityTypes) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.listOf().optionalFieldOf("victims", List.of()).forGetter(TriggerInstance::victims), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("unique_entity_types", (Object)MinMaxBounds.Ints.ANY).forGetter(TriggerInstance::uniqueEntityTypes)).apply((Applicative)$$0, TriggerInstance::new));

        public static Criterion<TriggerInstance> crossbowKilled(EntityPredicate.Builder ... $$0) {
            return CriteriaTriggers.KILLED_BY_CROSSBOW.createCriterion(new TriggerInstance(Optional.empty(), EntityPredicate.wrap($$0), MinMaxBounds.Ints.ANY));
        }

        public static Criterion<TriggerInstance> crossbowKilled(MinMaxBounds.Ints $$0) {
            return CriteriaTriggers.KILLED_BY_CROSSBOW.createCriterion(new TriggerInstance(Optional.empty(), List.of(), $$0));
        }

        public boolean matches(Collection<LootContext> $$0, int $$1) {
            if (!this.victims.isEmpty()) {
                ArrayList $$2 = Lists.newArrayList($$0);
                for (ContextAwarePredicate $$3 : this.victims) {
                    boolean $$4 = false;
                    Iterator $$5 = $$2.iterator();
                    while ($$5.hasNext()) {
                        LootContext $$6 = (LootContext)$$5.next();
                        if (!$$3.matches($$6)) continue;
                        $$5.remove();
                        $$4 = true;
                        break;
                    }
                    if ($$4) continue;
                    return false;
                }
            }
            return this.uniqueEntityTypes.matches($$1);
        }

        @Override
        public void validate(CriterionValidator $$0) {
            SimpleCriterionTrigger.SimpleInstance.super.validate($$0);
            $$0.validateEntities(this.victims, ".victims");
        }
    }
}

