/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import net.minecraft.CharPredicate;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;

public class ParserUtils {
    private static final Field JSON_READER_POS = Util.make(() -> {
        try {
            Field $$0 = JsonReader.class.getDeclaredField("pos");
            $$0.setAccessible(true);
            return $$0;
        }
        catch (NoSuchFieldException $$1) {
            throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", $$1);
        }
    });
    private static final Field JSON_READER_LINESTART = Util.make(() -> {
        try {
            Field $$0 = JsonReader.class.getDeclaredField("lineStart");
            $$0.setAccessible(true);
            return $$0;
        }
        catch (NoSuchFieldException $$1) {
            throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", $$1);
        }
    });

    private static int getPos(JsonReader $$0) {
        try {
            return JSON_READER_POS.getInt($$0) - JSON_READER_LINESTART.getInt($$0);
        }
        catch (IllegalAccessException $$1) {
            throw new IllegalStateException("Couldn't read position of JsonReader", $$1);
        }
    }

    public static <T> T parseJson(HolderLookup.Provider $$0, com.mojang.brigadier.StringReader $$1, Codec<T> $$2) {
        JsonReader $$3 = new JsonReader((Reader)new StringReader($$1.getRemaining()));
        $$3.setLenient(false);
        try {
            JsonElement $$4 = Streams.parse((JsonReader)$$3);
            Object object = $$2.parse($$0.createSerializationContext(JsonOps.INSTANCE), (Object)$$4).getOrThrow(JsonParseException::new);
            return (T)object;
        }
        catch (StackOverflowError $$5) {
            throw new JsonParseException((Throwable)$$5);
        }
        finally {
            $$1.setCursor($$1.getCursor() + ParserUtils.getPos($$3));
        }
    }

    public static String readWhile(com.mojang.brigadier.StringReader $$0, CharPredicate $$1) {
        int $$2 = $$0.getCursor();
        while ($$0.canRead() && $$1.test($$0.peek())) {
            $$0.skip();
        }
        return $$0.getString().substring($$2, $$0.getCursor());
    }
}

