/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();
    private static final String WRAPPER_MARKER = "";

    protected NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> $$0, Tag $$1) {
        return (U)(switch ($$1.getId()) {
            case 0 -> $$0.empty();
            case 1 -> $$0.createByte(((NumericTag)$$1).getAsByte());
            case 2 -> $$0.createShort(((NumericTag)$$1).getAsShort());
            case 3 -> $$0.createInt(((NumericTag)$$1).getAsInt());
            case 4 -> $$0.createLong(((NumericTag)$$1).getAsLong());
            case 5 -> $$0.createFloat(((NumericTag)$$1).getAsFloat());
            case 6 -> $$0.createDouble(((NumericTag)$$1).getAsDouble());
            case 7 -> $$0.createByteList(ByteBuffer.wrap(((ByteArrayTag)$$1).getAsByteArray()));
            case 8 -> $$0.createString($$1.getAsString());
            case 9 -> this.convertList($$0, $$1);
            case 10 -> this.convertMap($$0, $$1);
            case 11 -> $$0.createIntList(Arrays.stream(((IntArrayTag)$$1).getAsIntArray()));
            case 12 -> $$0.createLongList(Arrays.stream(((LongArrayTag)$$1).getAsLongArray()));
            default -> throw new IllegalStateException("Unknown tag type: " + String.valueOf($$1));
        });
    }

    public DataResult<Number> getNumberValue(Tag $$0) {
        if ($$0 instanceof NumericTag) {
            NumericTag $$1 = (NumericTag)$$0;
            return DataResult.success((Object)$$1.getAsNumber());
        }
        return DataResult.error(() -> "Not a number");
    }

    public Tag createNumeric(Number $$0) {
        return DoubleTag.valueOf($$0.doubleValue());
    }

    public Tag createByte(byte $$0) {
        return ByteTag.valueOf($$0);
    }

    public Tag createShort(short $$0) {
        return ShortTag.valueOf($$0);
    }

    public Tag createInt(int $$0) {
        return IntTag.valueOf($$0);
    }

    public Tag createLong(long $$0) {
        return LongTag.valueOf($$0);
    }

    public Tag createFloat(float $$0) {
        return FloatTag.valueOf($$0);
    }

    public Tag createDouble(double $$0) {
        return DoubleTag.valueOf($$0);
    }

    public Tag createBoolean(boolean $$0) {
        return ByteTag.valueOf($$0);
    }

    public DataResult<String> getStringValue(Tag $$0) {
        if ($$0 instanceof StringTag) {
            StringTag $$1 = (StringTag)$$0;
            return DataResult.success((Object)$$1.getAsString());
        }
        return DataResult.error(() -> "Not a string");
    }

    public Tag createString(String $$0) {
        return StringTag.valueOf($$0);
    }

    public DataResult<Tag> mergeToList(Tag $$0, Tag $$12) {
        return NbtOps.createCollector($$0).map($$1 -> DataResult.success((Object)$$1.accept($$12).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf($$0), (Object)$$0));
    }

    public DataResult<Tag> mergeToList(Tag $$0, List<Tag> $$12) {
        return NbtOps.createCollector($$0).map($$1 -> DataResult.success((Object)$$1.acceptAll($$12).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf($$0), (Object)$$0));
    }

    public DataResult<Tag> mergeToMap(Tag $$0, Tag $$1, Tag $$2) {
        CompoundTag compoundTag;
        if (!($$0 instanceof CompoundTag) && !($$0 instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf($$0), (Object)$$0);
        }
        if (!($$1 instanceof StringTag)) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf($$1), (Object)$$0);
        }
        if ($$0 instanceof CompoundTag) {
            CompoundTag $$3 = (CompoundTag)$$0;
            compoundTag = $$3.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$4 = compoundTag;
        $$4.put($$1.getAsString(), $$2);
        return DataResult.success((Object)$$4);
    }

    public DataResult<Tag> mergeToMap(Tag $$0, MapLike<Tag> $$1) {
        CompoundTag compoundTag;
        if (!($$0 instanceof CompoundTag) && !($$0 instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf($$0), (Object)$$0);
        }
        if ($$0 instanceof CompoundTag) {
            CompoundTag $$22 = (CompoundTag)$$0;
            compoundTag = $$22.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$3 = compoundTag;
        ArrayList $$4 = new ArrayList();
        $$1.entries().forEach($$2 -> {
            Tag $$3 = (Tag)$$2.getFirst();
            if (!($$3 instanceof StringTag)) {
                $$4.add($$3);
                return;
            }
            $$3.put($$3.getAsString(), (Tag)$$2.getSecond());
        });
        if (!$$4.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf($$4), (Object)$$3);
        }
        return DataResult.success((Object)$$3);
    }

    public DataResult<Tag> mergeToMap(Tag $$0, Map<Tag, Tag> $$1) {
        CompoundTag compoundTag;
        if (!($$0 instanceof CompoundTag) && !($$0 instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf($$0), (Object)$$0);
        }
        if ($$0 instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)$$0;
            compoundTag = $$2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$3 = compoundTag;
        ArrayList<Tag> $$4 = new ArrayList<Tag>();
        for (Map.Entry<Tag, Tag> $$5 : $$1.entrySet()) {
            Tag $$6 = $$5.getKey();
            if ($$6 instanceof StringTag) {
                $$3.put($$6.getAsString(), $$5.getValue());
                continue;
            }
            $$4.add($$6);
        }
        if (!$$4.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf($$4), (Object)$$3);
        }
        return DataResult.success((Object)$$3);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag $$02) {
        if ($$02 instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)$$02;
            return DataResult.success($$1.entrySet().stream().map($$0 -> Pair.of((Object)this.createString((String)$$0.getKey()), (Object)((Tag)$$0.getValue()))));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf($$02));
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag $$0) {
        if ($$0 instanceof CompoundTag) {
            CompoundTag $$12 = (CompoundTag)$$0;
            return DataResult.success($$1 -> {
                for (Map.Entry<String, Tag> $$2 : $$12.entrySet()) {
                    $$1.accept(this.createString($$2.getKey()), $$2.getValue());
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf($$0));
    }

    public DataResult<MapLike<Tag>> getMap(Tag $$0) {
        if ($$0 instanceof CompoundTag) {
            final CompoundTag $$1 = (CompoundTag)$$0;
            return DataResult.success((Object)new MapLike<Tag>(){

                @Nullable
                public Tag get(Tag $$0) {
                    return $$1.get($$0.getAsString());
                }

                @Nullable
                public Tag get(String $$0) {
                    return $$1.get($$0);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return $$1.entrySet().stream().map($$0 -> Pair.of((Object)NbtOps.this.createString((String)$$0.getKey()), (Object)((Tag)$$0.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf($$1) + "]";
                }

                @Nullable
                public /* synthetic */ Object get(String string) {
                    return this.get(string);
                }

                @Nullable
                public /* synthetic */ Object get(Object object) {
                    return this.get((Tag)object);
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf($$0));
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> $$0) {
        CompoundTag $$12 = new CompoundTag();
        $$0.forEach($$1 -> $$12.put(((Tag)$$1.getFirst()).getAsString(), (Tag)$$1.getSecond()));
        return $$12;
    }

    private static Tag tryUnwrap(CompoundTag $$0) {
        Tag $$1;
        if ($$0.size() == 1 && ($$1 = $$0.get(WRAPPER_MARKER)) != null) {
            return $$1;
        }
        return $$0;
    }

    public DataResult<Stream<Tag>> getStream(Tag $$02) {
        if ($$02 instanceof ListTag) {
            ListTag $$1 = (ListTag)$$02;
            if ($$1.getElementType() == 10) {
                return DataResult.success($$1.stream().map($$0 -> NbtOps.tryUnwrap((CompoundTag)$$0)));
            }
            return DataResult.success($$1.stream());
        }
        if ($$02 instanceof CollectionTag) {
            CollectionTag $$2 = (CollectionTag)$$02;
            return DataResult.success($$2.stream().map($$0 -> $$0));
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag $$0) {
        if ($$0 instanceof ListTag) {
            ListTag $$12 = (ListTag)$$0;
            if ($$12.getElementType() == 10) {
                return DataResult.success($$1 -> {
                    for (Tag $$2 : $$12) {
                        $$1.accept(NbtOps.tryUnwrap((CompoundTag)$$2));
                    }
                });
            }
            return DataResult.success($$12::forEach);
        }
        if ($$0 instanceof CollectionTag) {
            CollectionTag $$2 = (CollectionTag)$$0;
            return DataResult.success($$2::forEach);
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf($$0));
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag $$0) {
        if ($$0 instanceof ByteArrayTag) {
            ByteArrayTag $$1 = (ByteArrayTag)$$0;
            return DataResult.success((Object)ByteBuffer.wrap($$1.getAsByteArray()));
        }
        return super.getByteBuffer((Object)$$0);
    }

    public Tag createByteList(ByteBuffer $$0) {
        ByteBuffer $$1 = $$0.duplicate().clear();
        byte[] $$2 = new byte[$$0.capacity()];
        $$1.get(0, $$2, 0, $$2.length);
        return new ByteArrayTag($$2);
    }

    public DataResult<IntStream> getIntStream(Tag $$0) {
        if ($$0 instanceof IntArrayTag) {
            IntArrayTag $$1 = (IntArrayTag)$$0;
            return DataResult.success((Object)Arrays.stream($$1.getAsIntArray()));
        }
        return super.getIntStream((Object)$$0);
    }

    public Tag createIntList(IntStream $$0) {
        return new IntArrayTag($$0.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag $$0) {
        if ($$0 instanceof LongArrayTag) {
            LongArrayTag $$1 = (LongArrayTag)$$0;
            return DataResult.success((Object)Arrays.stream($$1.getAsLongArray()));
        }
        return super.getLongStream((Object)$$0);
    }

    public Tag createLongList(LongStream $$0) {
        return new LongArrayTag($$0.toArray());
    }

    public Tag createList(Stream<Tag> $$0) {
        return InitialListCollector.INSTANCE.acceptAll($$0).result();
    }

    public Tag remove(Tag $$0, String $$1) {
        if ($$0 instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)$$0;
            CompoundTag $$3 = $$2.shallowCopy();
            $$3.remove($$1);
            return $$3;
        }
        return $$0;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag $$0) {
        if ($$0 instanceof EndTag) {
            return Optional.of(InitialListCollector.INSTANCE);
        }
        if ($$0 instanceof CollectionTag) {
            CollectionTag $$1 = (CollectionTag)$$0;
            if ($$1.isEmpty()) {
                return Optional.of(InitialListCollector.INSTANCE);
            }
            if ($$1 instanceof ListTag) {
                ListTag $$2 = (ListTag)$$1;
                return switch ($$2.getElementType()) {
                    case 0 -> Optional.of(InitialListCollector.INSTANCE);
                    case 10 -> Optional.of(new HeterogenousListCollector($$2));
                    default -> Optional.of(new HomogenousListCollector($$2));
                };
            }
            if ($$1 instanceof ByteArrayTag) {
                ByteArrayTag $$3 = (ByteArrayTag)$$1;
                return Optional.of(new ByteListCollector($$3.getAsByteArray()));
            }
            if ($$1 instanceof IntArrayTag) {
                IntArrayTag $$4 = (IntArrayTag)$$1;
                return Optional.of(new IntListCollector($$4.getAsIntArray()));
            }
            if ($$1 instanceof LongArrayTag) {
                LongArrayTag $$5 = (LongArrayTag)$$1;
                return Optional.of(new LongListCollector($$5.getAsLongArray()));
            }
        }
        return Optional.empty();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((Tag)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((Tag)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((Tag)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((Tag)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((Tag)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((Tag)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((Tag)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((Tag)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((Tag)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((Tag)object, (MapLike<Tag>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Map map) {
        return this.mergeToMap((Tag)object, (Map<Tag, Tag>)map);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((Tag)object, (Tag)object2, (Tag)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((Tag)object, (List<Tag>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((Tag)object, (Tag)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((Tag)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((Tag)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (Tag)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    static class InitialListCollector
    implements ListCollector {
        public static final InitialListCollector INSTANCE = new InitialListCollector();

        private InitialListCollector() {
        }

        @Override
        public ListCollector accept(Tag $$0) {
            if ($$0 instanceof CompoundTag) {
                CompoundTag $$1 = (CompoundTag)$$0;
                return new HeterogenousListCollector().accept($$1);
            }
            if ($$0 instanceof ByteTag) {
                ByteTag $$2 = (ByteTag)$$0;
                return new ByteListCollector($$2.getAsByte());
            }
            if ($$0 instanceof IntTag) {
                IntTag $$3 = (IntTag)$$0;
                return new IntListCollector($$3.getAsInt());
            }
            if ($$0 instanceof LongTag) {
                LongTag $$4 = (LongTag)$$0;
                return new LongListCollector($$4.getAsLong());
            }
            return new HomogenousListCollector($$0);
        }

        @Override
        public Tag result() {
            return new ListTag();
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> $$0) {
            ListCollector $$1 = this;
            for (Tag $$2 : $$0) {
                $$1 = $$1.accept($$2);
            }
            return $$1;
        }

        default public ListCollector acceptAll(Stream<Tag> $$0) {
            return this.acceptAll($$0::iterator);
        }

        public Tag result();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(NbtOps nbtOps) {
            super((DynamicOps)nbtOps);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String $$0, Tag $$1, CompoundTag $$2) {
            $$2.put($$0, $$1);
            return $$2;
        }

        protected DataResult<Tag> build(CompoundTag $$0, Tag $$1) {
            if ($$1 == null || $$1 == EndTag.INSTANCE) {
                return DataResult.success((Object)$$0);
            }
            if ($$1 instanceof CompoundTag) {
                CompoundTag $$2 = (CompoundTag)$$1;
                CompoundTag $$3 = $$2.shallowCopy();
                for (Map.Entry<String, Tag> $$4 : $$0.entrySet()) {
                    $$3.put($$4.getKey(), $$4.getValue());
                }
                return DataResult.success((Object)$$3);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf($$1), (Object)$$1);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (Tag)object, (CompoundTag)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((CompoundTag)object, (Tag)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }

    static class HeterogenousListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        public HeterogenousListCollector() {
        }

        public HeterogenousListCollector(Collection<Tag> $$0) {
            this.result.addAll($$0);
        }

        public HeterogenousListCollector(IntArrayList $$02) {
            $$02.forEach($$0 -> this.result.add(HeterogenousListCollector.wrapElement(IntTag.valueOf($$0))));
        }

        public HeterogenousListCollector(ByteArrayList $$02) {
            $$02.forEach($$0 -> this.result.add(HeterogenousListCollector.wrapElement(ByteTag.valueOf($$0))));
        }

        public HeterogenousListCollector(LongArrayList $$02) {
            $$02.forEach($$0 -> this.result.add(HeterogenousListCollector.wrapElement(LongTag.valueOf($$0))));
        }

        private static boolean isWrapper(CompoundTag $$0) {
            return $$0.size() == 1 && $$0.contains(NbtOps.WRAPPER_MARKER);
        }

        private static Tag wrapIfNeeded(Tag $$0) {
            CompoundTag $$1;
            if ($$0 instanceof CompoundTag && !HeterogenousListCollector.isWrapper($$1 = (CompoundTag)$$0)) {
                return $$1;
            }
            return HeterogenousListCollector.wrapElement($$0);
        }

        private static CompoundTag wrapElement(Tag $$0) {
            CompoundTag $$1 = new CompoundTag();
            $$1.put(NbtOps.WRAPPER_MARKER, $$0);
            return $$1;
        }

        @Override
        public ListCollector accept(Tag $$0) {
            this.result.add(HeterogenousListCollector.wrapIfNeeded($$0));
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class HomogenousListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        HomogenousListCollector(Tag $$0) {
            this.result.add($$0);
        }

        HomogenousListCollector(ListTag $$0) {
            this.result.addAll($$0);
        }

        @Override
        public ListCollector accept(Tag $$0) {
            if ($$0.getId() != this.result.getElementType()) {
                return new HeterogenousListCollector().acceptAll(this.result).accept($$0);
            }
            this.result.add($$0);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        public ByteListCollector(byte $$0) {
            this.values.add($$0);
        }

        public ByteListCollector(byte[] $$0) {
            this.values.addElements(0, $$0);
        }

        @Override
        public ListCollector accept(Tag $$0) {
            if ($$0 instanceof ByteTag) {
                ByteTag $$1 = (ByteTag)$$0;
                this.values.add($$1.getAsByte());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept($$0);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        public IntListCollector(int $$0) {
            this.values.add($$0);
        }

        public IntListCollector(int[] $$0) {
            this.values.addElements(0, $$0);
        }

        @Override
        public ListCollector accept(Tag $$0) {
            if ($$0 instanceof IntTag) {
                IntTag $$1 = (IntTag)$$0;
                this.values.add($$1.getAsInt());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept($$0);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        public LongListCollector(long $$0) {
            this.values.add($$0);
        }

        public LongListCollector(long[] $$0) {
            this.values.addElements(0, $$0);
        }

        @Override
        public ListCollector accept(Tag $$0) {
            if ($$0 instanceof LongTag) {
                LongTag $$1 = (LongTag)$$0;
                this.values.add($$1.getAsLong());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept($$0);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }
}

