/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class ServerPlaceRecipe<I extends RecipeInput, R extends Recipe<I>>
implements PlaceRecipe<Integer> {
    private static final int ITEM_NOT_FOUND = -1;
    protected final StackedContents stackedContents = new StackedContents();
    protected Inventory inventory;
    protected RecipeBookMenu<I, R> menu;

    public ServerPlaceRecipe(RecipeBookMenu<I, R> $$0) {
        this.menu = $$0;
    }

    public void recipeClicked(ServerPlayer $$0, @Nullable RecipeHolder<R> $$1, boolean $$2) {
        if ($$1 == null || !$$0.getRecipeBook().contains($$1)) {
            return;
        }
        this.inventory = $$0.getInventory();
        if (!this.testClearGrid() && !$$0.isCreative()) {
            return;
        }
        this.stackedContents.clear();
        $$0.getInventory().fillStackedContents(this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        if (this.stackedContents.canCraft((Recipe<?>)$$1.value(), null)) {
            this.handleRecipeClicked($$1, $$2);
        } else {
            this.clearGrid();
            $$0.connection.send(new ClientboundPlaceGhostRecipePacket($$0.containerMenu.containerId, $$1));
        }
        $$0.getInventory().setChanged();
    }

    protected void clearGrid() {
        for (int $$0 = 0; $$0 < this.menu.getSize(); ++$$0) {
            if (!this.menu.shouldMoveToInventory($$0)) continue;
            ItemStack $$1 = this.menu.getSlot($$0).getItem().copy();
            this.inventory.placeItemBackInInventory($$1, false);
            this.menu.getSlot($$0).set($$1);
        }
        this.menu.clearCraftingContent();
    }

    protected void handleRecipeClicked(RecipeHolder<R> $$0, boolean $$1) {
        boolean $$2 = this.menu.recipeMatches($$0);
        int $$3 = this.stackedContents.getBiggestCraftableStack($$0, null);
        if ($$2) {
            for (int $$4 = 0; $$4 < this.menu.getGridHeight() * this.menu.getGridWidth() + 1; ++$$4) {
                ItemStack $$5;
                if ($$4 == this.menu.getResultSlotIndex() || ($$5 = this.menu.getSlot($$4).getItem()).isEmpty() || Math.min($$3, $$5.getMaxStackSize()) >= $$5.getCount() + 1) continue;
                return;
            }
        }
        int $$6 = this.getStackSize($$1, $$3, $$2);
        IntArrayList $$7 = new IntArrayList();
        if (this.stackedContents.canCraft((Recipe<?>)$$0.value(), (IntList)$$7, $$6)) {
            int $$8 = $$6;
            IntListIterator intListIterator = $$7.iterator();
            while (intListIterator.hasNext()) {
                int $$11;
                int $$9 = (Integer)intListIterator.next();
                ItemStack $$10 = StackedContents.fromStackingIndex($$9);
                if ($$10.isEmpty() || ($$11 = $$10.getMaxStackSize()) >= $$8) continue;
                $$8 = $$11;
            }
            $$6 = $$8;
            if (this.stackedContents.canCraft((Recipe<?>)$$0.value(), (IntList)$$7, $$6)) {
                this.clearGrid();
                this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), $$0, $$7.iterator(), $$6);
            }
        }
    }

    @Override
    public void addItemToSlot(Integer $$0, int $$1, int $$2, int $$3, int $$4) {
        Slot $$5 = this.menu.getSlot($$1);
        ItemStack $$6 = StackedContents.fromStackingIndex($$0);
        if ($$6.isEmpty()) {
            return;
        }
        int $$7 = $$2;
        while ($$7 > 0) {
            if (($$7 = this.moveItemToGrid($$5, $$6, $$7)) != -1) continue;
            return;
        }
    }

    protected int getStackSize(boolean $$0, int $$1, boolean $$2) {
        int $$3 = 1;
        if ($$0) {
            $$3 = $$1;
        } else if ($$2) {
            $$3 = Integer.MAX_VALUE;
            for (int $$4 = 0; $$4 < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++$$4) {
                ItemStack $$5;
                if ($$4 == this.menu.getResultSlotIndex() || ($$5 = this.menu.getSlot($$4).getItem()).isEmpty() || $$3 <= $$5.getCount()) continue;
                $$3 = $$5.getCount();
            }
            if ($$3 != Integer.MAX_VALUE) {
                ++$$3;
            }
        }
        return $$3;
    }

    protected int moveItemToGrid(Slot $$0, ItemStack $$1, int $$2) {
        int $$6;
        int $$3 = this.inventory.findSlotMatchingUnusedItem($$1);
        if ($$3 == -1) {
            return -1;
        }
        ItemStack $$4 = this.inventory.getItem($$3);
        if ($$2 < $$4.getCount()) {
            this.inventory.removeItem($$3, $$2);
            int $$5 = $$2;
        } else {
            this.inventory.removeItemNoUpdate($$3);
            $$6 = $$4.getCount();
        }
        if ($$0.getItem().isEmpty()) {
            $$0.set($$4.copyWithCount($$6));
        } else {
            $$0.getItem().grow($$6);
        }
        return $$2 - $$6;
    }

    private boolean testClearGrid() {
        ArrayList $$0 = Lists.newArrayList();
        int $$1 = this.getAmountOfFreeSlotsInInventory();
        for (int $$2 = 0; $$2 < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++$$2) {
            ItemStack $$3;
            if ($$2 == this.menu.getResultSlotIndex() || ($$3 = this.menu.getSlot($$2).getItem().copy()).isEmpty()) continue;
            int $$4 = this.inventory.getSlotWithRemainingSpace($$3);
            if ($$4 == -1 && $$0.size() <= $$1) {
                for (ItemStack $$5 : $$0) {
                    if (!ItemStack.isSameItem($$5, $$3) || $$5.getCount() == $$5.getMaxStackSize() || $$5.getCount() + $$3.getCount() > $$5.getMaxStackSize()) continue;
                    $$5.grow($$3.getCount());
                    $$3.setCount(0);
                    break;
                }
                if ($$3.isEmpty()) continue;
                if ($$0.size() < $$1) {
                    $$0.add($$3);
                    continue;
                }
                return false;
            }
            if ($$4 != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int $$0 = 0;
        for (ItemStack $$1 : this.inventory.items) {
            if (!$$1.isEmpty()) continue;
            ++$$0;
        }
        return $$0;
    }
}

