/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final Function<ResourceLocation, Optional<? extends T>> idToValue;
    private final String directory;

    public TagLoader(Function<ResourceLocation, Optional<? extends T>> $$0, String $$1) {
        this.idToValue = $$0;
        this.directory = $$1;
    }

    public Map<ResourceLocation, List<EntryWithSource>> load(ResourceManager $$02) {
        HashMap $$1 = Maps.newHashMap();
        FileToIdConverter $$22 = FileToIdConverter.json(this.directory);
        for (Map.Entry<ResourceLocation, List<Resource>> $$3 : $$22.listMatchingResourceStacks($$02).entrySet()) {
            ResourceLocation $$4 = $$3.getKey();
            ResourceLocation $$5 = $$22.fileToId($$4);
            for (Resource $$6 : $$3.getValue()) {
                try {
                    BufferedReader $$7 = $$6.openAsReader();
                    try {
                        JsonElement $$8 = JsonParser.parseReader((Reader)$$7);
                        List $$9 = $$1.computeIfAbsent($$5, $$0 -> new ArrayList());
                        TagFile $$10 = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)$$8)).getOrThrow();
                        if ($$10.replace()) {
                            $$9.clear();
                        }
                        String $$11 = $$6.sourcePackId();
                        $$10.entries().forEach($$2 -> $$9.add(new EntryWithSource((TagEntry)$$2, $$11)));
                    }
                    finally {
                        if ($$7 == null) continue;
                        ((Reader)$$7).close();
                    }
                }
                catch (Exception $$12) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{$$5, $$4, $$6.sourcePackId(), $$12});
                }
            }
        }
        return $$1;
    }

    private Either<Collection<EntryWithSource>, Collection<T>> build(TagEntry.Lookup<T> $$0, List<EntryWithSource> $$1) {
        ImmutableSet.Builder $$2 = ImmutableSet.builder();
        ArrayList<EntryWithSource> $$3 = new ArrayList<EntryWithSource>();
        for (EntryWithSource $$4 : $$1) {
            if ($$4.entry().build($$0, arg_0 -> ((ImmutableSet.Builder)$$2).add(arg_0))) continue;
            $$3.add($$4);
        }
        return $$3.isEmpty() ? Either.right((Object)$$2.build()) : Either.left($$3);
    }

    public Map<ResourceLocation, Collection<T>> build(Map<ResourceLocation, List<EntryWithSource>> $$0) {
        final HashMap $$12 = Maps.newHashMap();
        TagEntry.Lookup $$23 = new TagEntry.Lookup<T>(){

            @Override
            @Nullable
            public T element(ResourceLocation $$0) {
                return TagLoader.this.idToValue.apply($$0).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(ResourceLocation $$0) {
                return (Collection)$$12.get($$0);
            }
        };
        DependencySorter<ResourceLocation, SortingEntry> $$32 = new DependencySorter<ResourceLocation, SortingEntry>();
        $$0.forEach(($$1, $$2) -> $$32.addEntry((ResourceLocation)$$1, new SortingEntry((List<EntryWithSource>)$$2)));
        $$32.orderByDependencies(($$22, $$3) -> this.build($$23, $$3.entries).ifLeft($$1 -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", $$22, (Object)$$1.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight($$2 -> $$12.put($$22, $$2)));
        return $$12;
    }

    public Map<ResourceLocation, Collection<T>> loadAndBuild(ResourceManager $$0) {
        return this.build(this.load($$0));
    }

    public record EntryWithSource(TagEntry entry, String source) {
        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }
    }

    record SortingEntry(List<EntryWithSource> entries) implements DependencySorter.Entry<ResourceLocation>
    {
        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> $$0) {
            this.entries.forEach($$1 -> $$1.entry.visitRequiredDependencies($$0));
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> $$0) {
            this.entries.forEach($$1 -> $$1.entry.visitOptionalDependencies($$0));
        }
    }
}

