/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.stream.Stream;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;

public interface StringReaderTerms {
    public static Term<StringReader> word(String $$0) {
        return new TerminalWord($$0);
    }

    public static Term<StringReader> character(char $$0) {
        return new TerminalCharacter($$0);
    }

    public record TerminalWord(String value) implements Term<StringReader>
    {
        @Override
        public boolean parse(ParseState<StringReader> $$02, Scope $$1, Control $$2) {
            $$02.input().skipWhitespace();
            int $$3 = $$02.mark();
            String $$4 = $$02.input().readUnquotedString();
            if (!$$4.equals(this.value)) {
                $$02.errorCollector().store($$3, $$0 -> Stream.of(this.value), (Object)CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect().create((Object)this.value));
                return false;
            }
            return true;
        }
    }

    public record TerminalCharacter(char value) implements Term<StringReader>
    {
        @Override
        public boolean parse(ParseState<StringReader> $$02, Scope $$1, Control $$2) {
            $$02.input().skipWhitespace();
            int $$3 = $$02.mark();
            if (!$$02.input().canRead() || $$02.input().read() != this.value) {
                $$02.errorCollector().store($$3, $$0 -> Stream.of(String.valueOf(this.value)), (Object)CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect().create((Object)Character.valueOf(this.value)));
                return false;
            }
            return true;
        }
    }
}

