/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 10.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedToIt() {
        return this.canBeLeashed() && !this.isLeashed();
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int $$0) {
        this.setLeashData(new LeashData($$0));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    @Nullable
    default public LeashData readLeashData(CompoundTag $$0) {
        Either $$1;
        if ($$0.contains(LEASH_TAG, 10)) {
            return new LeashData((Either<UUID, BlockPos>)Either.left((Object)$$0.getCompound(LEASH_TAG).getUUID("UUID")));
        }
        if ($$0.contains(LEASH_TAG, 11) && ($$1 = (Either)NbtUtils.readBlockPos($$0, LEASH_TAG).map(Either::right).orElse(null)) != null) {
            return new LeashData((Either<UUID, BlockPos>)$$1);
        }
        return null;
    }

    default public void writeLeashData(CompoundTag $$02, @Nullable LeashData $$1) {
        if ($$1 == null) {
            return;
        }
        Either $$2 = $$1.delayedLeashInfo;
        Entity entity = $$1.leashHolder;
        if (entity instanceof LeashFenceKnotEntity) {
            LeashFenceKnotEntity $$3 = (LeashFenceKnotEntity)entity;
            $$2 = Either.right((Object)$$3.getPos());
        } else if ($$1.leashHolder != null) {
            $$2 = Either.left((Object)$$1.leashHolder.getUUID());
        }
        if ($$2 == null) {
            return;
        }
        $$02.put(LEASH_TAG, (Tag)$$2.map($$0 -> {
            CompoundTag $$1 = new CompoundTag();
            $$1.putUUID("UUID", (UUID)$$0);
            return $$1;
        }, NbtUtils::writeBlockPos));
    }

    private static <E extends Entity> void restoreLeashFromSave(E $$0, LeashData $$1) {
        Level level;
        if ($$1.delayedLeashInfo != null && (level = $$0.level()) instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            Optional $$3 = $$1.delayedLeashInfo.left();
            Optional $$4 = $$1.delayedLeashInfo.right();
            if ($$3.isPresent()) {
                Entity $$5 = $$2.getEntity((UUID)$$3.get());
                if ($$5 != null) {
                    Leashable.setLeashedTo($$0, $$5, true);
                    return;
                }
            } else if ($$4.isPresent()) {
                Leashable.setLeashedTo($$0, LeashFenceKnotEntity.getOrCreateKnot($$2, (BlockPos)$$4.get()), true);
                return;
            }
            if ($$0.tickCount > 100) {
                $$0.spawnAtLocation(Items.LEAD);
                ((Leashable)((Object)$$0)).setLeashData(null);
            }
        }
    }

    default public void dropLeash(boolean $$0, boolean $$1) {
        Leashable.dropLeash((Entity)((Object)this), $$0, $$1);
    }

    private static <E extends Entity> void dropLeash(E $$0, boolean $$1, boolean $$2) {
        LeashData $$3 = ((Leashable)((Object)$$0)).getLeashData();
        if ($$3 != null && $$3.leashHolder != null) {
            Level level;
            ((Leashable)((Object)$$0)).setLeashData(null);
            if (!$$0.level().isClientSide && $$2) {
                $$0.spawnAtLocation(Items.LEAD);
            }
            if ($$1 && (level = $$0.level()) instanceof ServerLevel) {
                ServerLevel $$4 = (ServerLevel)level;
                $$4.getChunkSource().broadcast($$0, new ClientboundSetEntityLinkPacket($$0, null));
            }
        }
    }

    public static <E extends Entity> void tickLeash(E $$0) {
        Entity $$2;
        LeashData $$1 = ((Leashable)((Object)$$0)).getLeashData();
        if ($$1 != null && $$1.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave($$0, $$1);
        }
        if ($$1 == null || $$1.leashHolder == null) {
            return;
        }
        if (!$$0.isAlive() || !$$1.leashHolder.isAlive()) {
            Leashable.dropLeash($$0, true, true);
        }
        if (($$2 = ((Leashable)((Object)$$0)).getLeashHolder()) != null && $$2.level() == $$0.level()) {
            float $$3 = $$0.distanceTo($$2);
            if (!((Leashable)((Object)$$0)).handleLeashAtDistance($$2, $$3)) {
                return;
            }
            if ((double)$$3 > 10.0) {
                ((Leashable)((Object)$$0)).leashTooFarBehaviour();
            } else if ((double)$$3 > 6.0) {
                ((Leashable)((Object)$$0)).elasticRangeLeashBehaviour($$2, $$3);
                $$0.checkSlowFallDistance();
            } else {
                ((Leashable)((Object)$$0)).closeRangeLeashBehaviour($$2);
            }
        }
    }

    default public boolean handleLeashAtDistance(Entity $$0, float $$1) {
        return true;
    }

    default public void leashTooFarBehaviour() {
        this.dropLeash(true, true);
    }

    default public void closeRangeLeashBehaviour(Entity $$0) {
    }

    default public void elasticRangeLeashBehaviour(Entity $$0, float $$1) {
        Leashable.legacyElasticRangeLeashBehaviour((Entity)((Object)this), $$0, $$1);
    }

    private static <E extends Entity> void legacyElasticRangeLeashBehaviour(E $$0, Entity $$1, float $$2) {
        double $$3 = ($$1.getX() - $$0.getX()) / (double)$$2;
        double $$4 = ($$1.getY() - $$0.getY()) / (double)$$2;
        double $$5 = ($$1.getZ() - $$0.getZ()) / (double)$$2;
        $$0.setDeltaMovement($$0.getDeltaMovement().add(Math.copySign($$3 * $$3 * 0.4, $$3), Math.copySign($$4 * $$4 * 0.4, $$4), Math.copySign($$5 * $$5 * 0.4, $$5)));
    }

    default public void setLeashedTo(Entity $$0, boolean $$1) {
        Leashable.setLeashedTo((Entity)((Object)this), $$0, $$1);
    }

    private static <E extends Entity> void setLeashedTo(E $$0, Entity $$1, boolean $$2) {
        Level level;
        LeashData $$3 = ((Leashable)((Object)$$0)).getLeashData();
        if ($$3 == null) {
            $$3 = new LeashData($$1);
            ((Leashable)((Object)$$0)).setLeashData($$3);
        } else {
            $$3.setLeashHolder($$1);
        }
        if ($$2 && (level = $$0.level()) instanceof ServerLevel) {
            ServerLevel $$4 = (ServerLevel)level;
            $$4.getChunkSource().broadcast($$0, new ClientboundSetEntityLinkPacket($$0, $$1));
        }
        if ($$0.isPassenger()) {
            $$0.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E $$0) {
        Entity entity;
        LeashData $$1 = ((Leashable)((Object)$$0)).getLeashData();
        if ($$1 == null) {
            return null;
        }
        if ($$1.delayedLeashHolderId != 0 && $$0.level().isClientSide && (entity = $$0.level().getEntity($$1.delayedLeashHolderId)) instanceof Entity) {
            Entity $$2 = entity;
            $$1.setLeashHolder($$2);
        }
        return $$1.leashHolder;
    }

    public static final class LeashData {
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;

        LeashData(Either<UUID, BlockPos> $$0) {
            this.delayedLeashInfo = $$0;
        }

        LeashData(Entity $$0) {
            this.leashHolder = $$0;
        }

        LeashData(int $$0) {
            this.delayedLeashHolderId = $$0;
        }

        public void setLeashHolder(Entity $$0) {
            this.leashHolder = $$0;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }
}

