/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ShapelessRecipe
implements CraftingRecipe {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;

    public ShapelessRecipe(String $$0, CraftingBookCategory $$1, ItemStack $$2, NonNullList<Ingredient> $$3) {
        this.group = $$0;
        this.category = $$1;
        this.result = $$2;
        this.ingredients = $$3;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPELESS_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider $$0) {
        return this.result;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(CraftingInput $$0, Level $$1) {
        if ($$0.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if ($$0.size() == 1 && this.ingredients.size() == 1) {
            return ((Ingredient)this.ingredients.getFirst()).test($$0.getItem(0));
        }
        return $$0.stackedContents().canCraft(this, null);
    }

    @Override
    public ItemStack assemble(CraftingInput $$0, HolderLookup.Provider $$1) {
        return this.result.copy();
    }

    @Override
    public boolean canCraftInDimensions(int $$0, int $$1) {
        return $$0 * $$1 >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessRecipe> {
        private static final MapCodec<ShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec($$03 -> $$03.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter($$0 -> $$0.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter($$0 -> $$0.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter($$0 -> $$0.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap($$02 -> {
            Ingredient[] $$1 = (Ingredient[])$$02.stream().filter($$0 -> !$$0.isEmpty()).toArray(Ingredient[]::new);
            if ($$1.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            if ($$1.length > 9) {
                return DataResult.error(() -> "Too many ingredients for shapeless recipe");
            }
            return DataResult.success(NonNullList.of(Ingredient.EMPTY, $$1));
        }, DataResult::success).forGetter($$0 -> $$0.ingredients)).apply((Applicative)$$03, ShapelessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<ShapelessRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessRecipe fromNetwork(RegistryFriendlyByteBuf $$0) {
            String $$12 = $$0.readUtf();
            CraftingBookCategory $$2 = $$0.readEnum(CraftingBookCategory.class);
            int $$3 = $$0.readVarInt();
            NonNullList<Ingredient> $$4 = NonNullList.withSize($$3, Ingredient.EMPTY);
            $$4.replaceAll($$1 -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0));
            ItemStack $$5 = (ItemStack)ItemStack.STREAM_CODEC.decode($$0);
            return new ShapelessRecipe($$12, $$2, $$5, $$4);
        }

        private static void toNetwork(RegistryFriendlyByteBuf $$0, ShapelessRecipe $$1) {
            $$0.writeUtf($$1.group);
            $$0.writeEnum($$1.category);
            $$0.writeVarInt($$1.ingredients.size());
            for (Ingredient $$2 : $$1.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$2);
            }
            ItemStack.STREAM_CODEC.encode($$0, $$1.result);
        }
    }
}

