/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V2842 {
    protected static final int VERSION = 2842;

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2842){

            @Override
            public MapType<String> convert(MapType<String> root, long sourceVersion, long toVersion) {
                MapType<String> level = root.getMap("Level");
                root.remove("Level");
                if (!root.isEmpty()) {
                    for (String key : root.keys()) {
                        if (level.hasKey(key)) continue;
                        level.setGeneric(key, root.getGeneric(key));
                    }
                }
                RenameHelper.renameSingle(level, "TileEntities", "block_entities");
                RenameHelper.renameSingle(level, "TileTicks", "block_ticks");
                RenameHelper.renameSingle(level, "Entities", "entities");
                RenameHelper.renameSingle(level, "Sections", "sections");
                RenameHelper.renameSingle(level, "Structures", "structures");
                MapType<String> structures = level.getMap("structures");
                if (structures != null) {
                    RenameHelper.renameSingle(structures, "Starts", "starts");
                }
                return level;
            }
        });
        MCTypeRegistry.CHUNK.addStructureWalker(2842, (data, fromVersion, toVersion) -> {
            ListType sections;
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, (MapType<String>)data, "entities", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.TILE_ENTITY, (MapType<String>)data, "block_entities", fromVersion, toVersion);
            ListType blockTicks = data.getList("block_ticks", ObjectType.MAP);
            if (blockTicks != null) {
                int len = blockTicks.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, blockTicks.getMap(i2), "i", fromVersion, toVersion);
                }
            }
            if ((sections = data.getList("sections", ObjectType.MAP)) != null) {
                int len = sections.size();
                for (int i3 = 0; i3 < len; ++i3) {
                    MapType section = sections.getMap(i3);
                    WalkerUtils.convertList(MCTypeRegistry.BIOME, section.getMap("biomes"), "palette", fromVersion, toVersion);
                    WalkerUtils.convertList(MCTypeRegistry.BLOCK_STATE, section.getMap("block_states"), "palette", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertValues(MCTypeRegistry.STRUCTURE_FEATURE, data.getMap("structures"), "starts", fromVersion, toVersion);
            return null;
        });
    }
}

