/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public final class BlockStarLightEngine
extends StarLightEngine {
    protected final BlockPosition.MutableBlockPosition recalcCenterPos = new BlockPosition.MutableBlockPosition();
    protected final BlockPosition.MutableBlockPosition recalcNeighbourPos = new BlockPosition.MutableBlockPosition();

    public BlockStarLightEngine(World world) {
        super(false, world);
    }

    @Override
    protected boolean[] getEmptinessMap(IChunkAccess chunk) {
        return chunk.getBlockEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(IChunkAccess chunk, boolean[] to) {
        chunk.setBlockEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(IChunkAccess chunk) {
        return chunk.getBlockNibbles();
    }

    @Override
    protected void setNibbles(IChunkAccess chunk, SWMRNibbleArray[] to) {
        chunk.setBlockNibbles(to);
    }

    @Override
    protected boolean canUseChunk(IChunkAccess chunk) {
        return chunk.j().b(ChunkStatus.l) && (this.isClientSide || chunk.v());
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setHidden();
        }
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            this.setNibbleInCache(chunkX, chunkY, chunkZ, new SWMRNibbleArray());
        } else {
            nibble.setNonNull();
        }
    }

    @Override
    protected final void checkBlock(ILightAccess lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int emittedMask = this.emittedLightMask;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        IBlockData blockState = this.getBlockState(worldX, worldY, worldZ);
        int emittedLevel = blockState.g() & emittedMask;
        this.setLightLevel(worldX, worldY, worldZ, emittedLevel);
        if (emittedLevel != 0) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLevel & 0xFL) << 28 | 0x3F00000000L | (blockState.isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(ILightAccess lightAccess, int worldX, int worldY, int worldZ, int expect) {
        IBlockData conditionallyOpaqueState;
        IBlockData centerState = this.getBlockState(worldX, worldY, worldZ);
        int level = centerState.g() & 0xF;
        if (level >= 14 || level > expect) {
            return level;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        int opacity = centerState.getOpacityIfCached();
        if (opacity == -1) {
            this.recalcCenterPos.d(worldX, worldY, worldZ);
            opacity = centerState.b(lightAccess.q(), (BlockPosition)this.recalcCenterPos);
            conditionallyOpaqueState = centerState.isConditionallyFullOpaque() ? centerState : null;
        } else {
            if (opacity >= 15) {
                return level;
            }
            conditionallyOpaqueState = null;
        }
        opacity = Math.max(1, opacity);
        for (StarLightEngine.AxisDirection direction : StarLightEngine.AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            IBlockData neighbourState = this.getBlockState(offX, offY, offZ);
            if (neighbourState.isConditionallyFullOpaque()) {
                VoxelShape thisFace;
                this.recalcNeighbourPos.d(offX, offY, offZ);
                VoxelShape neighbourFace = neighbourState.a(lightAccess.q(), (BlockPosition)this.recalcNeighbourPos, direction.opposite.nms);
                VoxelShape voxelShape = thisFace = conditionallyOpaqueState == null ? VoxelShapes.a() : conditionallyOpaqueState.a(lightAccess.q(), (BlockPosition)this.recalcCenterPos, direction.nms);
                if (VoxelShapes.b(thisFace, neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(ILightAccess lightAccess, IChunkAccess atChunk, Set<BlockPosition> positions) {
        for (BlockPosition pos : positions) {
            this.checkBlock(lightAccess, pos.u(), pos.v(), pos.w());
        }
        this.performLightDecrease(lightAccess);
    }

    protected Iterator<BlockPosition> getSources(ILightAccess lightAccess, IChunkAccess chunk) {
        if (chunk instanceof ProtoChunkExtension || chunk instanceof Chunk) {
            ArrayList<BlockPosition> sources = new ArrayList<BlockPosition>();
            int offX = chunk.f().e << 4;
            int offZ = chunk.f().f << 4;
            ChunkSection[] sections = chunk.d();
            for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
                ChunkSection section = sections[sectionY - this.minSection];
                if (section == null || section.c()) continue;
                DataPaletteBlock<IBlockData> states = section.i;
                int offY = sectionY << 4;
                for (int index = 0; index < 4096; ++index) {
                    IBlockData state = states.a(index);
                    if (state.g() <= 0) continue;
                    sources.add(new BlockPosition(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF));
                }
            }
            return sources.iterator();
        }
        while (true) {
            try {
                return chunk.n().collect(Collectors.toList()).iterator();
            }
            catch (Exception cme) {
                continue;
            }
            break;
        }
    }

    @Override
    public void lightChunk(ILightAccess lightAccess, IChunkAccess chunk, boolean needsEdgeChecks) {
        int emittedMask = this.emittedLightMask;
        Iterator<BlockPosition> positions = this.getSources(lightAccess, chunk);
        while (positions.hasNext()) {
            BlockPosition pos = positions.next();
            IBlockData blockState = this.getBlockState(pos.u(), pos.v(), pos.w());
            int emittedLight = blockState.g() & emittedMask;
            if (emittedLight <= this.getLightLevel(pos.u(), pos.v(), pos.w())) continue;
            this.appendToIncreaseQueue((long)(pos.u() + (pos.w() << 6) + (pos.v() << 12) + this.coordinateOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (blockState.isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
            this.setLightLevel(pos.u(), pos.v(), pos.w(), emittedLight);
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            this.checkChunkEdges(lightAccess, chunk, this.minLightSection, this.maxLightSection);
        } else {
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, this.maxLightSection);
            this.performLightIncrease(lightAccess);
        }
    }
}

