/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;

public class PaperVersionFetcher
implements VersionFetcher {
    private static final Pattern VER_PATTERN = Pattern.compile("^([0-9\\.]*)\\-.*R");
    private static final String GITHUB_BRANCH_NAME = "master";
    private static final String DOWNLOAD_PAGE = "https://papermc.io/downloads/paper";
    @Nullable
    private static String mcVer;

    public long getCacheTime() {
        return 720000L;
    }

    @Nonnull
    public Component getVersionMessage(@Nonnull String serverVersion) {
        String[] parts = serverVersion.substring("git-Leaves-".length()).split("[-\\s]");
        Component updateMessage = PaperVersionFetcher.getUpdateStatusMessage("LeavesMC/Leaves", GITHUB_BRANCH_NAME, parts[0]);
        Component history = this.getHistory();
        return history != null ? TextComponent.ofChildren((ComponentLike[])new ComponentLike[]{updateMessage, Component.newline(), history}) : updateMessage;
    }

    @Nullable
    private static String getMinecraftVersion() {
        if (mcVer == null) {
            Matcher matcher = VER_PATTERN.matcher(Bukkit.getBukkitVersion());
            if (matcher.find()) {
                String result = matcher.group();
                mcVer = result.substring(0, result.length() - 2);
            } else {
                Bukkit.getLogger().warning("Unable to match version to pattern! Report to PaperMC!");
                Bukkit.getLogger().warning("Pattern: " + VER_PATTERN.toString());
                Bukkit.getLogger().warning("Version: " + Bukkit.getBukkitVersion());
            }
        }
        return mcVer;
    }

    private static Component getUpdateStatusMessage(@Nonnull String repo, @Nonnull String branch, @Nonnull String versionInfo) {
        versionInfo = versionInfo.replace("\"", "");
        int distance = PaperVersionFetcher.fetchDistanceFromGitHub(repo, branch, versionInfo);
        switch (distance) {
            case -1: {
                return Component.text((String)"Error obtaining version information", (TextColor)NamedTextColor.YELLOW);
            }
            case 0: {
                return Component.text((String)"You are running the latest version", (TextColor)NamedTextColor.GREEN);
            }
            case -2: {
                return Component.text((String)"Unknown version", (TextColor)NamedTextColor.YELLOW);
            }
        }
        return Component.text((String)("You are " + distance + " version(s) behind"), (TextColor)NamedTextColor.YELLOW);
    }

    private static int fetchDistanceFromSiteApi(int jenkinsBuild, @Nullable String siteApiVersion) {
        int n2;
        block11: {
            if (siteApiVersion == null) {
                return -1;
            }
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://api.papermc.io/v2/projects/paper/versions/" + siteApiVersion), (Charset)Charsets.UTF_8).openBufferedStream();
            try {
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                JsonArray builds = json.getAsJsonArray("builds");
                int latest = StreamSupport.stream(builds.spliterator(), false).mapToInt(e2 -> e2.getAsInt()).max().getAsInt();
                n2 = latest - jenkinsBuild;
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonSyntaxException ex) {
                        ex.printStackTrace();
                        return -1;
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    return -1;
                }
            }
            reader.close();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int fetchDistanceFromGitHub(@Nonnull String repo, @Nonnull String branch, @Nonnull String hash) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.github.com/repos/" + repo + "/compare/" + branch + "..." + hash).openConnection();
            connection.connect();
            if (connection.getResponseCode() == 404) {
                return -2;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));){
                String status;
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                switch (status = obj.get("status").getAsString()) {
                    case "identical": {
                        int n2 = 0;
                        return n2;
                    }
                    case "behind": {
                        int n3 = obj.get("behind_by").getAsInt();
                        return n3;
                    }
                }
                int n4 = -1;
                return n4;
            }
            catch (JsonSyntaxException | NumberFormatException e2) {
                e2.printStackTrace();
                return -1;
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return -1;
        }
    }

    @Nullable
    private Component getHistory() {
        VersionHistoryManager.VersionData data = VersionHistoryManager.INSTANCE.getVersionData();
        if (data == null) {
            return null;
        }
        String oldVersion = data.getOldVersion();
        if (oldVersion == null) {
            return null;
        }
        return Component.text((String)("Previous version: " + oldVersion), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC});
    }
}

