/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.antixray;

import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.DataPalette;

public class ChunkPacketInfo<T> {
    private final ClientboundLevelChunkWithLightPacket chunkPacket;
    private final Chunk chunk;
    private final int[] bits;
    private final Object[] palettes;
    private final int[] indexes;
    private final Object[][] presetValues;
    private byte[] buffer;

    public ChunkPacketInfo(ClientboundLevelChunkWithLightPacket chunkPacket, Chunk chunk) {
        this.chunkPacket = chunkPacket;
        this.chunk = chunk;
        int sections = chunk.aj();
        this.bits = new int[sections];
        this.palettes = new Object[sections];
        this.indexes = new int[sections];
        this.presetValues = new Object[sections][];
    }

    public ClientboundLevelChunkWithLightPacket getChunkPacket() {
        return this.chunkPacket;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public int getBits(int chunkSectionIndex) {
        return this.bits[chunkSectionIndex];
    }

    public void setBits(int chunkSectionIndex, int bits) {
        this.bits[chunkSectionIndex] = bits;
    }

    public DataPalette<T> getPalette(int chunkSectionIndex) {
        return (DataPalette)this.palettes[chunkSectionIndex];
    }

    public void setPalette(int chunkSectionIndex, DataPalette<T> palette) {
        this.palettes[chunkSectionIndex] = palette;
    }

    public int getIndex(int chunkSectionIndex) {
        return this.indexes[chunkSectionIndex];
    }

    public void setIndex(int chunkSectionIndex, int index) {
        this.indexes[chunkSectionIndex] = index;
    }

    public T[] getPresetValues(int chunkSectionIndex) {
        return this.presetValues[chunkSectionIndex];
    }

    public void setPresetValues(int chunkSectionIndex, T[] presetValues) {
        this.presetValues[chunkSectionIndex] = presetValues;
    }

    public boolean isWritten(int chunkSectionIndex) {
        return this.bits[chunkSectionIndex] != 0;
    }
}

